/*
 * Decompiled with CFR 0.152.
 */
package org.exquery.restxq.impl.annotation;

import java.util.List;
import org.exquery.http.HttpRequest;
import org.exquery.restxq.RestXqErrorCodes;
import org.exquery.restxq.impl.annotation.AbstractParameterWithDefaultAnnotation;
import org.exquery.xdm.type.SequenceImpl;
import org.exquery.xdm.type.StringTypedValue;
import org.exquery.xquery.Literal;
import org.exquery.xquery.Sequence;
import org.exquery.xquery.TypedArgumentValue;
import org.exquery.xquery.TypedValue;

public class QueryParameterAnnotation
extends AbstractParameterWithDefaultAnnotation {
    public TypedArgumentValue<String> extractParameter(final HttpRequest request) {
        return new TypedArgumentValue<String>(){

            public String getArgumentName() {
                return QueryParameterAnnotation.this.getParameterAnnotationMapping().getFunctionArgumentName();
            }

            public Sequence<String> getTypedValue() {
                Object queryParam = request.getQueryParam(QueryParameterAnnotation.this.getParameterAnnotationMapping().getParameterName());
                if (queryParam == null) {
                    Literal[] defaultLiterals = QueryParameterAnnotation.this.getParameterAnnotationMapping().getDefaultValues();
                    if (defaultLiterals.length > 0) {
                        return QueryParameterAnnotation.this.literalsToSequence(defaultLiterals);
                    }
                    return Sequence.EMPTY_SEQUENCE;
                }
                if (queryParam instanceof String) {
                    return new SequenceImpl((TypedValue)new StringTypedValue((String)queryParam));
                }
                if (queryParam instanceof List) {
                    List queryParamValues = (List)queryParam;
                    return QueryParameterAnnotation.this.collectionToSequence(queryParamValues);
                }
                return null;
            }
        };
    }

    @Override
    protected RestXqErrorCodes.RestXqErrorCode getInvalidAnnotationParamsErr() {
        return RestXqErrorCodes.RQST0021;
    }

    @Override
    protected RestXqErrorCodes.RestXqErrorCode getInvalidParameterNameErr() {
        return RestXqErrorCodes.RQST0022;
    }

    @Override
    protected RestXqErrorCodes.RestXqErrorCode getInvalidFunctionArgumentNameErr() {
        return RestXqErrorCodes.RQST0023;
    }

    @Override
    protected RestXqErrorCodes.RestXqErrorCode getInvalidDefaultValueErr() {
        return RestXqErrorCodes.RQST0024;
    }

    @Override
    protected RestXqErrorCodes.RestXqErrorCode getInvalidDefaultValueTypeErr() {
        return RestXqErrorCodes.RQST0025;
    }

    @Override
    protected RestXqErrorCodes.RestXqErrorCode getInvalidAnnotationParametersSyntaxErr() {
        return RestXqErrorCodes.RQST0026;
    }
}

