/*
 * Decompiled with CFR 0.152.
 */
package org.exquery.restxq.impl.serialization;

import java.io.IOException;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.exquery.InternetMediaType;
import org.exquery.http.ContentTypeHeader;
import org.exquery.http.HttpResponse;
import org.exquery.restxq.RestXqServiceException;
import org.exquery.restxq.RestXqServiceSerializer;
import org.exquery.restxq.impl.serialization.RestResponseHandler;
import org.exquery.restxq.impl.serialization.SerializationProperty;
import org.exquery.restxq.impl.serialization.XmlWriter;
import org.exquery.serialization.annotation.AbstractYesNoSerializationAnnotation;
import org.exquery.serialization.annotation.EncodingAnnotation;
import org.exquery.serialization.annotation.IndentAnnotation;
import org.exquery.serialization.annotation.MediaTypeAnnotation;
import org.exquery.serialization.annotation.MethodAnnotation;
import org.exquery.serialization.annotation.OmitXmlDeclarationAnnotation;
import org.exquery.serialization.annotation.SerializationAnnotation;
import org.exquery.xquery.Sequence;
import org.exquery.xquery.Type;
import org.exquery.xquery.TypedValue;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractRestXqServiceSerializer
implements RestXqServiceSerializer {
    private static final String DEFAULT_ENCODING = "UTF-8";
    private static final String DEFAULT_INTERNET_MEDIA_TYPE = InternetMediaType.APPLICATION_XML.getMediaType();
    private static final String DEFAULT_CONTENT_TYPE = DEFAULT_INTERNET_MEDIA_TYPE + "; charset=" + "UTF-8";
    private static final Map<SerializationProperty, String> DEFAULT_SERIALIZATION_PROPERTIES = new EnumMap<SerializationProperty, String>(SerializationProperty.class);

    protected String getDefaultEncoding() {
        return DEFAULT_ENCODING;
    }

    protected String getDefaultContentType() {
        return DEFAULT_CONTENT_TYPE;
    }

    protected Map<SerializationProperty, String> getDefaultSerializationProperties() {
        return DEFAULT_SERIALIZATION_PROPERTIES;
    }

    public void serialize(Sequence result, Set<SerializationAnnotation> serializationAnnotations, HttpResponse response) throws RestXqServiceException {
        if (response.isCommitted()) {
            return;
        }
        Iterator itResult = result.iterator();
        if (itResult.hasNext()) {
            TypedValue firstResultPart = (TypedValue)itResult.next();
            Element elem = null;
            if (firstResultPart.getType().equals((Object)Type.DOCUMENT)) {
                elem = ((Document)firstResultPart.getValue()).getDocumentElement();
            } else if (firstResultPart.getType().equals((Object)Type.ELEMENT)) {
                elem = (Element)firstResultPart.getValue();
            }
            EnumMap<SerializationProperty, String> serializationProperties = new EnumMap<SerializationProperty, String>(SerializationProperty.class);
            serializationProperties.putAll(this.getDefaultSerializationProperties());
            if (elem != null && new QName(elem.getNamespaceURI(), elem.getLocalName()).equals(RestResponseHandler.REST_RESPONSE_ELEMENT_NAME)) {
                this.processSerializationAnnotations(serializationAnnotations, serializationProperties);
                new RestResponseHandler().process(elem, serializationProperties, response);
                if (itResult.hasNext()) {
                    Sequence seqBody = result.tail();
                    this.serializeBody(seqBody, response, serializationProperties);
                }
            } else {
                this.processSerializationAnnotations(serializationAnnotations, serializationProperties);
                this.serializeBody(result, response, serializationProperties);
            }
        }
    }

    protected void processSerializationAnnotations(Set<SerializationAnnotation> serializationAnnotations, Map<SerializationProperty, String> serializationProperties) {
        String mediaType = null;
        for (SerializationAnnotation serializationAnnotation : serializationAnnotations) {
            if (serializationAnnotation instanceof MethodAnnotation) {
                String methodProp = ((MethodAnnotation)serializationAnnotation).getMethod();
                serializationProperties.put(SerializationProperty.METHOD, methodProp);
                MethodAnnotation.SupportedMethod method = null;
                try {
                    method = methodProp == null ? MethodAnnotation.SupportedMethod.xml : MethodAnnotation.SupportedMethod.valueOf((String)methodProp);
                    String defaultMethodMediaType = AbstractRestXqServiceSerializer.getDefaultMediaTypeForMethod(method);
                    serializationProperties.put(SerializationProperty.MEDIA_TYPE, defaultMethodMediaType);
                }
                catch (IllegalArgumentException iae) {
                    System.out.println(iae.getMessage());
                }
                continue;
            }
            if (serializationAnnotation instanceof MediaTypeAnnotation) {
                mediaType = ((MediaTypeAnnotation)serializationAnnotation).getValue();
                continue;
            }
            if (serializationAnnotation instanceof EncodingAnnotation) {
                serializationProperties.put(SerializationProperty.ENCODING, ((EncodingAnnotation)serializationAnnotation).getValue());
                continue;
            }
            if (!(serializationAnnotation instanceof AbstractYesNoSerializationAnnotation)) continue;
            AbstractYesNoSerializationAnnotation yesNoSerializationAnnotation = (AbstractYesNoSerializationAnnotation)serializationAnnotation;
            if (yesNoSerializationAnnotation instanceof IndentAnnotation) {
                serializationProperties.put(SerializationProperty.INDENT, yesNoSerializationAnnotation.getStringValue());
                continue;
            }
            if (!(yesNoSerializationAnnotation instanceof OmitXmlDeclarationAnnotation)) continue;
            serializationProperties.put(SerializationProperty.OMIT_XML_DECLARATION, yesNoSerializationAnnotation.getStringValue());
        }
        if (mediaType != null) {
            serializationProperties.put(SerializationProperty.MEDIA_TYPE, mediaType);
        }
    }

    public static String getDefaultMediaTypeForMethod(MethodAnnotation.SupportedMethod method) {
        String mediaType = method != null ? (method.equals((Object)MethodAnnotation.SupportedMethod.binary) ? InternetMediaType.APPLICATION_OCTET_STREAM.getMediaType() : method.getDefaultInternetMediaType().getMediaType()) : DEFAULT_CONTENT_TYPE;
        return mediaType;
    }

    protected void serializeBody(Sequence result, HttpResponse response, Map<SerializationProperty, String> serializationProperties) throws RestXqServiceException {
        MethodAnnotation.SupportedMethod method = null;
        try {
            String methodProp = serializationProperties.get((Object)SerializationProperty.METHOD);
            method = methodProp == null ? MethodAnnotation.SupportedMethod.xml : MethodAnnotation.SupportedMethod.valueOf((String)methodProp);
        }
        catch (IllegalArgumentException iae) {
            System.out.println(iae.getMessage());
        }
        String mediaType = serializationProperties.get((Object)SerializationProperty.MEDIA_TYPE);
        if (mediaType != null && !mediaType.isEmpty()) {
            String encoding = serializationProperties.get((Object)SerializationProperty.ENCODING);
            response.setContentType(new ContentTypeHeader(mediaType, encoding).toString());
        }
        if (method != null && method.equals((Object)MethodAnnotation.SupportedMethod.binary)) {
            this.serializeBinaryBody(result, response);
        } else {
            this.serializeNodeBody(result, response, serializationProperties);
        }
    }

    protected abstract void serializeBinaryBody(Sequence var1, HttpResponse var2) throws RestXqServiceException;

    protected abstract void serializeNodeBody(Sequence var1, HttpResponse var2, Map<SerializationProperty, String> var3) throws RestXqServiceException;

    public void serializeExceptionResponse(Exception e, XmlWriter writer) throws RestXqServiceException {
        try {
            StackTraceElement[] trace;
            writer.setProperties(this.getDefaultSerializationProperties());
            QName qnResponse = new QName("response", "http://exquery.org/ns/restxq");
            QName qnException = new QName("exception", "http://exquery.org/ns/restxq/error");
            QName message = new QName("message", "http://exquery.org/ns/restxq/error");
            QName qnStack = new QName("stack", "http://exquery.org/ns/restxq/error");
            writer.startDocument();
            writer.startElement(qnResponse);
            writer.startElement(qnException);
            writer.startElement(message);
            writer.characters(e.getClass().getName() + ": " + e.getLocalizedMessage());
            for (StackTraceElement element : trace = e.getStackTrace()) {
                XmlWriter.Attribute[] attributes = new XmlWriter.Attribute[]{this.attribute(new QName("file"), element.getFileName()), this.attribute(new QName("class"), element.getClassName()), this.attribute(new QName("method"), element.getMethodName()), this.attribute(new QName("line"), Integer.toString(element.getLineNumber()))};
                writer.startElement(qnStack, attributes);
                writer.endElement();
            }
            writer.endElement();
            writer.endElement();
            writer.endElement();
            writer.endDocument();
        }
        catch (IOException ioe) {
            throw new RestXqServiceException("Error while serializing XML for exception '" + e.getClass().getName() + ":" + e.getMessage() + "': " + ioe.toString(), (Throwable)ioe);
        }
    }

    protected XmlWriter.Attribute attribute(final QName name, final String value) {
        return new XmlWriter.Attribute(){

            @Override
            public QName getName() {
                return name;
            }

            @Override
            public String getValue() {
                return value;
            }
        };
    }

    static {
        DEFAULT_SERIALIZATION_PROPERTIES.put(SerializationProperty.INDENT, "yes");
        DEFAULT_SERIALIZATION_PROPERTIES.put(SerializationProperty.ENCODING, DEFAULT_ENCODING);
        DEFAULT_SERIALIZATION_PROPERTIES.put(SerializationProperty.MEDIA_TYPE, DEFAULT_INTERNET_MEDIA_TYPE);
    }
}

