/*
 * Decompiled with CFR 0.152.
 */
package org.exquery.restxq.impl.serialization;

import java.util.EnumMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.exquery.http.ContentTypeHeader;
import org.exquery.http.HttpHeader;
import org.exquery.http.HttpResponse;
import org.exquery.http.HttpStatus;
import org.exquery.restxq.RestXqServiceException;
import org.exquery.restxq.impl.serialization.SerializationProperty;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RestResponseHandler {
    private static final String EXPATH_HTTP_CLIENT_NS_URI = "http://expath.org/ns/http-client";
    private static final String EXPATH_HTTP_CLIENT_NS_PREFIX = "http";
    public static QName REST_RESPONSE_ELEMENT_NAME = new QName("http://exquery.org/ns/restxq", "response");
    private static QName HTTP_RESPONSE_ELEMENT_NAME = new QName("http://expath.org/ns/http-client", "response");
    private static QName HTTP_HEADER_ELEMENT_NAME = new QName("http://expath.org/ns/http-client", "header");
    private static QName SERIALIZATION_PARAMETERS_ELEMENT_NAME = new QName("http://www.w3.org/2010/xslt-xquery-serialization", "serialization-parameters");
    private static QName METHOD_ELEMENT_NAME = new QName("http://www.w3.org/2010/xslt-xquery-serialization", "method");
    private static String STATUS_ATTR_NAME = "status";
    private static String REASON_ATTR_NAME = "reason";
    private static String NAME_ATTR_NAME = "name";
    private static String VALUE_ATTR_NAME = "value";

    public void process(Element restResponse, Map<SerializationProperty, String> serializationProperties, HttpResponse response) throws RestXqServiceException {
        NodeList nlHttpResponse;
        NodeList nlSerializationParameters = restResponse.getElementsByTagNameNS(SERIALIZATION_PARAMETERS_ELEMENT_NAME.getNamespaceURI(), SERIALIZATION_PARAMETERS_ELEMENT_NAME.getLocalPart());
        if (nlSerializationParameters.getLength() == 1) {
            serializationProperties.putAll(this.processSerializationParameters((Element)nlSerializationParameters.item(0)));
        }
        if ((nlHttpResponse = restResponse.getElementsByTagNameNS(HTTP_RESPONSE_ELEMENT_NAME.getNamespaceURI(), HTTP_RESPONSE_ELEMENT_NAME.getLocalPart())).getLength() == 1) {
            this.processHttpResponse((Element)nlHttpResponse.item(0), serializationProperties, response);
        }
    }

    protected final Map<SerializationProperty, String> processSerializationParameters(Element serializationParameters) {
        Element elemMethod;
        String strMethod;
        EnumMap<SerializationProperty, String> serializationProperties = new EnumMap<SerializationProperty, String>(SerializationProperty.class);
        NodeList nlMethod = serializationParameters.getElementsByTagNameNS(METHOD_ELEMENT_NAME.getNamespaceURI(), METHOD_ELEMENT_NAME.getLocalPart());
        if (nlMethod.getLength() == 1 && (strMethod = (elemMethod = (Element)nlMethod.item(0)).getAttribute(VALUE_ATTR_NAME)) != null && !strMethod.isEmpty()) {
            serializationProperties.put(SerializationProperty.METHOD, strMethod);
        }
        return serializationProperties;
    }

    protected void processHttpResponse(Element httpResponse, Map<SerializationProperty, String> serializationProperties, HttpResponse response) throws RestXqServiceException {
        String strStatus = httpResponse.getAttribute(STATUS_ATTR_NAME);
        HttpStatus httpStatus = null;
        if (strStatus != null && !strStatus.isEmpty()) {
            int status = Integer.parseInt(strStatus);
            try {
                httpStatus = HttpStatus.fromStatus((int)status);
            }
            catch (IllegalArgumentException iae) {
                throw new RestXqServiceException("Invalid HTTP Status in rest:response/@status: " + strStatus, (Throwable)iae);
            }
        }
        String reason = httpResponse.getAttribute(REASON_ATTR_NAME);
        if (httpStatus != null) {
            if (reason != null && !reason.isEmpty()) {
                response.setStatus(httpStatus, reason);
            } else {
                response.setStatus(httpStatus);
            }
        }
        NodeList nlHttpHeader = httpResponse.getElementsByTagNameNS(HTTP_HEADER_ELEMENT_NAME.getNamespaceURI(), HTTP_HEADER_ELEMENT_NAME.getLocalPart());
        this.processHttpHeaders(nlHttpHeader, serializationProperties, response);
    }

    protected void processHttpHeaders(NodeList nlHttpHeader, Map<SerializationProperty, String> serializationProperties, HttpResponse response) {
        for (int i = 0; i < nlHttpHeader.getLength(); ++i) {
            Element elemHeader = (Element)nlHttpHeader.item(i);
            String name = elemHeader.getAttribute(NAME_ATTR_NAME);
            String value = elemHeader.getAttribute(VALUE_ATTR_NAME);
            if (name.equals(HttpHeader.CONTENT_TYPE.getHeaderName())) {
                serializationProperties.put(SerializationProperty.MEDIA_TYPE, new ContentTypeHeader(value).getInternetMediaType());
            }
            response.setHeader(name, value);
        }
    }
}

