/*
 * Decompiled with CFR 0.152.
 */
package genericSQL;

import java.sql.Connection;
import java.util.Hashtable;
import org.apache.log4j.Logger;

public class GenericSQLModifier {
    private String databaseType_;
    private Hashtable datatypeConversion_;
    private String[] customDatatypes_;
    private String properQuote_;
    private static Logger log = Logger.getLogger((String)"convert.sqlMod");
    public static String mySqlLikeOverride;

    public GenericSQLModifier(Connection connection) throws Exception {
        this(connection.getMetaData().getDatabaseProductName());
    }

    public GenericSQLModifier(String databaseType) throws Exception {
        this.databaseType_ = databaseType;
        this.datatypeConversion_ = new Hashtable();
        this.customDatatypes_ = new String[]{"{boolean}", "{IF NOT EXISTS}", "{limitedText}", "{unlimitedText}", "{bigInt}", "{TYPE}", "{DROPFOREIGNKEY}", "{true}", "{false}", "{LIMIT}", "{DEFAULT_INDEX_SIZE}", "{LIKE}", "{BINARY}", "{CASCADE}", "{lgCharSet}", "{lgTableCharSet}", "{dateTime}", "{AS}"};
        if (this.databaseType_.equals("MySQL")) {
            this.properQuote_ = "`";
            this.datatypeConversion_.put("{boolean}", "tinyint(1)");
            this.datatypeConversion_.put("{IF NOT EXISTS}", "IF NOT EXISTS");
            this.datatypeConversion_.put("{limitedText}", "varchar");
            this.datatypeConversion_.put("{unlimitedText}", "text");
            this.datatypeConversion_.put("{bigInt}", "bigint(20)");
            this.datatypeConversion_.put("{TYPE}", "TYPE=InnoDB");
            this.datatypeConversion_.put("{DROPFOREIGNKEY}", "DROP FOREIGN KEY");
            this.datatypeConversion_.put("{true}", "1");
            this.datatypeConversion_.put("{false}", "0");
            this.datatypeConversion_.put("{LIMIT}", "LIMIT ?, ?");
            this.datatypeConversion_.put("{DEFAULT_INDEX_SIZE}", "(3)");
            this.datatypeConversion_.put("{LIKE}", mySqlLikeOverride == null || mySqlLikeOverride.length() == 0 ? "LIKE" : mySqlLikeOverride);
            this.datatypeConversion_.put("{BINARY}", "BINARY");
            this.datatypeConversion_.put("{CASCADE}", "CASCADE");
            this.datatypeConversion_.put("{lgCharSet}", "CHARACTER SET latin1 COLLATE latin1_bin");
            this.datatypeConversion_.put("{lgTableCharSet}", "CHARACTER SET latin1 COLLATE latin1_bin");
            this.datatypeConversion_.put("{dateTime}", "DATETIME");
            this.datatypeConversion_.put("{AS}", "AS");
        } else if (this.databaseType_.equals("ACCESS")) {
            this.properQuote_ = "`";
            this.datatypeConversion_.put("{boolean}", "Text(5)");
            this.datatypeConversion_.put("{IF NOT EXISTS}", "");
            this.datatypeConversion_.put("{limitedText}", "Text");
            this.datatypeConversion_.put("{unlimitedText}", "memo");
            this.datatypeConversion_.put("{bigInt}", "Number");
            this.datatypeConversion_.put("{TYPE}", "");
            this.datatypeConversion_.put("{DROPFOREIGNKEY}", "DROP CONSTRAINT");
            this.datatypeConversion_.put("{true}", "true");
            this.datatypeConversion_.put("{false}", "false");
            this.datatypeConversion_.put("{LIMIT}", "");
            this.datatypeConversion_.put("{DEFAULT_INDEX_SIZE}", "");
            this.datatypeConversion_.put("{LIKE}", "LIKE");
            this.datatypeConversion_.put("{BINARY}", "");
            this.datatypeConversion_.put("{CASCADE}", "CASCADE");
            this.datatypeConversion_.put("{lgCharSet}", "");
            this.datatypeConversion_.put("{lgTableCharSet}", "");
            this.datatypeConversion_.put("{dateTime}", "DATETIME");
            this.datatypeConversion_.put("{AS}", "AS");
            this.datatypeConversion_.put("[limitedTextLimit]", "255");
        } else if (this.databaseType_.equals("PostgreSQL")) {
            this.properQuote_ = "";
            this.datatypeConversion_.put("{boolean}", "bool");
            this.datatypeConversion_.put("{IF NOT EXISTS}", "");
            this.datatypeConversion_.put("{limitedText}", "varchar");
            this.datatypeConversion_.put("{unlimitedText}", "text");
            this.datatypeConversion_.put("{bigInt}", "int8");
            this.datatypeConversion_.put("{TYPE}", "");
            this.datatypeConversion_.put("{DROPFOREIGNKEY}", "DROP CONSTRAINT");
            this.datatypeConversion_.put("{true}", "'true'");
            this.datatypeConversion_.put("{false}", "'false'");
            this.datatypeConversion_.put("{LIMIT}", "");
            this.datatypeConversion_.put("{DEFAULT_INDEX_SIZE}", "");
            this.datatypeConversion_.put("{LIKE}", "ILIKE");
            this.datatypeConversion_.put("{BINARY}", "");
            this.datatypeConversion_.put("{CASCADE}", "CASCADE");
            this.datatypeConversion_.put("{lgCharSet}", "ENCODING='UTF8'");
            this.datatypeConversion_.put("{lgTableCharSet}", "");
            this.datatypeConversion_.put("{dateTime}", "TIMESTAMP");
            this.datatypeConversion_.put("{AS}", "AS");
        } else if (this.databaseType_.startsWith("DB2")) {
            this.properQuote_ = "";
            this.datatypeConversion_.put("{boolean}", "smallint");
            this.datatypeConversion_.put("{IF NOT EXISTS}", "");
            this.datatypeConversion_.put("{limitedText}", "varchar");
            this.datatypeConversion_.put("{unlimitedText}", "long varchar");
            this.datatypeConversion_.put("{bigInt}", "integer");
            this.datatypeConversion_.put("{TYPE}", "");
            this.datatypeConversion_.put("{DROPFOREIGNKEY}", "DROP CONSTRAINT");
            this.datatypeConversion_.put("{true}", "1");
            this.datatypeConversion_.put("{false}", "0");
            this.datatypeConversion_.put("{LIMIT}", "");
            this.datatypeConversion_.put("{DEFAULT_INDEX_SIZE}", "");
            this.datatypeConversion_.put("{LIKE}", "LIKE");
            this.datatypeConversion_.put("{BINARY}", "");
            this.datatypeConversion_.put("{CASCADE}", "");
            this.datatypeConversion_.put("{lgCharSet}", "");
            this.datatypeConversion_.put("{lgTableCharSet}", "");
            this.datatypeConversion_.put("{dateTime}", "TIMESTAMP");
            this.datatypeConversion_.put("{AS}", "AS");
        } else if (this.databaseType_.equals("Microsoft SQL Server")) {
            this.properQuote_ = "\"";
            this.datatypeConversion_.put("{boolean}", "tinyint");
            this.datatypeConversion_.put("{IF NOT EXISTS}", "");
            this.datatypeConversion_.put("{limitedText}", "varchar");
            this.datatypeConversion_.put("{unlimitedText}", "varchar(8000)");
            this.datatypeConversion_.put("{bigInt}", "bigint");
            this.datatypeConversion_.put("{TYPE}", "");
            this.datatypeConversion_.put("{DROPFOREIGNKEY}", "DROP CONSTRAINT");
            this.datatypeConversion_.put("{true}", "1");
            this.datatypeConversion_.put("{false}", "0");
            this.datatypeConversion_.put("{LIMIT}", "");
            this.datatypeConversion_.put("{DEFAULT_INDEX_SIZE}", "");
            this.datatypeConversion_.put("{LIKE}", "LIKE");
            this.datatypeConversion_.put("{BINARY}", "");
            this.datatypeConversion_.put("{CASCADE}", "CASCADE");
            this.datatypeConversion_.put("{lgCharSet}", "");
            this.datatypeConversion_.put("{lgTableCharSet}", "");
            this.datatypeConversion_.put("{dateTime}", "DATETIME");
            this.datatypeConversion_.put("{AS}", "AS");
        } else if (this.databaseType_.equals("HSQL Database Engine")) {
            this.properQuote_ = "";
            this.datatypeConversion_.put("{boolean}", "boolean");
            this.datatypeConversion_.put("{IF NOT EXISTS}", "");
            this.datatypeConversion_.put("{limitedText}", "varchar");
            this.datatypeConversion_.put("{unlimitedText}", "varchar_ignorecase");
            this.datatypeConversion_.put("{bigInt}", "bigint");
            this.datatypeConversion_.put("{TYPE}", "");
            this.datatypeConversion_.put("{DROPFOREIGNKEY}", "DROP CONSTRAINT");
            this.datatypeConversion_.put("{true}", "'true'");
            this.datatypeConversion_.put("{false}", "'false'");
            this.datatypeConversion_.put("{LIMIT}", "");
            this.datatypeConversion_.put("{DEFAULT_INDEX_SIZE}", "");
            this.datatypeConversion_.put("{LIKE}", "LIKE");
            this.datatypeConversion_.put("{BINARY}", "");
            this.datatypeConversion_.put("{CASCADE}", "CASCADE");
            this.datatypeConversion_.put("{dateTime}", "TIMESTAMP");
            this.datatypeConversion_.put("{lgCharSet}", "");
            this.datatypeConversion_.put("{lgTableCharSet}", "");
            this.datatypeConversion_.put("{AS}", "AS");
        } else if (this.databaseType_.startsWith("Oracle")) {
            this.properQuote_ = "";
            this.datatypeConversion_.put("{boolean}", "CHAR");
            this.datatypeConversion_.put("{IF NOT EXISTS}", "");
            this.datatypeConversion_.put("{limitedText}", "VARCHAR2");
            this.datatypeConversion_.put("{unlimitedText}", "CLOB");
            this.datatypeConversion_.put("{bigInt}", "NUMBER(37)");
            this.datatypeConversion_.put("{TYPE}", "");
            this.datatypeConversion_.put("{DROPFOREIGNKEY}", "DROP CONSTRAINT");
            this.datatypeConversion_.put("{true}", "1");
            this.datatypeConversion_.put("{false}", "0");
            this.datatypeConversion_.put("{LIMIT}", "");
            this.datatypeConversion_.put("{DEFAULT_INDEX_SIZE}", "");
            this.datatypeConversion_.put("{LIKE}", "LIKE");
            this.datatypeConversion_.put("{BINARY}", "");
            this.datatypeConversion_.put("{CASCADE}", "");
            this.datatypeConversion_.put("{lgCharSet}", "");
            this.datatypeConversion_.put("{lgTableCharSet}", "");
            this.datatypeConversion_.put("{dateTime}", "TIMESTAMP");
            this.datatypeConversion_.put("{AS}", "");
            this.datatypeConversion_.put("[limitedTextLimit]", "4000");
        } else {
            throw new Exception("Unsupported database type '" + this.databaseType_ + "' in the GenericSQLModifier.");
        }
    }

    public String getDatabaseType() {
        return this.databaseType_;
    }

    public String modifySQL(String sql, boolean logResult) {
        int secondLastSpace;
        int lastSpace;
        StringBuffer temp;
        int pos2;
        StringBuffer result = new StringBuffer(sql);
        int pos = result.indexOf("^");
        while (pos != -1) {
            result.replace(pos, pos + 1, this.properQuote_);
            pos = result.indexOf("^");
        }
        if (this.databaseType_.startsWith("DB2")) {
            pos = result.indexOf("  ");
            while (pos != -1) {
                result.replace(pos, pos + 2, " ");
                pos = result.indexOf("  ");
            }
            pos = 0;
            pos2 = result.indexOf("{LIKE}", pos);
            while (pos2 != -1) {
                temp = new StringBuffer(result.substring(0, pos2));
                lastSpace = temp.lastIndexOf(" ");
                temp.setLength(lastSpace);
                secondLastSpace = temp.lastIndexOf(" ") + 1;
                while (temp.charAt(secondLastSpace) == '(') {
                    ++secondLastSpace;
                }
                result.insert(secondLastSpace, "UCASE(varchar(");
                result.insert(lastSpace += "UCASE(varchar(".length(), "))");
                pos = pos2 + "UCASE(varchar())".length() + "{LIKE}".length();
                pos2 = result.indexOf("{LIKE}", pos);
            }
        } else if (this.databaseType_.startsWith("Oracle")) {
            pos = result.indexOf("  ");
            while (pos != -1) {
                result.replace(pos, pos + 2, " ");
                pos = result.indexOf("  ");
            }
            pos = 0;
            pos2 = result.indexOf("{LIKE}", pos);
            while (pos2 != -1) {
                temp = new StringBuffer(result.substring(0, pos2));
                lastSpace = temp.lastIndexOf(" ");
                temp.setLength(lastSpace);
                secondLastSpace = temp.lastIndexOf(" ") + 1;
                while (temp.charAt(secondLastSpace) == '(') {
                    ++secondLastSpace;
                }
                result.insert(secondLastSpace, "UPPER(");
                result.insert(lastSpace += "UPPER(".length(), ")");
                pos = pos2 + "UPPER()".length() + "{LIKE}".length();
                pos2 = result.indexOf("{LIKE}", pos);
            }
        }
        for (int i = 0; i < this.customDatatypes_.length; ++i) {
            pos = result.indexOf(this.customDatatypes_[i]);
            while (pos != -1) {
                String dataType = (String)this.datatypeConversion_.get(this.customDatatypes_[i]);
                if (this.customDatatypes_[i].equals("{limitedText}") && this.datatypeConversion_.get("[limitedTextLimit]") != null) {
                    try {
                        int length;
                        int max = Integer.parseInt((String)this.datatypeConversion_.get("[limitedTextLimit]"));
                        int start = pos + this.customDatatypes_[i].length();
                        int end = result.indexOf(")", start);
                        String temp2 = result.substring(start, end).trim();
                        if (temp2.startsWith("(")) {
                            temp2 = temp2.substring(1);
                        }
                        if ((length = Integer.parseInt(temp2)) > max) {
                            dataType = (String)this.datatypeConversion_.get("{unlimitedText}");
                            result.replace(start, end + 1, "");
                        }
                    }
                    catch (Exception e) {
                        dataType = (String)this.datatypeConversion_.get(this.customDatatypes_[i]);
                    }
                }
                result.replace(pos, pos + this.customDatatypes_[i].length(), dataType);
                pos = result.indexOf(this.customDatatypes_[i]);
            }
        }
        if (this.databaseType_.equals("ACCESS")) {
            pos = result.indexOf(" default ");
            while (pos != -1) {
                pos2 = result.indexOf(",", pos);
                if (pos2 == -1) {
                    pos2 = result.indexOf(")", pos);
                }
                result.replace(pos, pos2, "");
                pos = result.indexOf(" default ");
            }
        }
        if (logResult) {
            log.debug((Object)result.toString());
        }
        return result.toString();
    }

    public String modifySQL(String sql) {
        return this.modifySQL(sql, true);
    }

    public boolean requiresLikeQueryTextToBeUpperCased() {
        return this.databaseType_.startsWith("DB2") || this.databaseType_.startsWith("Oracle");
    }

    public static void main(String[] args) throws Exception {
        GenericSQLModifier foo = new GenericSQLModifier("DB2/NT");
        System.out.println(foo.modifySQL("Select  * from a where b.c {LIKE} ?"));
        System.out.println(foo.modifySQL("Select * from a where foobar.me {LIKE} ? AND barnone {LIKE} ?"));
        System.out.println(foo.modifySQL("Select * from a where a = ? AND (barnone {LIKE} OR foo {LIKE} ?)"));
    }
}

