/*
 * Decompiled with CFR 0.152.
 */
package org.exist.extensions.exquery.restxq.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.exist.EXistException;
import org.exist.extensions.exquery.restxq.impl.adapters.SequenceAdapter;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.util.serializer.XQuerySerializer;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.BinaryValue;
import org.exquery.http.HttpResponse;
import org.exquery.restxq.RestXqServiceException;
import org.exquery.restxq.impl.serialization.AbstractRestXqServiceSerializer;
import org.exquery.restxq.impl.serialization.SerializationProperty;
import org.exquery.serialization.annotation.MethodAnnotation;
import org.exquery.xquery.Sequence;
import org.exquery.xquery.Type;
import org.exquery.xquery.TypedValue;
import org.xml.sax.SAXException;

class RestXqServiceSerializerImpl
extends AbstractRestXqServiceSerializer {
    private final BrokerPool brokerPool;

    public RestXqServiceSerializerImpl(BrokerPool brokerPool) {
        this.brokerPool = brokerPool;
    }

    private BrokerPool getBrokerPool() {
        return this.brokerPool;
    }

    protected void serializeBinaryBody(Sequence result, HttpResponse response) throws RestXqServiceException {
        Iterator iterator = result.iterator();
        if (iterator.hasNext()) {
            TypedValue typedValue = (TypedValue)iterator.next();
            if (typedValue.getType() == Type.BASE64_BINARY || typedValue.getType() == Type.HEX_BINARY) {
                BinaryValue binaryValue = (BinaryValue)typedValue.getValue();
                try (OutputStream os = response.getOutputStream();){
                    binaryValue.streamBinaryTo(os);
                }
                catch (IOException ioe) {
                    throw new RestXqServiceException("Error while serializing binary: " + ioe.toString(), (Throwable)ioe);
                }
                return;
            }
            throw new RestXqServiceException("Expected binary value, but found: " + typedValue.getType().name());
        }
    }

    protected void serializeNodeBody(Sequence result, HttpResponse response, Map<SerializationProperty, String> serializationProperties) throws RestXqServiceException {
        try (DBBroker broker = this.getBrokerPool().getBroker();
             OutputStreamWriter writer = new OutputStreamWriter(response.getOutputStream(), serializationProperties.get(SerializationProperty.ENCODING));){
            Properties outputProperties = this.serializationPropertiesToProperties(serializationProperties);
            XQuerySerializer xqSerializer = new XQuerySerializer(broker, outputProperties, (Writer)writer);
            xqSerializer.serialize(((SequenceAdapter)result).getExistSequence());
            ((Writer)writer).flush();
        }
        catch (IOException | EXistException | XPathException | SAXException ioe) {
            throw new RestXqServiceException("Error while serializing xml: " + ioe.toString(), ioe);
        }
    }

    private Properties serializationPropertiesToProperties(Map<SerializationProperty, String> serializationProperties) {
        Properties props = new Properties();
        for (Map.Entry<SerializationProperty, String> serializationProperty : serializationProperties.entrySet()) {
            if (serializationProperty.getKey() == SerializationProperty.METHOD && serializationProperty.getValue().equals(MethodAnnotation.SupportedMethod.html.name())) {
                props.setProperty(serializationProperty.getKey().name().toLowerCase(), MethodAnnotation.SupportedMethod.html5.name());
                continue;
            }
            if (serializationProperty.getKey() == SerializationProperty.OMIT_XML_DECLARATION) {
                props.setProperty(serializationProperty.getKey().name().toLowerCase().replace('_', '-'), serializationProperty.getValue());
                continue;
            }
            props.setProperty(serializationProperty.getKey().name().toLowerCase(), serializationProperty.getValue());
        }
        return props;
    }
}

