/*
 * Decompiled with CFR 0.152.
 */
package org.exist.extensions.exquery.restxq.impl;

import java.util.List;
import org.exist.collections.triggers.SAXTrigger;
import org.exist.collections.triggers.TriggerException;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.extensions.exquery.restxq.impl.ExistXqueryRegistry;
import org.exist.storage.DBBroker;
import org.exist.storage.txn.Txn;
import org.exist.xmldb.XmldbURI;
import org.exquery.ExQueryException;
import org.exquery.restxq.RestXqService;

public class RestXqTrigger
extends SAXTrigger {
    public void beforeCreateDocument(DBBroker broker, Txn transaction, XmldbURI uri) throws TriggerException {
    }

    public void afterCreateDocument(DBBroker broker, Txn transaction, DocumentImpl document) throws TriggerException {
        this.after(broker, document);
    }

    public void beforeUpdateDocument(DBBroker broker, Txn transaction, DocumentImpl document) throws TriggerException {
        this.before(broker, document);
    }

    public void afterUpdateDocument(DBBroker broker, Txn transaction, DocumentImpl document) throws TriggerException {
        this.after(broker, document);
    }

    public void beforeCopyDocument(DBBroker broker, Txn transaction, DocumentImpl document, XmldbURI newUri) throws TriggerException {
        this.before(broker, document);
    }

    public void afterCopyDocument(DBBroker broker, Txn transaction, DocumentImpl document, XmldbURI oldUri) throws TriggerException {
        this.after(broker, document);
    }

    public void beforeMoveDocument(DBBroker broker, Txn transaction, DocumentImpl document, XmldbURI newUri) throws TriggerException {
        this.before(broker, document);
    }

    public void afterMoveDocument(DBBroker broker, Txn transaction, DocumentImpl document, XmldbURI oldUri) throws TriggerException {
        this.after(broker, document);
    }

    public void beforeDeleteDocument(DBBroker broker, Txn transaction, DocumentImpl document) throws TriggerException {
        this.before(broker, document);
    }

    public void afterDeleteDocument(DBBroker broker, Txn transaction, XmldbURI uri) throws TriggerException {
    }

    public void beforeUpdateDocumentMetadata(DBBroker broker, Txn txn, DocumentImpl document) throws TriggerException {
    }

    public void afterUpdateDocumentMetadata(DBBroker broker, Txn txn, DocumentImpl document) throws TriggerException {
    }

    private void before(DBBroker broker, DocumentImpl document) {
        ExistXqueryRegistry xqueryRegistry = ExistXqueryRegistry.getInstance();
        if (xqueryRegistry.isXquery(document)) {
            xqueryRegistry.deregisterServices(broker, document.getURI());
        }
    }

    private void after(DBBroker broker, DocumentImpl document) throws TriggerException {
        ExistXqueryRegistry xqueryRegistry = ExistXqueryRegistry.getInstance();
        if (xqueryRegistry.isXquery(document)) {
            try {
                List<RestXqService> services = xqueryRegistry.findServices(broker, document);
                xqueryRegistry.registerServices(broker, services);
            }
            catch (ExQueryException eqe) {
                throw new TriggerException(eqe.getMessage(), (Exception)((Object)eqe));
            }
        }
    }
}

