/*
 * Decompiled with CFR 0.152.
 */
package org.exist.extensions.exquery.restxq.impl;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.exist.extensions.exquery.restxq.impl.RestXqServiceCompiledXQueryCacheImpl;
import org.exist.extensions.exquery.restxq.impl.RestXqServiceImpl;
import org.exist.extensions.exquery.restxq.impl.adapters.AnnotationAdapter;
import org.exist.source.DBSource;
import org.exist.source.Source;
import org.exist.xquery.CompiledXQuery;
import org.exist.xquery.ExternalModule;
import org.exist.xquery.Module;
import org.exist.xquery.UserDefinedFunction;
import org.exist.xquery.XQueryContext;
import org.exquery.ExQueryException;
import org.exquery.annotation.AnnotationException;
import org.exquery.restxq.ResourceFunction;
import org.exquery.restxq.RestXqService;
import org.exquery.restxq.impl.ResourceFunctionFactory;
import org.exquery.restxq.impl.annotation.RestAnnotationFactory;
import org.exquery.xquery3.Annotation;

class XQueryInspector {
    XQueryInspector() {
    }

    public static List<RestXqService> findServices(CompiledXQuery compiled) throws ExQueryException {
        ArrayList<RestXqService> services = new ArrayList<RestXqService>();
        try {
            Iterator itFunctions = compiled.getContext().localFunctions();
            HashSet<URI> xqueryLocations = new HashSet<URI>();
            while (itFunctions.hasNext()) {
                UserDefinedFunction function = (UserDefinedFunction)itFunctions.next();
                org.exist.xquery.Annotation[] annotations = function.getSignature().getAnnotations();
                HashSet<Annotation> functionRestAnnotations = null;
                for (org.exist.xquery.Annotation annotation : annotations) {
                    if (!RestAnnotationFactory.isRestXqAnnotation((QName)annotation.getName().toJavaQName())) continue;
                    Annotation restAnnotation = RestAnnotationFactory.getAnnotation((Annotation)new AnnotationAdapter(annotation));
                    if (functionRestAnnotations == null) {
                        functionRestAnnotations = new HashSet<Annotation>();
                    }
                    functionRestAnnotations.add(restAnnotation);
                }
                if (functionRestAnnotations == null) continue;
                ResourceFunction resourceFunction = ResourceFunctionFactory.create((URI)new URI(compiled.getSource().path()), functionRestAnnotations);
                RestXqServiceImpl service = new RestXqServiceImpl(resourceFunction, compiled.getContext().getBroker().getBrokerPool());
                xqueryLocations.add(resourceFunction.getXQueryLocation());
                services.add((RestXqService)service);
            }
            for (URI xqueryLocation : xqueryLocations) {
                RestXqServiceCompiledXQueryCacheImpl.getInstance().returnCompiledQuery(xqueryLocation, compiled);
            }
        }
        catch (URISyntaxException | AnnotationException use) {
            throw new ExQueryException(use.getMessage(), use);
        }
        return services;
    }

    public static Map<String, Set<String>> getDependencies(CompiledXQuery compiled) {
        HashMap<String, Set<String>> dependencies = new HashMap<String, Set<String>>();
        XQueryInspector.getDependencies(compiled.getContext(), dependencies);
        return dependencies;
    }

    private static void getDependencies(XQueryContext xqyCtx, Map<String, Set<String>> dependencies) {
        String xqueryUri = XQueryInspector.getDbUri(xqyCtx.getSource());
        Set<String> depSet = dependencies.get(xqueryUri);
        if (depSet == null) {
            Iterator itModule = xqyCtx.getModules();
            while (itModule.hasNext()) {
                Module module = (Module)itModule.next();
                if (!(module instanceof ExternalModule)) continue;
                ExternalModule extModule = (ExternalModule)module;
                Source source = extModule.getSource();
                if (source instanceof DBSource) {
                    String moduleUri = XQueryInspector.getDbUri(source);
                    if (depSet == null) {
                        depSet = new HashSet<String>();
                    }
                    depSet.add(moduleUri);
                    dependencies.put(xqueryUri, depSet);
                }
                XQueryInspector.getDependencies(extModule.getContext(), dependencies);
            }
        }
    }

    private static String getDbUri(Source source) {
        if (source != null && source instanceof DBSource) {
            return source.getKey().toString();
        }
        return null;
    }
}

