/*
 * Decompiled with CFR 0.152.
 */
package org.exist.extensions.exquery.restxq.impl.adapters;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.exist.util.io.CachingFilterInputStream;
import org.exist.util.io.FilterInputStreamCache;
import org.exist.util.io.FilterInputStreamCacheFactory;
import org.exquery.http.HttpMethod;
import org.exquery.http.HttpRequest;

public class HttpServletRequestAdapter
implements HttpRequest {
    private final HttpServletRequest request;
    private final FilterInputStreamCacheFactory.FilterInputStreamCacheConfiguration cacheConfiguration;
    private InputStream is = null;
    private Map<String, List<String>> formFields = null;

    public HttpServletRequestAdapter(HttpServletRequest request, FilterInputStreamCacheFactory.FilterInputStreamCacheConfiguration cacheConfiguration) {
        this.request = request;
        this.cacheConfiguration = cacheConfiguration;
    }

    public HttpMethod getMethod() {
        return HttpMethod.valueOf((String)this.request.getMethod());
    }

    public String getScheme() {
        return this.request.getScheme();
    }

    public String getHostname() {
        return this.request.getServerName();
    }

    public int getPort() {
        return this.request.getServerPort();
    }

    public String getQuery() {
        return this.request.getQueryString();
    }

    public String getPath() {
        return this.request.getPathInfo();
    }

    public String getURI() {
        return this.request.getRequestURI();
    }

    public String getAddress() {
        return this.request.getLocalAddr();
    }

    public String getRemoteHostname() {
        return this.request.getRemoteHost();
    }

    public String getRemoteAddress() {
        return this.request.getRemoteAddr();
    }

    public int getRemotePort() {
        return this.request.getRemotePort();
    }

    public InputStream getInputStream() throws IOException {
        if (this.is == null) {
            FilterInputStreamCache cache = FilterInputStreamCacheFactory.getCacheInstance((FilterInputStreamCacheFactory.FilterInputStreamCacheConfiguration)this.cacheConfiguration, (InputStream)this.request.getInputStream());
            this.is = new CachingFilterInputStream(cache);
            this.is.mark(Integer.MAX_VALUE);
        } else {
            this.is.reset();
        }
        return this.is;
    }

    public String getContentType() {
        return this.request.getContentType();
    }

    public int getContentLength() {
        return this.request.getContentLength();
    }

    public List<String> getHeaderNames() {
        ArrayList<String> names = new ArrayList<String>();
        Enumeration enumNames = this.request.getHeaderNames();
        while (enumNames.hasMoreElements()) {
            names.add((String)enumNames.nextElement());
        }
        return names;
    }

    public String getHeader(String httpHeaderName) {
        return this.request.getHeader(httpHeaderName);
    }

    public String getCookieValue(String cookieName) {
        Cookie[] cookies = this.request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(cookieName)) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    public String getCharacterEncoding() {
        return this.request.getCharacterEncoding();
    }

    public Object getFormParam(String key) {
        if (this.request.getMethod().equals("GET")) {
            return this.getGetParameters(key);
        }
        if (this.request.getMethod().equals("POST") && this.request.getContentType() != null && this.request.getContentType().equals("application/x-www-form-urlencoded")) {
            List<String> formFieldValues;
            if (this.formFields == null) {
                try {
                    InputStream in = this.getInputStream();
                    this.formFields = this.extractFormFields(in);
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                    return null;
                }
            }
            if ((formFieldValues = this.formFields.get(key)) != null) {
                return formFieldValues;
            }
            return this.getGetParameters(key);
        }
        return null;
    }

    public Object getQueryParam(String key) {
        return this.getGetParameters(key);
    }

    private Object getGetParameters(String key) {
        String[] values = this.request.getParameterValues(key);
        if (values != null) {
            if (values.length == 1) {
                return values[0];
            }
            return Arrays.asList(values);
        }
        return null;
    }

    public List<String> getParameterNames() {
        ArrayList<String> names = new ArrayList<String>();
        Enumeration enumNames = this.request.getParameterNames();
        while (enumNames.hasMoreElements()) {
            names.add((String)enumNames.nextElement());
        }
        return names;
    }

    private Map<String, List<String>> extractFormFields(InputStream in) throws IOException {
        Hashtable<String, List<String>> fields = new Hashtable<String, List<String>>();
        StringBuilder builder = new StringBuilder();
        try (InputStreamReader reader = new InputStreamReader(in);){
            int read = -1;
            char[] cbuf = new char[1024];
            while ((read = reader.read(cbuf)) > -1) {
                builder.append(cbuf, 0, read);
            }
        }
        StringTokenizer st = new StringTokenizer(builder.toString(), "&");
        while (st.hasMoreTokens()) {
            String val;
            String key;
            String pair = st.nextToken();
            int pos = pair.indexOf(61);
            if (pos == -1) {
                throw new IllegalArgumentException();
            }
            try {
                key = URLDecoder.decode(pair.substring(0, pos), StandardCharsets.UTF_8.name());
                val = URLDecoder.decode(pair.substring(pos + 1, pair.length()), StandardCharsets.UTF_8.name());
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
            ArrayList<String> vals = (ArrayList<String>)fields.get(key);
            if (vals == null) {
                vals = new ArrayList<String>();
            }
            vals.add(val);
            fields.put(key, vals);
        }
        return fields;
    }
}

