/*
 * Decompiled with CFR 0.152.
 */
package org.exist.extensions.exquery.restxq.impl.adapters;

import java.util.Iterator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.persistent.NodeProxy;
import org.exist.extensions.exquery.restxq.impl.adapters.DomEnhancingNodeProxyAdapter;
import org.exist.extensions.exquery.restxq.impl.adapters.TypeAdapter;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.SequenceIterator;
import org.exquery.xquery.Sequence;
import org.exquery.xquery.Type;
import org.exquery.xquery.TypedValue;

public class SequenceAdapter
implements Sequence<Item> {
    private static final Logger LOG = LogManager.getLogger(SequenceAdapter.class);
    private final org.exist.xquery.value.Sequence sequence;

    public SequenceAdapter(org.exist.xquery.value.Sequence sequence) {
        this.sequence = sequence;
    }

    public Iterator<TypedValue<Item>> iterator() {
        return new Iterator<TypedValue<Item>>(){
            private SequenceIterator iterator;

            private SequenceIterator getIterator() {
                if (this.iterator == null) {
                    try {
                        this.iterator = SequenceAdapter.this.sequence.iterate();
                    }
                    catch (XPathException xpe) {
                        LOG.error("Unable to extract the underlying Sequence Iterator: " + xpe.getMessage() + ". Falling back to EMPTY_ITERATOR", (Throwable)xpe);
                        this.iterator = SequenceIterator.EMPTY_ITERATOR;
                    }
                }
                return this.iterator;
            }

            @Override
            public boolean hasNext() {
                return this.getIterator().hasNext();
            }

            @Override
            public TypedValue<Item> next() {
                return SequenceAdapter.this.createTypedValue(this.getIterator().nextItem());
            }

            @Override
            public void remove() {
            }
        };
    }

    private TypedValue<Item> createTypedValue(final Item item) {
        return new TypedValue<Item>(){

            public Type getType() {
                return TypeAdapter.toExQueryType(item.getType());
            }

            public Item getValue() {
                if (item instanceof NodeProxy) {
                    return DomEnhancingNodeProxyAdapter.create((NodeProxy)item);
                }
                return item;
            }
        };
    }

    public TypedValue<Item> head() {
        if (this.sequence.isEmpty()) {
            return Sequence.EMPTY_SEQUENCE.head();
        }
        return this.createTypedValue(this.sequence.itemAt(0));
    }

    public Sequence<Item> tail() {
        try {
            return new SequenceAdapter(this.sequence.tail());
        }
        catch (XPathException xpe) {
            LOG.error(xpe.getMessage(), (Throwable)xpe);
            return new SequenceAdapter(org.exist.xquery.value.Sequence.EMPTY_SEQUENCE);
        }
    }

    public org.exist.xquery.value.Sequence getExistSequence() {
        return this.sequence;
    }
}

