/*
 * Decompiled with CFR 0.152.
 */
package org.exist.extensions.exquery.restxq.impl.xquery;

import java.util.ArrayList;
import javax.xml.namespace.QName;
import org.exist.dom.memtree.MemTreeBuilder;
import org.exist.extensions.exquery.restxq.impl.RestXqServiceRegistryManager;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exquery.restxq.ResourceFunction;
import org.exquery.restxq.RestXqService;
import org.exquery.restxq.RestXqServiceRegistry;
import org.exquery.restxq.annotation.ConsumesAnnotation;
import org.exquery.restxq.annotation.ParameterAnnotation;
import org.exquery.restxq.annotation.PathAnnotation;
import org.exquery.restxq.annotation.ProducesAnnotation;
import org.exquery.serialization.annotation.AbstractYesNoSerializationAnnotation;
import org.exquery.serialization.annotation.EncodingAnnotation;
import org.exquery.serialization.annotation.MediaTypeAnnotation;
import org.exquery.serialization.annotation.MethodAnnotation;
import org.exquery.serialization.annotation.SerializationAnnotation;
import org.exquery.xquery.Literal;
import org.exquery.xquery3.Annotation;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class RegistryFunctions
extends BasicFunction {
    private static final org.exist.dom.QName RESOURCE_FUNCTIONS = new org.exist.dom.QName("resource-functions", "http://exquery.org/ns/restxq", "rest");
    private static final org.exist.dom.QName RESOURCE_FUNCTION = new org.exist.dom.QName("resource-function", "http://exquery.org/ns/restxq", "rest");
    private static final org.exist.dom.QName ANNOTATIONS = new org.exist.dom.QName("annotations", "http://exquery.org/ns/restxq", "rest");
    private static final org.exist.dom.QName SEGMENT = new org.exist.dom.QName("segment", "http://exquery.org/ns/restxq", "rest");
    private static final org.exist.dom.QName INTERNET_MEDIA_TYPE = new org.exist.dom.QName("internet-media-type", "http://exquery.org/ns/restxq", "rest");
    private static final String XQUERY_URI = "xquery-uri";
    private static final org.exist.dom.QName RESOURCE_FUNCTION_IDENTITY = new org.exist.dom.QName("identity", "http://exquery.org/ns/restxq", "rest");
    private static final String NAMESPACE = "namespace";
    private static final String LOCAL_NAME = "local-name";
    private static final String ARITY = "arity";
    private static final String VALUE = "value";
    private static final String NAME = "name";
    private static final String ARGUMENT = "argument";
    private static final String DEFAULT_VALUE = "default-value";
    private static final String SPECIFICITY_METRIC = "specificity-metric";
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new org.exist.dom.QName(RESOURCE_FUNCTIONS.getLocalPart(), "http://exquery.org/ns/restxq", "rest"), "Gets a list of all the registered resource functions.", FunctionSignature.NO_ARGS, (SequenceType)new FunctionReturnSequenceType(6, 2, "The list of registered resource functions."))};

    public RegistryFunctions(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        RestXqServiceRegistry registry = RestXqServiceRegistryManager.getRegistry(this.getContext().getBroker().getBrokerPool());
        return (NodeValue)RegistryFunctions.serializeRestXqServices(this.getContext().getDocumentBuilder(), (Iterable<RestXqService>)registry).getDocumentElement();
    }

    public static Document serializeRestXqServices(MemTreeBuilder builder, Iterable<RestXqService> services) {
        builder.startDocument();
        builder.startElement(RESOURCE_FUNCTIONS, null);
        for (RestXqService service : services) {
            ResourceFunction resourceFn = service.getResourceFunction();
            RegistryFunctions.serializeResourceFunction(builder, resourceFn);
        }
        builder.endElement();
        builder.endDocument();
        return builder.getDocument();
    }

    private static void serializeResourceFunction(MemTreeBuilder builder, ResourceFunction resourceFn) {
        AttributesImpl attrs = new AttributesImpl();
        attrs.addAttribute(null, XQUERY_URI, "", "string", resourceFn.getXQueryLocation().toString());
        builder.startElement(RESOURCE_FUNCTION, (Attributes)attrs);
        attrs = new AttributesImpl();
        attrs.addAttribute(null, NAMESPACE, "", "string", resourceFn.getFunctionSignature().getName().getNamespaceURI());
        attrs.addAttribute(null, LOCAL_NAME, "", "string", resourceFn.getFunctionSignature().getName().getLocalPart());
        attrs.addAttribute(null, ARITY, "", "int", Integer.toString(resourceFn.getFunctionSignature().getArgumentCount()));
        builder.startElement(RESOURCE_FUNCTION_IDENTITY, (Attributes)attrs);
        builder.endElement();
        builder.startElement(ANNOTATIONS, null);
        RegistryFunctions.serializeAnnotations(builder, resourceFn);
        builder.endElement();
        builder.endElement();
    }

    private static void serializeAnnotations(MemTreeBuilder builder, ResourceFunction resourceFn) {
        Literal[] literals;
        ArrayList annotations = new ArrayList();
        annotations.addAll(resourceFn.getHttpMethodAnnotations());
        annotations.addAll(resourceFn.getConsumesAnnotations());
        annotations.addAll(resourceFn.getProducesAnnotations());
        for (Annotation annotation : annotations) {
            builder.startElement(org.exist.dom.QName.fromJavaQName((QName)annotation.getName()), null);
            literals = annotation.getLiterals();
            if (literals != null) {
                for (Literal literal : literals) {
                    if (!(annotation instanceof ConsumesAnnotation) && !(annotation instanceof ProducesAnnotation)) continue;
                    builder.startElement(INTERNET_MEDIA_TYPE, null);
                    builder.characters((CharSequence)literal.getValue());
                    builder.endElement();
                }
            }
            builder.endElement();
        }
        if (resourceFn.getPathAnnotation() != null) {
            String[] segments;
            PathAnnotation pathAnnotation = resourceFn.getPathAnnotation();
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute(null, SPECIFICITY_METRIC, "", "string", Long.toString(pathAnnotation.getPathSpecificityMetric()));
            builder.startElement(org.exist.dom.QName.fromJavaQName((QName)pathAnnotation.getName()), (Attributes)attrs);
            for (String string : segments = pathAnnotation.getLiterals()[0].getValue().split("/")) {
                if (string.isEmpty()) continue;
                builder.startElement(SEGMENT, null);
                builder.characters((CharSequence)string);
                builder.endElement();
            }
            builder.endElement();
        }
        for (ParameterAnnotation parameterAnnotation : resourceFn.getParameterAnnotations()) {
            literals = parameterAnnotation.getLiterals();
            AttributesImpl attributesImpl = new AttributesImpl();
            attributesImpl.addAttribute(null, NAME, "", "string", literals[0].getValue());
            attributesImpl.addAttribute(null, ARGUMENT, "", "string", literals[1].getValue());
            if (literals.length == 3) {
                attributesImpl.addAttribute(null, DEFAULT_VALUE, "", "string", literals[2].getValue());
            }
            builder.startElement(org.exist.dom.QName.fromJavaQName((QName)parameterAnnotation.getName()), (Attributes)attributesImpl);
            builder.endElement();
        }
        for (SerializationAnnotation serializationAnnotation : resourceFn.getSerializationAnnotations()) {
            RegistryFunctions.serializeSerializationAnnotation(builder, serializationAnnotation);
        }
    }

    static void serializeSerializationAnnotation(MemTreeBuilder builder, SerializationAnnotation serializationAnnotation) {
        builder.startElement(org.exist.dom.QName.fromJavaQName((QName)serializationAnnotation.getName()), null);
        if (serializationAnnotation instanceof AbstractYesNoSerializationAnnotation) {
            builder.characters((CharSequence)((AbstractYesNoSerializationAnnotation)serializationAnnotation).getStringValue());
        } else if (serializationAnnotation instanceof MediaTypeAnnotation) {
            builder.characters((CharSequence)((MediaTypeAnnotation)serializationAnnotation).getValue());
        } else if (serializationAnnotation instanceof EncodingAnnotation) {
            builder.characters((CharSequence)((EncodingAnnotation)serializationAnnotation).getValue());
        } else if (serializationAnnotation instanceof MethodAnnotation) {
            builder.characters((CharSequence)((MethodAnnotation)serializationAnnotation).getMethod());
        }
        builder.endElement();
    }
}

