/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.cache;

import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.exist.xquery.XPathException;
import org.exist.xquery.modules.cache.CacheConfig;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.ValueSequence;

class Cache {
    private final CacheConfig config;
    private final com.github.benmanes.caffeine.cache.Cache<String, Sequence> store;

    public Cache(CacheConfig config) {
        this.config = config;
        Caffeine cacheBuilder = Caffeine.newBuilder();
        config.getMaximumSize().map(arg_0 -> ((Caffeine)cacheBuilder).maximumSize(arg_0));
        config.getExpireAfterAccess().map(ms -> cacheBuilder.expireAfterAccess(ms.longValue(), TimeUnit.MILLISECONDS));
        this.store = cacheBuilder.build();
    }

    public CacheConfig getConfig() {
        return this.config;
    }

    public Sequence put(String key, Sequence value) {
        return this.store.asMap().put(key, value);
    }

    public Sequence list(String[] keys) throws XPathException {
        ValueSequence values = new ValueSequence();
        if (keys.length == 0) {
            for (Sequence value : this.store.asMap().values()) {
                values.addAll(value);
            }
        } else {
            Map entries = this.store.getAllPresent(Arrays.asList(keys));
            for (Sequence value : entries.values()) {
                values.addAll(value);
            }
        }
        return values;
    }

    public Sequence listKeys() throws XPathException {
        ValueSequence keys = new ValueSequence();
        for (String key : this.store.asMap().keySet()) {
            keys.add((Item)new StringValue(key));
        }
        return keys;
    }

    public Sequence get(String key) {
        Sequence value = (Sequence)this.store.getIfPresent((Object)key);
        if (value == null) {
            return Sequence.EMPTY_SEQUENCE;
        }
        return value;
    }

    public Sequence remove(String key) {
        Sequence prevValue = (Sequence)this.store.asMap().remove(key);
        if (prevValue == null) {
            return Sequence.EMPTY_SEQUENCE;
        }
        return prevValue;
    }

    public void clear() {
        this.store.invalidateAll();
    }

    public void cleanup() {
        this.store.cleanUp();
    }
}

