/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.cache;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.exist.dom.QName;
import org.exist.xquery.AbstractInternalModule;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.FunctionDSL;
import org.exist.xquery.FunctionDef;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.modules.cache.Cache;
import org.exist.xquery.modules.cache.CacheFunctions;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;

public class CacheModule
extends AbstractInternalModule {
    public static final String NAMESPACE_URI = "http://exist-db.org/xquery/cache";
    public static final String PREFIX = "cache";
    public static final String INCLUSION_DATE = "2009-03-04";
    public static final String RELEASED_IN_VERSION = "eXist-1.4";
    public static final FunctionDef[] functions = FunctionDSL.functionDefs(CacheFunctions.class, (FunctionSignature[])new FunctionSignature[]{CacheFunctions.FS_CACHE, CacheFunctions.FS_CREATE_CACHE, CacheFunctions.FS_NAMES, CacheFunctions.FS_PUT, CacheFunctions.FS_LIST, CacheFunctions.FS_KEYS, CacheFunctions.FS_GET, CacheFunctions.FS_REMOVE, CacheFunctions.FS_CLEAR[0], CacheFunctions.FS_CLEAR[1], CacheFunctions.FS_CLEANUP, CacheFunctions.FS_DESTROY});
    static final Map<String, Cache> caches = new ConcurrentHashMap<String, Cache>();
    static final ErrorCodes.ErrorCode INSUFFICIENT_PERMISSIONS = new CacheModuleErrorCode("insufficient-permissions", "The calling user does not have sufficient permissions to operate on the cache.");
    static final ErrorCodes.ErrorCode KEY_SERIALIZATION = new CacheModuleErrorCode("key-serialization", "Unable to serialize the provided key.");

    public CacheModule(Map<String, List<?>> parameters) {
        super(functions, parameters);
    }

    public String getNamespaceURI() {
        return NAMESPACE_URI;
    }

    public String getDefaultPrefix() {
        return PREFIX;
    }

    public String getDescription() {
        return "A module for accessing global caches for sharing data between concurrent sessions";
    }

    public String getReleaseVersion() {
        return RELEASED_IN_VERSION;
    }

    static FunctionSignature functionSignature(String name, String description, FunctionReturnSequenceType returnType, FunctionParameterSequenceType ... paramTypes) {
        return FunctionDSL.functionSignature((QName)new QName(name, NAMESPACE_URI), (String)description, (FunctionReturnSequenceType)returnType, (FunctionParameterSequenceType[])paramTypes);
    }

    static FunctionSignature[] functionSignatures(String name, String description, FunctionReturnSequenceType returnType, FunctionParameterSequenceType[][] variableParamTypes) {
        return FunctionDSL.functionSignatures((QName)new QName(name, NAMESPACE_URI), (String)description, (FunctionReturnSequenceType)returnType, (FunctionParameterSequenceType[][])variableParamTypes);
    }

    static class CacheModuleErrorCode
    extends ErrorCodes.ErrorCode {
        private CacheModuleErrorCode(String code, String description) {
            super(new QName(code, CacheModule.NAMESPACE_URI, CacheModule.PREFIX), description);
        }
    }
}

