/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.expathrepo;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.SystemProperties;
import org.exist.dom.QName;
import org.exist.dom.memtree.MemTreeBuilder;
import org.exist.dom.memtree.NodeImpl;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.repo.Deployment;
import org.exist.repo.PackageLoader;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.NativeBroker;
import org.exist.storage.lock.Lock;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.ErrorCodes;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.expathrepo.EXPathErrorCode;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.expath.pkg.repo.PackageException;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

public class Deploy
extends BasicFunction {
    protected static final Logger logger = LogManager.getLogger(Deploy.class);
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("deploy", "http://exist-db.org/xquery/repo", "repo"), "Deploy an application package. Installs package contents to the specified target collection, using the permissions defined by the &lt;permissions&gt; element in repo.xml. Pre- and post-install XQuery scripts can be specified via the &lt;prepare&gt; and &lt;finish&gt; elements.", new SequenceType[]{new FunctionParameterSequenceType("pkgName", 22, 2, "package name")}, (SequenceType)new FunctionReturnSequenceType(1, 2, "<status result=\"ok\"/> if deployment was ok. Throws an error otherwise.")), new FunctionSignature(new QName("deploy", "http://exist-db.org/xquery/repo", "repo"), "Deploy an application package. Installs package contents to the specified target collection, using the permissions defined by the &lt;permissions&gt; element in repo.xml. Pre- and post-install XQuery scripts can be specified via the &lt;prepare&gt; and &lt;finish&gt; elements.", new SequenceType[]{new FunctionParameterSequenceType("pkgName", 22, 2, "package name"), new FunctionParameterSequenceType("targetCollection", 22, 2, "the target collection into which the package will be stored")}, (SequenceType)new FunctionReturnSequenceType(1, 2, "<status result=\"ok\"/> if deployment was ok. Throws an error otherwise.")), new FunctionSignature(new QName("install-and-deploy", "http://exist-db.org/xquery/repo", "repo"), "Downloads, installs and deploys a package from the public repository at $publicRepoURL. Dependencies are resolved automatically. For downloading the package, the package name is appended to the repository URL as parameter 'name'.", new SequenceType[]{new FunctionParameterSequenceType("pkgName", 22, 2, "Unique name of the package to install."), new FunctionParameterSequenceType("publicRepoURL", 22, 2, "The URL of the public repo.")}, (SequenceType)new FunctionReturnSequenceType(1, 2, "<status result=\"ok\"/> if deployment was ok. Throws an error otherwise.")), new FunctionSignature(new QName("install-and-deploy", "http://exist-db.org/xquery/repo", "repo"), "Downloads, installs and deploys a package from the public repository at $publicRepoURL. Dependencies are resolved automatically. For downloading the package, the package name and version are appended to the repository URL as parameters 'name' and 'version'.", new SequenceType[]{new FunctionParameterSequenceType("pkgName", 22, 2, "Unique name of the package to install."), new FunctionParameterSequenceType("version", 22, 3, "Version to install."), new FunctionParameterSequenceType("publicRepoURL", 22, 2, "The URL of the public repo.")}, (SequenceType)new FunctionReturnSequenceType(1, 2, "<status result=\"ok\"/> if deployment was ok. Throws an error otherwise.")), new FunctionSignature(new QName("install-and-deploy-from-db", "http://exist-db.org/xquery/repo", "repo"), "Installs and deploys a package from a .xar archive file stored in the database. Dependencies are not resolved and will just be ignored.", new SequenceType[]{new FunctionParameterSequenceType("path", 22, 2, "Database path to the package archive (.xar file)")}, (SequenceType)new FunctionReturnSequenceType(1, 2, "<status result=\"ok\"/> if deployment was ok. Throws an error otherwise.")), new FunctionSignature(new QName("install-and-deploy-from-db", "http://exist-db.org/xquery/repo", "repo"), "Installs and deploys a package from a .xar archive file stored in the database. Dependencies will be downloaded from the public repo and installed automatically.", new SequenceType[]{new FunctionParameterSequenceType("path", 22, 2, "Database path to the package archive (.xar file)"), new FunctionParameterSequenceType("publicRepoURL", 22, 2, "The URL of the public repo.")}, (SequenceType)new FunctionReturnSequenceType(1, 2, "<status result=\"ok\"/> if deployment was ok. Throws an error otherwise.")), new FunctionSignature(new QName("undeploy", "http://exist-db.org/xquery/repo", "repo"), "Uninstall the resources belonging to a package from the db. Calls cleanup scripts if defined.", new SequenceType[]{new FunctionParameterSequenceType("pkgName", 22, 2, "package name")}, (SequenceType)new FunctionReturnSequenceType(1, 2, "<status result=\"ok\"/> if deployment was ok. Throws an error otherwise."))};
    private static final QName STATUS_ELEMENT = new QName("status", "http://exist-db.org/xquery/repo");

    public Deploy(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (!this.context.getSubject().hasDbaRole()) {
            throw new XPathException((Expression)this, EXPathErrorCode.EXPDY003, "Permission denied. You need to be a member of the dba group to use repo:deploy/undeploy");
        }
        String pkgName = args[0].getStringValue();
        try {
            Optional<String> target;
            Deployment deployment = new Deployment(this.context.getBroker());
            if (this.isCalledAs("deploy")) {
                String userTarget = null;
                if (this.getArgumentCount() == 2) {
                    userTarget = args[1].getStringValue();
                }
                target = deployment.deploy(pkgName, this.context.getRepository(), userTarget);
            } else if (this.isCalledAs("install-and-deploy")) {
                String repoURI;
                String version = null;
                if (this.getArgumentCount() == 3) {
                    version = args[1].getStringValue();
                    repoURI = args[2].getStringValue();
                } else {
                    repoURI = args[1].getStringValue();
                }
                target = this.installAndDeploy(pkgName, version, repoURI);
            } else if (this.isCalledAs("install-and-deploy-from-db")) {
                String repoURI = null;
                if (this.getArgumentCount() == 2) {
                    repoURI = args[1].getStringValue();
                }
                target = this.installAndDeployFromDb(pkgName, repoURI);
            } else {
                target = deployment.undeploy(pkgName, this.context.getRepository());
            }
            target.orElseThrow(() -> new XPathException("expath repository is not available."));
            return this.statusReport(target);
        }
        catch (PackageException e) {
            throw new XPathException((Expression)this, EXPathErrorCode.EXPDY001, e.getMessage());
        }
        catch (IOException e) {
            throw new XPathException((Expression)this, ErrorCodes.FOER0000, "Caught IO error while deploying expath archive");
        }
    }

    private Optional<String> installAndDeploy(String pkgName, String version, String repoURI) throws XPathException {
        try {
            RepoPackageLoader loader = new RepoPackageLoader(repoURI);
            Deployment deployment = new Deployment(this.context.getBroker());
            Path xar = loader.load(pkgName, new PackageLoader.Version(version, false));
            if (xar != null) {
                return deployment.installAndDeploy(xar, (PackageLoader)loader);
            }
            return Optional.empty();
        }
        catch (MalformedURLException e) {
            throw new XPathException((Expression)this, EXPathErrorCode.EXPDY005, "Malformed URL: " + repoURI);
        }
        catch (IOException | PackageException e) {
            LOG.error(e.getMessage(), e);
            throw new XPathException((Expression)this, EXPathErrorCode.EXPDY007, e.getMessage());
        }
    }

    private Optional<String> installAndDeployFromDb(String path, String repoURI) throws XPathException {
        XmldbURI docPath = XmldbURI.createInternal((String)path);
        DocumentImpl doc = null;
        try {
            doc = this.context.getBroker().getXMLResource(docPath, Lock.LockMode.READ_LOCK);
            if (doc.getResourceType() != 1) {
                throw new XPathException((Expression)this, EXPathErrorCode.EXPDY001, path + " is not a valid .xar", (Sequence)new StringValue(path));
            }
            Path file = ((NativeBroker)this.context.getBroker()).getCollectionBinaryFileFsPath(doc.getURI());
            RepoPackageLoader loader = null;
            if (repoURI != null) {
                loader = new RepoPackageLoader(repoURI);
            }
            Deployment deployment = new Deployment(this.context.getBroker());
            Optional optional = deployment.installAndDeploy(file, (PackageLoader)loader);
            return optional;
        }
        catch (IOException | PermissionDeniedException | PackageException e) {
            LOG.error(e.getMessage(), e);
            throw new XPathException((Expression)this, EXPathErrorCode.EXPDY007, "Package installation failed: " + e.getMessage(), (Sequence)new StringValue(e.getMessage()));
        }
        finally {
            if (doc != null) {
                doc.getUpdateLock().release(Lock.LockMode.READ_LOCK);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Sequence statusReport(Optional<String> target) {
        this.context.pushDocumentContext();
        try {
            MemTreeBuilder builder = this.context.getDocumentBuilder();
            AttributesImpl attrs = new AttributesImpl();
            if (target.isPresent()) {
                attrs.addAttribute("", "result", "result", "CDATA", "ok");
                attrs.addAttribute("", "target", "target", "CDATA", target.get());
            } else {
                attrs.addAttribute("", "result", "result", "CDATA", "fail");
            }
            builder.startElement(STATUS_ELEMENT, (Attributes)attrs);
            builder.endElement();
            NodeImpl nodeImpl = builder.getDocument().getNode(1);
            return nodeImpl;
        }
        finally {
            this.context.popDocumentContext();
        }
    }

    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
    }

    private static class RepoPackageLoader
    implements PackageLoader {
        private final String repoURL;

        public RepoPackageLoader(String repoURL) {
            this.repoURL = repoURL;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Path load(String name, PackageLoader.Version version) throws IOException {
            String pkgURL = this.repoURL + "?name=" + URLEncoder.encode(name, "UTF-8") + "&processor=" + SystemProperties.getInstance().getSystemProperty("product-version", "2.2.0");
            if (version != null) {
                if (version.getMin() != null) {
                    pkgURL = pkgURL + "&semver-min=" + version.getMin();
                }
                if (version.getMax() != null) {
                    pkgURL = pkgURL + "&semver-max=" + version.getMax();
                }
                if (version.getSemVer() != null) {
                    pkgURL = pkgURL + "&semver=" + version.getSemVer();
                }
                if (version.getVersion() != null) {
                    pkgURL = pkgURL + "&version=" + URLEncoder.encode(version.getVersion(), "UTF-8");
                }
            }
            LOG.info("Retrieving package from " + pkgURL);
            HttpURLConnection connection = (HttpURLConnection)new URL(pkgURL).openConnection();
            connection.setConnectTimeout(15000);
            connection.setReadTimeout(15000);
            connection.setRequestMethod("GET");
            connection.setRequestProperty("User-Agent", "Mozilla/5.0 (Windows; U; Windows NT 6.0; en-US; rv:1.9.1.2) Gecko/20090729 Firefox/3.5.2 (.NET CLR 3.5.30729)");
            connection.connect();
            try (InputStream is = connection.getInputStream();){
                Path outFile = Files.createTempFile("deploy", "xar", new FileAttribute[0]);
                Files.copy(is, outFile, StandardCopyOption.REPLACE_EXISTING);
                Path path = outFile;
                return path;
            }
            catch (IOException e) {
                throw new IOException("Failed to install dependency from " + pkgURL + ": " + e.getMessage());
            }
        }
    }
}

