/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.file;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Date;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.dom.memtree.MemTreeBuilder;
import org.exist.util.FileUtils;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.file.FileModuleHelper;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.DateTimeValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class Directory
extends BasicFunction {
    private static final Logger logger = LogManager.getLogger(Directory.class);
    static final String NAMESPACE_URI = "http://exist-db.org/xquery/file";
    static final String PREFIX = "file";
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("list", "http://exist-db.org/xquery/file", "file"), "List all files and directories under the specified directory. This method is only available to the DBA role.", new SequenceType[]{new FunctionParameterSequenceType("path", 11, 2, "The directory path or URI in the file system.")}, (SequenceType)new FunctionReturnSequenceType(-1, 7, "a node describing file and directory names and meta data."))};

    public Directory(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (!this.context.getSubject().hasDbaRole()) {
            XPathException xPathException = new XPathException((Expression)this, "Permission denied, calling user '" + this.context.getSubject().getName() + "' must be a DBA to call this function.");
            logger.error("Invalid user", (Throwable)xPathException);
            throw xPathException;
        }
        String inputPath = args[0].getStringValue();
        Path directoryPath = FileModuleHelper.getFile(inputPath);
        if (logger.isDebugEnabled()) {
            logger.debug("Listing matching files in directory: " + directoryPath.toAbsolutePath().toString());
        }
        if (!Files.isDirectory(directoryPath, new LinkOption[0])) {
            throw new XPathException((Expression)this, "'" + inputPath + "' does not point to a valid directory.");
        }
        try (Stream<Path> scannedFiles = Files.list(directoryPath);){
            MemTreeBuilder builder = this.context.getDocumentBuilder();
            builder.startDocument();
            builder.startElement(new QName("list", null, null), null);
            scannedFiles.forEach(entry -> {
                if (logger.isDebugEnabled()) {
                    logger.debug("Found: " + entry.toAbsolutePath().toString());
                }
                String entryType = "unknown";
                if (Files.isRegularFile(entry, new LinkOption[0])) {
                    entryType = PREFIX;
                } else if (Files.isDirectory(entry, new LinkOption[0])) {
                    entryType = "directory";
                }
                builder.startElement(new QName(entryType, NAMESPACE_URI, PREFIX), null);
                builder.addAttribute(new QName("name", null, null), FileUtils.fileName((Path)entry));
                try {
                    if (Files.isRegularFile(entry, new LinkOption[0])) {
                        Long sizeLong = Files.size(entry);
                        String sizeString = Long.toString(sizeLong);
                        String humanSize = this.getHumanSize(sizeLong, sizeString);
                        builder.addAttribute(new QName("size", null, null), sizeString);
                        builder.addAttribute(new QName("human-size", null, null), humanSize);
                    }
                    builder.addAttribute(new QName("modified", null, null), new DateTimeValue(new Date(Files.getLastModifiedTime(entry, new LinkOption[0]).toMillis())).getStringValue());
                    builder.addAttribute(new QName("hidden", null, null), new BooleanValue(Files.isHidden(entry)).getStringValue());
                    builder.addAttribute(new QName("canRead", null, null), new BooleanValue(Files.isReadable(entry)).getStringValue());
                    builder.addAttribute(new QName("canWrite", null, null), new BooleanValue(Files.isWritable(entry)).getStringValue());
                }
                catch (IOException | XPathException ioe) {
                    LOG.warn((Object)ioe);
                }
                builder.endElement();
            });
            builder.endElement();
            NodeValue nodeValue = (NodeValue)builder.getDocument().getDocumentElement();
            return nodeValue;
        }
        catch (IOException ioe) {
            throw new XPathException((Expression)this, (Throwable)ioe);
        }
    }

    private String getHumanSize(Long sizeLong, String sizeString) {
        String humanSize = "n/a";
        int sizeDigits = sizeString.length();
        if (sizeDigits < 4) {
            humanSize = Long.toString(Math.abs(sizeLong));
        } else if (sizeDigits >= 4 && sizeDigits <= 6) {
            humanSize = sizeLong < 1024L ? Long.toString(Math.abs(sizeLong)) : Math.abs(sizeLong / 1024L) + "KB";
        } else if (sizeDigits >= 7 && sizeDigits <= 9) {
            humanSize = sizeLong < 0x100000L ? Math.abs(sizeLong / 1024L) + "KB" : Math.abs(sizeLong / 0x100000L) + "MB";
        } else if (sizeDigits > 9) {
            humanSize = sizeLong < 0x40000000L ? Math.abs(sizeLong / 0x100000L) + "MB" : Math.abs(sizeLong / 0x40000000L) + "GB";
        }
        return humanSize;
    }
}

