/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.file;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.file.FileModuleHelper;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class FileMove
extends BasicFunction {
    private static final Logger logger = LogManager.getLogger(FileMove.class);
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("move", "http://exist-db.org/xquery/file", "file"), "Move (rename) a file or directory. Exact operation is platform dependent. This method is only available to the DBA role.", new SequenceType[]{new FunctionParameterSequenceType("original", 11, 2, "The full path or URI to the file"), new FunctionParameterSequenceType("destination", 11, 2, "The full path or URI to the file")}, (SequenceType)new FunctionReturnSequenceType(23, 2, "true if successful, false otherwise"))};

    public FileMove(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (!this.context.getSubject().hasDbaRole()) {
            XPathException xPathException = new XPathException((Expression)this, "Permission denied, calling user '" + this.context.getSubject().getName() + "' must be a DBA to call this function.");
            logger.error("Invalid user", (Throwable)xPathException);
            throw xPathException;
        }
        BooleanValue moved = BooleanValue.FALSE;
        String inputPath1 = args[0].getStringValue();
        Path src = FileModuleHelper.getFile(inputPath1);
        String inputPath2 = args[1].getStringValue();
        Path dest = FileModuleHelper.getFile(inputPath2);
        try {
            Files.move(src, dest, StandardCopyOption.ATOMIC_MOVE);
            return BooleanValue.TRUE;
        }
        catch (IOException ioe) {
            LOG.error((Object)ioe);
            return BooleanValue.FALSE;
        }
    }
}

