/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.file;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.file.FileModuleHelper;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;

public class FileRead
extends BasicFunction {
    private static final Logger logger = LogManager.getLogger(FileRead.class);
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("read", "http://exist-db.org/xquery/file", "file"), "Reads the content of file.  This method is only available to the DBA role.", new SequenceType[]{new FunctionParameterSequenceType("path", 11, 2, "The directory path or URI in the file system.")}, (SequenceType)new FunctionReturnSequenceType(22, 3, "the file contents")), new FunctionSignature(new QName("read", "http://exist-db.org/xquery/file", "file"), "Reads the content of file.  This method is only available to the DBA role.", new SequenceType[]{new FunctionParameterSequenceType("path", 11, 2, "The directory path or URI in the file system."), new FunctionParameterSequenceType("encoding", 22, 2, "The encoding type for the file")}, (SequenceType)new FunctionReturnSequenceType(22, 3, "the file contents"))};

    public FileRead(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (!this.context.getSubject().hasDbaRole()) {
            XPathException xPathException = new XPathException((Expression)this, "Permission denied, calling user '" + this.context.getSubject().getName() + "' must be a DBA to call this function.");
            logger.error("Invalid user", (Throwable)xPathException);
            throw xPathException;
        }
        String inputPath = args[0].getStringValue();
        Path file = FileModuleHelper.getFile(inputPath);
        Charset encoding = args.length == 2 ? Charset.forName(args[1].getStringValue()) : StandardCharsets.UTF_8;
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            Files.copy(file, os);
            StringValue stringValue = new StringValue(new String(os.toByteArray(), encoding));
            return stringValue;
        }
        catch (IOException e) {
            throw new XPathException((Expression)this, (Throwable)e);
        }
    }
}

