/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.file;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.storage.serializers.Serializer;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Option;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.file.FileModuleHelper;
import org.exist.xquery.util.SerializerUtils;
import org.exist.xquery.value.BinaryValue;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.Type;
import org.xml.sax.SAXException;

public class SerializeToFile
extends BasicFunction {
    private static final Logger logger = LogManager.getLogger(SerializeToFile.class);
    private static final String FN_SERIALIZE_LN = "serialize";
    private static final String FN_SERIALIZE_BINARY_LN = "serialize-binary";
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("serialize", "http://exist-db.org/xquery/file", "file"), "Writes the node set into a file on the file system. $parameters contains a sequence of zero or more serialization parameters specified as key=value pairs. The serialization options are the same as those recognized by \"declare option exist:serialize\". The function does NOT automatically inherit the serialization options of the XQuery it is called from.  This method is only available to the DBA role.", new SequenceType[]{new FunctionParameterSequenceType("node-set", -1, 7, "The contents to write to the file system."), new FunctionParameterSequenceType("path", 11, 2, "The full path or URI to the file"), new FunctionParameterSequenceType("parameters", 11, 7, "The serialization parameters: either a sequence of key=value pairs or an output:serialization-parameters element as defined by the standard fn:serialize function.")}, (SequenceType)new FunctionReturnSequenceType(23, 3, "true on success - false if the specified file can not be created or is not writable.  The empty sequence is returned if the argument sequence is empty.")), new FunctionSignature(new QName("serialize", "http://exist-db.org/xquery/file", "file"), "Writes the node set into a file on the file system, optionally appending to it. $parameters contains a sequence of zero or more serialization parameters specified as key=value pairs. The serialization options are the same as those recognized by \"declare option exist:serialize\". The function does NOT automatically inherit the serialization options of the XQuery it is called from.  This method is only available to the DBA role.", new SequenceType[]{new FunctionParameterSequenceType("node-set", -1, 7, "The contents to write to the file system."), new FunctionParameterSequenceType("path", 11, 2, "The full path or URI to the file"), new FunctionParameterSequenceType("parameters", 11, 7, "The serialization parameters: either a sequence of key=value pairs or an output:serialization-parameters element as defined by the standard fn:serialize function."), new FunctionParameterSequenceType("append", 23, 2, "Should content be appended?")}, (SequenceType)new FunctionReturnSequenceType(23, 3, "true on success - false if the specified file can not be created or is not writable.  The empty sequence is returned if the argument sequence is empty.")), new FunctionSignature(new QName("serialize-binary", "http://exist-db.org/xquery/file", "file"), "Writes binary data into a file on the file system.  This method is only available to the DBA role.", new SequenceType[]{new FunctionParameterSequenceType("binarydata", 26, 2, "The contents to write to the file system."), new FunctionParameterSequenceType("path", 11, 2, "The full path or URI to the file")}, (SequenceType)new FunctionReturnSequenceType(23, 2, "true on success - false if the specified file can not be created or is not writable")), new FunctionSignature(new QName("serialize-binary", "http://exist-db.org/xquery/file", "file"), "Writes binary data into a file on the file system, optionally appending the content.  This method is only available to the DBA role.", new SequenceType[]{new FunctionParameterSequenceType("binarydata", 26, 2, "The contents to write to the file system."), new FunctionParameterSequenceType("path", 11, 2, "The full path or URI to the file"), new FunctionParameterSequenceType("append", 23, 2, "Should content be appended?")}, (SequenceType)new FunctionReturnSequenceType(23, 2, "true on success - false if the specified file can not be created or is not writable"))};

    public SerializeToFile(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (args[0].isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        if (!this.context.getSubject().hasDbaRole()) {
            XPathException xPathException = new XPathException((Expression)this, "Permission denied, calling user '" + this.context.getSubject().getName() + "' must be a DBA to call this function.");
            logger.error("Invalid user", (Throwable)xPathException);
            throw xPathException;
        }
        String inputPath = args[1].getStringValue();
        Path file = FileModuleHelper.getFile(inputPath);
        if (Files.isDirectory(file, new LinkOption[0])) {
            logger.debug("Cannot serialize file. Output file is a directory: " + file.toAbsolutePath().toString());
            return BooleanValue.FALSE;
        }
        if (Files.exists(file, new LinkOption[0]) && !Files.isWritable(file)) {
            logger.debug("Cannot serialize file. Cannot write to file " + file.toAbsolutePath().toString());
            return BooleanValue.FALSE;
        }
        if (this.isCalledAs(FN_SERIALIZE_LN)) {
            Properties outputProperties = this.parseXMLSerializationOptions(args[2]);
            boolean doAppend = args.length > 3 && "true".equals(args[3].itemAt(0).getStringValue());
            this.serializeXML(args[0].iterate(), outputProperties, file, doAppend);
        } else if (this.isCalledAs(FN_SERIALIZE_BINARY_LN)) {
            boolean doAppend = args.length > 2 && "true".equals(args[2].itemAt(0).getStringValue());
            this.serializeBinary((BinaryValue)args[0].itemAt(0), file, doAppend);
        } else {
            throw new XPathException((Expression)this, "Unknown function name");
        }
        return BooleanValue.TRUE;
    }

    private Properties parseXMLSerializationOptions(Sequence sSerializeParams) throws XPathException {
        Properties outputProperties = new Properties();
        outputProperties.setProperty("indent", "yes");
        outputProperties.setProperty("omit-xml-declaration", "yes");
        if (sSerializeParams.hasOne() && Type.subTypeOf((int)sSerializeParams.getItemType(), (int)-1)) {
            SerializerUtils.getSerializationOptions((Expression)this, (NodeValue)((NodeValue)sSerializeParams.itemAt(0)), (Properties)outputProperties);
        } else {
            SequenceIterator siSerializeParams = sSerializeParams.iterate();
            while (siSerializeParams.hasNext()) {
                String serializeParam = siSerializeParams.nextItem().getStringValue();
                String[] opt = Option.parseKeyValuePair((String)serializeParam);
                if (opt == null || opt.length != 2) continue;
                outputProperties.setProperty(opt[0], opt[1]);
            }
        }
        return outputProperties;
    }

    private void serializeXML(SequenceIterator siNode, Properties outputProperties, Path file, boolean doAppend) throws XPathException {
        OpenOption[] openOptionArray;
        Serializer serializer = this.context.getBroker().getSerializer();
        serializer.reset();
        if (doAppend) {
            OpenOption[] openOptionArray2 = new StandardOpenOption[3];
            openOptionArray2[0] = StandardOpenOption.WRITE;
            openOptionArray2[1] = StandardOpenOption.CREATE;
            openOptionArray = openOptionArray2;
            openOptionArray2[2] = StandardOpenOption.APPEND;
        } else {
            StandardOpenOption[] standardOpenOptionArray = new StandardOpenOption[3];
            standardOpenOptionArray[0] = StandardOpenOption.WRITE;
            standardOpenOptionArray[1] = StandardOpenOption.CREATE;
            openOptionArray = standardOpenOptionArray;
            standardOpenOptionArray[2] = StandardOpenOption.TRUNCATE_EXISTING;
        }
        OpenOption[] ops = openOptionArray;
        try (OutputStream os = Files.newOutputStream(file, ops);
             OutputStreamWriter writer = new OutputStreamWriter(os);){
            serializer.setProperties(outputProperties);
            while (siNode.hasNext()) {
                NodeValue nv = (NodeValue)siNode.nextItem();
                serializer.serialize(nv, (Writer)writer);
            }
        }
        catch (IllegalArgumentException | UnsupportedOperationException e) {
            throw new XPathException((Expression)this, "Error wile writing to file: " + e.getMessage(), (Throwable)e);
        }
        catch (IOException | SAXException e) {
            throw new XPathException((Expression)this, "Cannot serialize file. A problem occurred while serializing the node set: " + e.getMessage(), (Throwable)e);
        }
    }

    private void serializeBinary(BinaryValue binary, Path file, boolean doAppend) throws XPathException {
        OpenOption[] openOptionArray;
        if (doAppend) {
            OpenOption[] openOptionArray2 = new StandardOpenOption[3];
            openOptionArray2[0] = StandardOpenOption.WRITE;
            openOptionArray2[1] = StandardOpenOption.CREATE;
            openOptionArray = openOptionArray2;
            openOptionArray2[2] = StandardOpenOption.APPEND;
        } else {
            StandardOpenOption[] standardOpenOptionArray = new StandardOpenOption[3];
            standardOpenOptionArray[0] = StandardOpenOption.WRITE;
            standardOpenOptionArray[1] = StandardOpenOption.CREATE;
            openOptionArray = standardOpenOptionArray;
            standardOpenOptionArray[2] = StandardOpenOption.TRUNCATE_EXISTING;
        }
        OpenOption[] ops = openOptionArray;
        try (OutputStream os = Files.newOutputStream(file, ops);){
            binary.streamBinaryTo(os);
        }
        catch (IOException ioe) {
            throw new XPathException((Expression)this, "Cannot serialize file. A problem occurred while serializing the binary data: " + ioe.getMessage(), (Throwable)ioe);
        }
    }
}

