/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.httpclient;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.OptionsMethod;
import org.apache.commons.httpclient.util.EncodingUtil;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.dom.memtree.DocumentBuilderReceiver;
import org.exist.dom.memtree.MemTreeBuilder;
import org.exist.dom.memtree.NodeImpl;
import org.exist.util.MimeTable;
import org.exist.util.MimeType;
import org.exist.util.io.CachingFilterInputStream;
import org.exist.util.io.FilterInputStreamCache;
import org.exist.util.io.FilterInputStreamCacheFactory;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.ModuleUtils;
import org.exist.xquery.modules.httpclient.HTTPClientModule;
import org.exist.xquery.value.Base64BinaryValueType;
import org.exist.xquery.value.BinaryValueFromInputStream;
import org.exist.xquery.value.BinaryValueManager;
import org.exist.xquery.value.BinaryValueType;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class BaseHTTPClientFunction
extends BasicFunction {
    protected static final Logger logger = LogManager.getLogger(BaseHTTPClientFunction.class);
    protected static final FunctionParameterSequenceType URI_PARAM = new FunctionParameterSequenceType("url", 25, 2, "The URL to process");
    protected static final FunctionParameterSequenceType PUT_CONTENT_PARAM = new FunctionParameterSequenceType("content", 11, 2, "The XML PUT payload/content. If it is an XML Node it will be serialized. If it is a binary stream it pass as it, any other type will be atomized into a string.");
    protected static final FunctionParameterSequenceType POST_CONTENT_PARAM = new FunctionParameterSequenceType("content", 11, 2, "The XML POST payload/content. If it is an XML Node it will be serialized, any other type will be atomized into a string.");
    protected static final FunctionParameterSequenceType POST_FORM_PARAM = new FunctionParameterSequenceType("content", 1, 2, "The form data in the format <httpclient:fields><httpclient:field name=\"\" value=\"\" type=\"string|file\"/>...</httpclient:fields>.  If the field values will be suitably URLEncoded and sent with the mime type application/x-www-form-urlencoded.");
    protected static final FunctionParameterSequenceType PERSIST_PARAM = new FunctionParameterSequenceType("persist", 23, 2, "Indicates if the HTTP state (eg. cookies, credentials, etc.) should persist for the life of this xquery");
    protected static final FunctionParameterSequenceType REQUEST_HEADER_PARAM = new FunctionParameterSequenceType("request-headers", 1, 3, "Any HTTP Request Headers to set in the form  <headers><header name=\"\" value=\"\"/></headers>");
    protected static final FunctionParameterSequenceType OPTIONS_PARAM = new FunctionParameterSequenceType("parser-options", 1, 3, "Feature and Property options to be passed to the HTML/XML parser in the form <options><feature name=\"\" value=\"{true|false}\"/><property name=\"\" value=\"\"/></options>");
    protected static final FunctionParameterSequenceType INDENTATION_PARAM = new FunctionParameterSequenceType("indentation", 31, 2, "Indentation level.  If this parameter is added, then the XML being put will be serailazed with indentation and the number is the number of characters for each level of indentation.  If this parameter is not include, then the XML is serialized to one line of text.");
    protected static final FunctionReturnSequenceType XML_BODY_RETURN = new FunctionReturnSequenceType(11, 2, "the XML body content");
    static final String NAMESPACE_URI = "http://exist-db.org/xquery/httpclient";
    static final String PREFIX = "httpclient";
    static final String HTTP_MODULE_PERSISTENT_STATE = "_eXist_httpclient_module_persistent_state";
    static final String HTTP_MODULE_PERSISTENT_OPTIONS = "_eXist_httpclient_module_persistent_options";
    static final String HTTP_EXCEPTION_STATUS_CODE = "500";

    public BaseHTTPClientFunction(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    protected void setHeaders(HttpMethod method, Node headers) throws XPathException {
        if (headers.getNodeType() == 1 && headers.getLocalName().equals("headers")) {
            NodeList headerList = headers.getChildNodes();
            for (int i = 0; i < headerList.getLength(); ++i) {
                Node header = headerList.item(i);
                if (header.getNodeType() != 1 || !header.getLocalName().equals("header")) continue;
                String name = ((Element)header).getAttribute("name");
                String value = ((Element)header).getAttribute("value");
                if (name == null || value == null) {
                    throw new XPathException((Expression)this, "Name or value attribute missing for request header parameter");
                }
                method.addRequestHeader(new Header(name, value));
            }
        }
    }

    protected Sequence doRequest(XQueryContext context, HttpMethod method, boolean persistState, Map<String, Boolean> parserFeatures, Map<String, String> parserProperties) throws IOException, XPathException {
        Sequence encodedResponse = null;
        HttpClient http = HTTPClientModule.httpClient;
        FeaturesAndProperties defaultFeaturesAndProperties = (FeaturesAndProperties)context.getXQueryContextVar(HTTP_MODULE_PERSISTENT_OPTIONS);
        if (defaultFeaturesAndProperties != null) {
            if (parserFeatures == null) {
                parserFeatures = defaultFeaturesAndProperties.getFeatures();
            }
            if (parserProperties == null) {
                parserProperties = defaultFeaturesAndProperties.getProperties();
            }
        }
        try {
            HttpState state;
            if (persistState && (state = (HttpState)context.getXQueryContextVar(HTTP_MODULE_PERSISTENT_STATE)) != null) {
                http.setState(state);
            }
            int statusCode = http.executeMethod(method);
            encodedResponse = this.encodeResponseAsXML(context, method, statusCode, parserFeatures, parserProperties);
            if (persistState) {
                context.setXQueryContextVar(HTTP_MODULE_PERSISTENT_STATE, (Object)http.getState());
            }
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
            encodedResponse = this.encodeErrorResponse(context, e.getMessage());
        }
        return encodedResponse;
    }

    private Sequence encodeResponseAsXML(XQueryContext context, HttpMethod method, int statusCode, Map<String, Boolean> parserFeatures, Map<String, String> parserProperties) throws XPathException, IOException {
        Header[] headers;
        MemTreeBuilder builder = context.getDocumentBuilder();
        builder.startDocument();
        builder.startElement(new QName("response", NAMESPACE_URI, PREFIX), null);
        builder.addAttribute(new QName("statusCode", null, null), String.valueOf(statusCode));
        builder.startElement(new QName("headers", NAMESPACE_URI, PREFIX), null);
        for (Header header : headers = method.getResponseHeaders()) {
            builder.startElement(new QName("header", NAMESPACE_URI, PREFIX), null);
            builder.addAttribute(new QName("name", null, null), header.getName());
            builder.addAttribute(new QName("value", null, null), header.getValue());
            builder.endElement();
        }
        builder.endElement();
        if (!(method instanceof HeadMethod) && !(method instanceof OptionsMethod)) {
            builder.startElement(new QName("body", NAMESPACE_URI, PREFIX), null);
            this.insertResponseBody(context, method, builder, parserFeatures, parserProperties);
            builder.endElement();
        }
        builder.endElement();
        return (NodeValue)builder.getDocument().getDocumentElement();
    }

    private Sequence encodeErrorResponse(XQueryContext context, String message) throws IOException, XPathException {
        MemTreeBuilder builder = context.getDocumentBuilder();
        builder.startDocument();
        builder.startElement(new QName("response", NAMESPACE_URI, PREFIX), null);
        builder.addAttribute(new QName("statusCode", null, null), HTTP_EXCEPTION_STATUS_CODE);
        builder.startElement(new QName("body", NAMESPACE_URI, PREFIX), null);
        builder.addAttribute(new QName("type", null, null), "text");
        builder.addAttribute(new QName("encoding", null, null), "URLEncoded");
        if (message != null) {
            builder.characters((CharSequence)URLEncoder.encode(message, "UTF-8"));
        }
        builder.endElement();
        builder.endElement();
        return (NodeValue)builder.getDocument().getDocumentElement();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertResponseBody(XQueryContext context, HttpMethod method, MemTreeBuilder builder, Map<String, Boolean> parserFeatures, Map<String, String> parserProperties) throws IOException, XPathException {
        block30: {
            NodeImpl responseNode = null;
            InputStream bodyAsStream = method.getResponseBodyAsStream();
            if (bodyAsStream != null) {
                CachingFilterInputStream cfis = null;
                FilterInputStreamCache cache = null;
                try {
                    CloseShieldInputStream shieldedInputStream;
                    cache = FilterInputStreamCacheFactory.getCacheInstance(() -> (String)context.getBroker().getConfiguration().getProperty("binary.cache.class"), (InputStream)bodyAsStream);
                    cfis = new CachingFilterInputStream(cache);
                    cfis.mark(Integer.MAX_VALUE);
                    Header responseContentType = method.getResponseHeader("Content-Type");
                    MimeType responseMimeType = this.getResponseMimeType(responseContentType);
                    if (responseContentType != null) {
                        builder.addAttribute(new QName("mimetype", null, null), responseContentType.getValue());
                    }
                    try {
                        shieldedInputStream = new CloseShieldInputStream((InputStream)cfis);
                        responseNode = (NodeImpl)ModuleUtils.streamToXML((XQueryContext)context, (InputStream)shieldedInputStream);
                        builder.addAttribute(new QName("type", null, null), "xml");
                        responseNode.copyTo(null, new DocumentBuilderReceiver(builder));
                    }
                    catch (SAXException se) {
                        String msg = "Request for URI '" + method.getURI().toString() + "' Could not parse http response content as XML (will try html, text or fallback to binary): " + se.getMessage();
                        if (logger.isDebugEnabled()) {
                            logger.debug(msg, (Throwable)se);
                        } else {
                            logger.info(msg);
                        }
                    }
                    catch (IOException ioe) {
                        String msg = "Request for URI '" + method.getURI().toString() + "' Could not read http response content: " + ioe.getMessage();
                        logger.error(msg, (Throwable)ioe);
                        throw new XPathException(msg, (Throwable)ioe);
                    }
                    if (responseNode == null && responseMimeType.getName().equals(MimeType.HTML_TYPE.getName())) {
                        try {
                            cfis.reset();
                            shieldedInputStream = new CloseShieldInputStream((InputStream)cfis);
                            responseNode = (NodeImpl)ModuleUtils.htmlToXHtml((XQueryContext)context, (InputSource)new InputSource((InputStream)shieldedInputStream), parserFeatures, parserProperties).getDocumentElement();
                            builder.addAttribute(new QName("type", null, null), "xhtml");
                            responseNode.copyTo(null, new DocumentBuilderReceiver(builder));
                        }
                        catch (URIException ue) {
                            throw new XPathException((Expression)this, ue.getMessage(), (Throwable)ue);
                        }
                        catch (SAXException se) {
                            logger.debug("Could not parse http response content from HTML to XML: " + se.getMessage(), (Throwable)se);
                        }
                    }
                    if (responseNode != null) break block30;
                    cfis.reset();
                    if (responseMimeType.getName().startsWith("text/")) {
                        builder.addAttribute(new QName("type", null, null), "text");
                        builder.addAttribute(new QName("encoding", null, null), "URLEncoded");
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        byte[] buf = new byte[4096];
                        int read = -1;
                        while ((read = cfis.read(buf)) > -1) {
                            baos.write(buf, 0, read);
                        }
                        baos.close();
                        builder.characters((CharSequence)URLEncoder.encode(EncodingUtil.getString((byte[])baos.toByteArray(), (String)((HttpMethodBase)method).getResponseCharSet()), "UTF-8"));
                        break block30;
                    }
                    builder.addAttribute(new QName("type", null, null), "binary");
                    builder.addAttribute(new QName("encoding", null, null), "Base64Encoded");
                    BinaryValueFromInputStream binary = null;
                    try {
                        binary = BinaryValueFromInputStream.getInstance((BinaryValueManager)context, (BinaryValueType)new Base64BinaryValueType(), (InputStream)cfis);
                        builder.characters((CharSequence)binary.getStringValue());
                    }
                    finally {
                        if (binary != null) {
                            binary.destroy(context, null);
                        }
                    }
                }
                finally {
                    if (cache != null) {
                        try {
                            cache.invalidate();
                        }
                        catch (IOException ioe) {
                            LOG.error(ioe.getMessage(), (Throwable)ioe);
                        }
                    }
                    if (cfis != null) {
                        try {
                            cfis.close();
                        }
                        catch (IOException ioe) {
                            LOG.error(ioe.getMessage(), (Throwable)ioe);
                        }
                    }
                }
            }
        }
    }

    protected MimeType getResponseMimeType(Header responseHeaderContentType) {
        MimeType returnMimeType = MimeType.BINARY_TYPE;
        if (responseHeaderContentType != null && responseHeaderContentType.getName().equals("Content-Type")) {
            String responseContentType = responseHeaderContentType.getValue();
            int contentTypeEnd = responseContentType.indexOf(";");
            if (contentTypeEnd == -1) {
                contentTypeEnd = responseContentType.length();
            }
            String responseMimeType = responseContentType.substring(0, contentTypeEnd);
            MimeTable mimeTable = MimeTable.getInstance();
            MimeType mimeType = mimeTable.getContentType(responseMimeType);
            if (mimeType != null) {
                returnMimeType = mimeType;
            }
        }
        return returnMimeType;
    }

    protected FeaturesAndProperties getParserFeaturesAndProperties(Node options) throws XPathException {
        HashMap<String, Boolean> features = new HashMap<String, Boolean>();
        HashMap<String, String> properties = new HashMap<String, String>();
        if (options.getNodeType() == 1 && options.getLocalName().equals("options")) {
            NodeList optionList = options.getChildNodes();
            for (int i = 0; i < optionList.getLength(); ++i) {
                Node option = optionList.item(i);
                if (option.getNodeType() != 1) continue;
                String name = ((Element)option).getAttribute("name");
                String value = ((Element)option).getAttribute("value");
                if (name == null || value == null) {
                    throw new XPathException((Expression)this, "Name or value attribute missing for parser feature/property");
                }
                if (option.getLocalName().equals("feature")) {
                    if (value.matches("(true|false)")) {
                        features.put(name, Boolean.parseBoolean(value));
                        continue;
                    }
                    throw new XPathException((Expression)this, "Feature value must be true or false");
                }
                if (!option.getLocalName().equals("property")) continue;
                properties.put(name, value);
            }
        }
        return new FeaturesAndProperties(features, properties);
    }

    protected static class FeaturesAndProperties {
        private final Map<String, Boolean> features;
        private final Map<String, String> properties;

        public FeaturesAndProperties(Map<String, Boolean> features, Map<String, String> properties) {
            this.features = features;
            this.properties = properties;
        }

        public Map<String, Boolean> getFeatures() {
            return this.features;
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }
    }
}

