/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.httpclient;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.NTCredentials;
import org.apache.commons.httpclient.ProxyHost;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.xquery.AbstractInternalModule;
import org.exist.xquery.FunctionDef;
import org.exist.xquery.modules.httpclient.ClearFunction;
import org.exist.xquery.modules.httpclient.DELETEFunction;
import org.exist.xquery.modules.httpclient.GETFunction;
import org.exist.xquery.modules.httpclient.HEADFunction;
import org.exist.xquery.modules.httpclient.OPTIONSFunction;
import org.exist.xquery.modules.httpclient.POSTFunction;
import org.exist.xquery.modules.httpclient.PUTFunction;
import org.exist.xquery.modules.httpclient.SetOptionsFunction;

public class HTTPClientModule
extends AbstractInternalModule {
    private static final Logger LOG = LogManager.getLogger(HTTPClientModule.class);
    public static final String NAMESPACE_URI = "http://exist-db.org/xquery/httpclient";
    public static final String PREFIX = "httpclient";
    public static final String INCLUSION_DATE = "2007-09-06";
    public static final String RELEASED_IN_VERSION = "eXist-1.2";
    public static final String HTTP_MODULE_PERSISTENT_STATE = "_eXist_httpclient_module_persistent_state";
    public static final String HTTP_MODULE_PERSISTENT_OPTIONS = "_eXist_httpclient_module_persistent_options";
    static final HttpClient httpClient = HTTPClientModule.setupHttpClient();
    private static final FunctionDef[] functions = new FunctionDef[]{new FunctionDef(GETFunction.signatures[0], GETFunction.class), new FunctionDef(GETFunction.signatures[1], GETFunction.class), new FunctionDef(PUTFunction.signatures[0], PUTFunction.class), new FunctionDef(PUTFunction.signatures[1], PUTFunction.class), new FunctionDef(DELETEFunction.signature, DELETEFunction.class), new FunctionDef(POSTFunction.signatures[0], POSTFunction.class), new FunctionDef(POSTFunction.signatures[1], POSTFunction.class), new FunctionDef(HEADFunction.signature, HEADFunction.class), new FunctionDef(OPTIONSFunction.signature, OPTIONSFunction.class), new FunctionDef(ClearFunction.signatures[0], ClearFunction.class), new FunctionDef(SetOptionsFunction.signatures[0], SetOptionsFunction.class)};

    public HTTPClientModule(Map<String, List<?>> parameters) {
        super(functions, parameters);
    }

    public String getNamespaceURI() {
        return NAMESPACE_URI;
    }

    public String getDefaultPrefix() {
        return PREFIX;
    }

    public String getDescription() {
        return "A module for performing HTTP requests as a client";
    }

    public String getReleaseVersion() {
        return RELEASED_IN_VERSION;
    }

    private static HttpClient setupHttpClient() {
        String proxyHost;
        MultiThreadedHttpConnectionManager httpConnectionManager = new MultiThreadedHttpConnectionManager();
        HttpClient client = new HttpClient((HttpConnectionManager)httpConnectionManager);
        String configFile = System.getProperty("http.configfile");
        if (configFile != null) {
            Path f = Paths.get(configFile, new String[0]);
            if (Files.exists(f, new LinkOption[0])) {
                HTTPClientModule.setConfigFromFile(f, client);
            } else {
                LOG.warn("http.configfile '" + f.toAbsolutePath() + "' does not exist!");
            }
        }
        if ((proxyHost = System.getProperty("http.proxyHost")) != null) {
            ProxyHost proxy = new ProxyHost(proxyHost, Integer.parseInt(System.getProperty("http.proxyPort")));
            client.getHostConfiguration().setProxyHost(proxy);
        }
        return client;
    }

    private static void setConfigFromFile(Path configFile, HttpClient http) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("http.configfile='" + configFile.toAbsolutePath() + "'");
        }
        Properties props = new Properties();
        try (InputStream is = Files.newInputStream(configFile, new OpenOption[0]);){
            UsernamePasswordCredentials credentials;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Loading proxy settings from " + configFile.toAbsolutePath());
            }
            props.load(is);
            String proxyHost = props.getProperty("proxy.host");
            int proxyPort = Integer.parseInt(props.getProperty("proxy.port", "8080"));
            String proxyUser = props.getProperty("proxy.user");
            String proxyPassword = props.getProperty("proxy.password");
            String proxyDomain = props.getProperty("proxy.ntlm.domain");
            if ("NONE".equalsIgnoreCase(proxyDomain)) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Forcing removal NTLM");
                }
                proxyDomain = null;
            }
            AuthScope authScope = new AuthScope(proxyHost, proxyPort);
            if (proxyDomain == null) {
                credentials = new UsernamePasswordCredentials(proxyUser, proxyPassword);
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Using NTLM authentication for '" + proxyDomain + "'");
                }
                credentials = new NTCredentials(proxyUser, proxyPassword, proxyHost, proxyDomain);
            }
            HttpState state = http.getState();
            http.getHostConfiguration().setProxy(proxyHost, proxyPort);
            state.setProxyCredentials(authScope, (Credentials)credentials);
            if (LOG.isDebugEnabled()) {
                LOG.info("Set proxy: " + proxyUser + "@" + proxyHost + ":" + proxyPort + (proxyDomain == null ? "" : " (NTLM:'" + proxyDomain + "')"));
            }
        }
        catch (IOException ex) {
            LOG.error("Failed to read proxy configuration from '" + configFile + "'");
        }
    }
}

