/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.httpclient;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Properties;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.methods.multipart.FilePart;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.PartSource;
import org.apache.commons.httpclient.methods.multipart.StringPart;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.util.serializer.SAXSerializer;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.httpclient.BaseHTTPClientFunction;
import org.exist.xquery.modules.httpclient.DBFile;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.Type;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;

public class POSTFunction
extends BaseHTTPClientFunction {
    protected static final Logger logger = LogManager.getLogger(POSTFunction.class);
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("post", "http://exist-db.org/xquery/httpclient", "httpclient"), "Performs a HTTP POST request. This method returns the HTTP response encoded as an XML fragment, that looks as follows: <httpclient:response xmlns:httpclient=\"http://exist-db.org/xquery/httpclient\" statusCode=\"200\"><httpclient:headers><httpclient:header name=\"name\" value=\"value\"/>...</httpclient:headers><httpclient:body type=\"xml|xhtml|text|binary\" mimetype=\"returned content mimetype\">body content</httpclient:body></httpclient:response> where XML body content will be returned as a Node, HTML body content will be tidied into an XML compatible form, a body with mime-type of \"text/...\" will be returned as a URLEncoded string, and any other body content will be returned as xs:base64Binary encoded data.", new SequenceType[]{URI_PARAM, POST_CONTENT_PARAM, PERSIST_PARAM, REQUEST_HEADER_PARAM}, (SequenceType)XML_BODY_RETURN), new FunctionSignature(new QName("post-form", "http://exist-db.org/xquery/httpclient", "httpclient"), "Performs a HTTP POST request for a form. This method returns the HTTP response encoded as an XML fragment, that looks as follows: <httpclient:response xmlns:httpclient=\"http://exist-db.org/xquery/httpclient\" statusCode=\"200\"><httpclient:headers><httpclient:header name=\"name\" value=\"value\"/>...</httpclient:headers><httpclient:body type=\"xml|xhtml|text|binary\" mimetype=\"returned content mimetype\">body content</httpclient:body></httpclient:response> where XML body content will be returned as a Node, HTML body content will be tidied into an XML compatible form, a body with mime-type of \"text/...\" will be returned as a URLEncoded string, and any other body content will be returned as xs:base64Binary encoded data.", new SequenceType[]{URI_PARAM, POST_FORM_PARAM, PERSIST_PARAM, REQUEST_HEADER_PARAM}, (SequenceType)XML_BODY_RETURN)};

    public POSTFunction(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        Sequence response = null;
        if (args[0].isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        String url = args[0].itemAt(0).getStringValue();
        Item payload = args[1].itemAt(0);
        boolean persistState = args[2].effectiveBooleanValue();
        PostMethod post = new PostMethod(url);
        if (this.isCalledAs("post")) {
            StringRequestEntity entity = null;
            if (Type.subTypeOf((int)payload.getType(), (int)-1)) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                OutputStreamWriter osw = null;
                try {
                    osw = new OutputStreamWriter((OutputStream)baos, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new XPathException((Expression)this, e.getMessage());
                }
                SAXSerializer sax = new SAXSerializer((Writer)osw, new Properties());
                try {
                    payload.toSAX(this.context.getBroker(), (ContentHandler)sax, new Properties());
                    osw.flush();
                    osw.close();
                }
                catch (Exception e) {
                    throw new XPathException((Expression)this, e.getMessage());
                }
                byte[] reqPayload = baos.toByteArray();
                entity = new ByteArrayRequestEntity(reqPayload, "application/xml; charset=utf-8");
            } else {
                try {
                    entity = new StringRequestEntity(payload.getStringValue(), "text/text; charset=utf-8", "UTF-8");
                }
                catch (UnsupportedEncodingException uee) {
                    uee.printStackTrace();
                }
            }
            post.setRequestEntity(entity);
        } else {
            if (!this.isCalledAs("post-form")) return Sequence.EMPTY_SEQUENCE;
            Node nPayload = ((NodeValue)payload).getNode();
            String ns = nPayload.getNamespaceURI();
            if (!(nPayload instanceof Element) || ns == null || !ns.equals("http://exist-db.org/xquery/httpclient") || !nPayload.getLocalName().equals("fields")) throw new XPathException((Expression)this, "fields must be provided");
            Part[] parts = this.parseFields((Element)nPayload);
            post.setRequestEntity((RequestEntity)new MultipartRequestEntity(parts, post.getParams()));
        }
        if (!args[3].isEmpty()) {
            this.setHeaders((HttpMethod)post, ((NodeValue)args[3].itemAt(0)).getNode());
        }
        try {
            response = this.doRequest(this.context, (HttpMethod)post, persistState, null, null);
            return response;
        }
        catch (IOException ioe) {
            throw new XPathException((Expression)this, ioe.getMessage(), (Throwable)ioe);
        }
        finally {
            post.releaseConnection();
        }
    }

    private Part[] parseFields(Element fields) throws XPathException {
        NodeList nlField = fields.getElementsByTagNameNS("http://exist-db.org/xquery/httpclient", "field");
        Part[] parts = new Part[nlField.getLength()];
        for (int i = 0; i < nlField.getLength(); ++i) {
            Element field = (Element)nlField.item(i);
            if (field.hasAttribute("type") && field.getAttribute("type").equals("file")) {
                try {
                    String url = field.getAttribute("value");
                    if (url.startsWith("xmldb:exist://")) {
                        parts[i] = new FilePart(field.getAttribute("name"), (PartSource)new DBFile(url.substring(13)));
                        continue;
                    }
                    parts[i] = new FilePart(field.getAttribute("name"), new File(url));
                    continue;
                }
                catch (FileNotFoundException e) {
                    throw new XPathException((Throwable)e);
                }
            }
            parts[i] = new StringPart(field.getAttribute("name"), field.getAttribute("value"));
        }
        return parts;
    }
}

