/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.httpclient;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.PutMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.util.serializer.IndentingXMLWriter;
import org.exist.util.serializer.SAXSerializer;
import org.exist.util.serializer.XMLWriter;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.httpclient.BaseHTTPClientFunction;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.Type;
import org.xml.sax.ContentHandler;

public class PUTFunction
extends BaseHTTPClientFunction {
    protected static final Logger logger = LogManager.getLogger(PUTFunction.class);
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("put", "http://exist-db.org/xquery/httpclient", "httpclient"), "Performs a HTTP PUT request.. This method returns the HTTP response encoded as an XML fragment, that looks as follows: <httpclient:response xmlns:httpclient=\"http://exist-db.org/xquery/httpclient\" statusCode=\"200\"><httpclient:headers><httpclient:header name=\"name\" value=\"value\"/>...</httpclient:headers><httpclient:body type=\"xml|xhtml|text|binary\" mimetype=\"returned content mimetype\">body content</httpclient:body></httpclient:response> where XML body content will be returned as a Node, HTML body content will be tidied into an XML compatible form, a body with mime-type of \"text/...\" will be returned as a URLEncoded string, and any other body content will be returned as xs:base64Binary encoded data.", new SequenceType[]{URI_PARAM, PUT_CONTENT_PARAM, PERSIST_PARAM, REQUEST_HEADER_PARAM}, (SequenceType)XML_BODY_RETURN), new FunctionSignature(new QName("put", "http://exist-db.org/xquery/httpclient", "httpclient"), "Performs a HTTP PUT request.. This method returns the HTTP response encoded as an XML fragment, that looks as follows: <httpclient:response xmlns:httpclient=\"http://exist-db.org/xquery/httpclient\" statusCode=\"200\"><httpclient:headers><httpclient:header name=\"name\" value=\"value\"/>...</httpclient:headers><httpclient:body type=\"xml|xhtml|text|binary\" mimetype=\"returned content mimetype\">body content</httpclient:body></httpclient:response> where XML body content will be returned as a Node, HTML body content will be tidied into an XML compatible form, a body with mime-type of \"text/...\" will be returned as a URLEncoded string, and any other body content will be returned as xs:base64Binary encoded data.", new SequenceType[]{URI_PARAM, PUT_CONTENT_PARAM, PERSIST_PARAM, REQUEST_HEADER_PARAM, INDENTATION_PARAM}, (SequenceType)XML_BODY_RETURN)};

    public PUTFunction(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        Sequence response = null;
        if (args[0].isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        String url = args[0].itemAt(0).getStringValue();
        Item payload = args[1].itemAt(0);
        boolean persistState = args[2].effectiveBooleanValue();
        String indentLevel = args.length >= 5 && !args[4].isEmpty() ? args[4].itemAt(0).toString() : null;
        ByteArrayRequestEntity entity = null;
        if (Type.subTypeOf((int)payload.getType(), (int)-1)) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)baos, StandardCharsets.UTF_8);
            IndentingXMLWriter xmlWriter = new IndentingXMLWriter((Writer)osw);
            Properties outputProperties = new Properties();
            outputProperties.setProperty("encoding", "UTF-8");
            if (indentLevel != null) {
                outputProperties.setProperty("indent", "yes");
                outputProperties.setProperty("indent-spaces", indentLevel);
            } else {
                outputProperties.setProperty("indent", "no");
            }
            xmlWriter.setOutputProperties(outputProperties);
            SAXSerializer sax = new SAXSerializer();
            sax.setReceiver((XMLWriter)xmlWriter);
            try {
                payload.toSAX(this.context.getBroker(), (ContentHandler)sax, new Properties());
                osw.flush();
                osw.close();
            }
            catch (Exception e) {
                throw new XPathException((Expression)this, (Throwable)e);
            }
            entity = new ByteArrayRequestEntity(baos.toByteArray(), "application/xml; charset=utf-8");
        } else if (Type.subTypeOf((int)payload.getType(), (int)26)) {
            entity = new ByteArrayRequestEntity((byte[])payload.toJavaObject(byte[].class));
        } else {
            try {
                entity = new StringRequestEntity(payload.getStringValue(), "text/text; charset=utf-8", "UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                uee.printStackTrace();
            }
        }
        PutMethod put = new PutMethod(url);
        put.setRequestEntity((RequestEntity)entity);
        if (!args[3].isEmpty()) {
            this.setHeaders((HttpMethod)put, ((NodeValue)args[3].itemAt(0)).getNode());
        }
        try {
            response = this.doRequest(this.context, (HttpMethod)put, persistState, null, null);
        }
        catch (IOException ioe) {
            throw new XPathException((Expression)this, ioe.getMessage(), (Throwable)ioe);
        }
        finally {
            put.releaseConnection();
        }
        return response;
    }
}

