/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.image;

import java.io.IOException;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.ImageInputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.dom.memtree.DocumentBuilderReceiver;
import org.exist.dom.memtree.MemTreeBuilder;
import org.exist.util.serializer.DOMStreamer;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.BinaryValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class GetMetadataFunction
extends BasicFunction {
    private static final Logger logger = LogManager.getLogger(GetMetadataFunction.class);
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("get-metadata", "http://exist-db.org/xquery/image", "image"), "Gets the metadata of the image passed in, returning the images XML metadata.", new SequenceType[]{new FunctionParameterSequenceType("image", 26, 2, "The image data"), new FunctionParameterSequenceType("native-format", 23, 2, "When true metadata of the images native format is returned, otherwise common java ImageIO metadata is returned.")}, (SequenceType)new FunctionReturnSequenceType(-1, 3, "the image metadata"), "Use the contentextraction module instead")};

    public GetMetadataFunction(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (args[0].isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        BinaryValue imageData = (BinaryValue)args[0].itemAt(0);
        if (args[1].isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        boolean nativeFormat = args[1].effectiveBooleanValue();
        try {
            ImageInputStream iis = ImageIO.createImageInputStream(imageData.getInputStream());
            return this.parseWithImageIO(iis, nativeFormat);
        }
        catch (IOException ioe) {
            throw new XPathException((Expression)this, ioe.getMessage(), (Throwable)ioe);
        }
    }

    private Sequence parseWithImageIO(ImageInputStream iis, boolean nativeFormat) throws IOException, XPathException {
        Iterator<ImageReader> readers = ImageIO.getImageReaders(iis);
        if (readers.hasNext()) {
            ImageReader imageReader = readers.next();
            imageReader.setInput(iis);
            IIOMetadata metadata = imageReader.getImageMetadata(0);
            Node nMetadata = null;
            nMetadata = nativeFormat ? metadata.getAsTree(metadata.getNativeMetadataFormatName()) : metadata.getAsTree("javax_imageio_1.0");
            if (nMetadata == null) {
                return Sequence.EMPTY_SEQUENCE;
            }
            this.context.pushDocumentContext();
            try {
                MemTreeBuilder builder = this.context.getDocumentBuilder();
                DocumentBuilderReceiver receiver = new DocumentBuilderReceiver(builder);
                DOMStreamer streamer = new DOMStreamer();
                streamer.setContentHandler((ContentHandler)receiver);
                streamer.serialize(nMetadata);
                Document docMetadata = receiver.getDocument();
                NodeValue nodeValue = (NodeValue)docMetadata;
                return nodeValue;
            }
            catch (SAXException se) {
                throw new XPathException((Expression)this, se.getMessage(), (Throwable)se);
            }
            finally {
                this.context.popDocumentContext();
            }
        }
        return Sequence.EMPTY_SEQUENCE;
    }
}

