/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.image;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import javax.imageio.ImageIO;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.collections.Collection;
import org.exist.dom.QName;
import org.exist.dom.persistent.BinaryDocument;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.txn.TransactionManager;
import org.exist.storage.txn.Txn;
import org.exist.util.FileUtils;
import org.exist.util.LockException;
import org.exist.xmldb.XmldbURI;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.image.ImageModule;
import org.exist.xquery.value.AnyURIValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.ValueSequence;

public class GetThumbnailsFunction
extends BasicFunction {
    private static final Logger logger = LogManager.getLogger(GetThumbnailsFunction.class);
    private static final int MAXTHUMBHEIGHT = 100;
    private static final int MAXTHUMBWIDTH = 100;
    private static final String THUMBPREFIX = "";
    private static final String THUMBPATH = "thumbs";
    public static final FunctionSignature signature = new FunctionSignature(new QName("thumbnail", "http://exist-db.org/xquery/image", "image"), "Generate thumbnails from the given database collection", new SequenceType[]{new FunctionParameterSequenceType("collection", 25, 2, "The URI to the collection"), new FunctionParameterSequenceType("thumbnail-location", 25, 3, "The location in the database where the thumbnails should be created, this can be a local path, with the prefix 'xmldb:' a absolute path within the database or with 'rel:' path relative to the given $collection.  You can leave this empty then the default is 'rel:/thumbs'. "), new FunctionParameterSequenceType("dimension", 31, 7, "The dimension of the thumbnails, if empty then the default values are 'maxheight = 100' and 'maxwidth = 100', the first value is 'maxheight' and the second 'maxwidth'. "), new FunctionParameterSequenceType("prefix", 22, 3, "The prefix to append to the thumbnail filenames")}, (SequenceType)new FunctionReturnSequenceType(22, 7, "the result"));

    public GetThumbnailsFunction(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        ValueSequence result = new ValueSequence();
        boolean isSaveToDataBase = false;
        if (args[0].isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        AnyURIValue picturePath = (AnyURIValue)args[0].itemAt(0);
        if (picturePath.getStringValue().startsWith("xmldb:exist://")) {
            picturePath = new AnyURIValue(picturePath.getStringValue().substring(14));
        }
        AnyURIValue thumbPath = null;
        if (args[1].isEmpty()) {
            thumbPath = new AnyURIValue(picturePath.toXmldbURI().append(THUMBPATH));
            isSaveToDataBase = true;
        } else {
            thumbPath = (AnyURIValue)args[1].itemAt(0);
            if (thumbPath.getStringValue().startsWith("file:")) {
                isSaveToDataBase = false;
                thumbPath = new AnyURIValue(thumbPath.getStringValue().substring(5));
            } else {
                isSaveToDataBase = true;
                try {
                    XmldbURI thumbsURI = XmldbURI.xmldbUriFor((String)thumbPath.getStringValue());
                    if (!thumbsURI.isAbsolute()) {
                        thumbsURI = picturePath.toXmldbURI().append(thumbPath.toString());
                    }
                    thumbPath = new AnyURIValue(thumbsURI.toString());
                }
                catch (URISyntaxException e) {
                    throw new XPathException((Expression)this, e.getMessage());
                }
            }
        }
        int maxThumbHeight = 100;
        int maxThumbWidth = 100;
        if (!args[2].isEmpty()) {
            maxThumbHeight = ((IntegerValue)args[2].itemAt(0)).getInt();
            if (args[2].hasMany()) {
                maxThumbWidth = ((IntegerValue)args[2].itemAt(1)).getInt();
            }
        }
        String prefix = THUMBPREFIX;
        if (!args[3].isEmpty()) {
            prefix = args[3].itemAt(0).getStringValue();
        }
        BrokerPool pool = null;
        try {
            pool = BrokerPool.getInstance();
        }
        catch (Exception e) {
            result.add((Item)new StringValue(e.getMessage()));
            return result;
        }
        DBBroker dbbroker = this.context.getBroker();
        TransactionManager transact = pool.getTransactionManager();
        try (Txn transaction = transact.beginTransaction();){
            List existingThumbsArray;
            Collection existingThumbsCol;
            Collection allPictures;
            Path thumbDir;
            Collection thumbCollection;
            block57: {
                thumbCollection = null;
                thumbDir = null;
                if (isSaveToDataBase) {
                    try {
                        thumbCollection = dbbroker.getOrCreateCollection(transaction, thumbPath.toXmldbURI());
                        dbbroker.saveCollection(transaction, thumbCollection);
                    }
                    catch (Exception e) {
                        throw new XPathException((Expression)this, e.getMessage());
                    }
                }
                thumbDir = Paths.get(thumbPath.toString(), new String[0]);
                if (!Files.isDirectory(thumbDir, new LinkOption[0])) {
                    try {
                        Files.createDirectories(thumbDir, new FileAttribute[0]);
                    }
                    catch (IOException e) {
                        throw new XPathException((Expression)this, e.getMessage());
                    }
                }
                allPictures = null;
                existingThumbsCol = null;
                existingThumbsArray = null;
                allPictures = dbbroker.getCollection(picturePath.toXmldbURI());
                if (allPictures != null) break block57;
                Sequence sequence = Sequence.EMPTY_SEQUENCE;
                return sequence;
            }
            try {
                if (isSaveToDataBase) {
                    existingThumbsCol = dbbroker.getCollection(thumbPath.toXmldbURI());
                } else {
                    existingThumbsArray = FileUtils.list((Path)thumbDir, path -> {
                        String fileName = FileUtils.fileName((Path)path);
                        return fileName.endsWith(".jpeg") || fileName.endsWith(".jpg");
                    });
                }
            }
            catch (IOException | PermissionDeniedException e) {
                throw new XPathException((Expression)this, e.getMessage(), e);
            }
            DocumentImpl docImage = null;
            BinaryDocument binImage = null;
            BinaryDocument doc = null;
            BufferedImage bImage = null;
            Object imgData = null;
            BufferedImage image = null;
            ByteArrayOutputStream os = null;
            try {
                Iterator i = allPictures.iterator(dbbroker);
                while (i.hasNext()) {
                    docImage = (DocumentImpl)i.next();
                    if (!this.fileExist(this.context.getBroker(), existingThumbsCol, docImage, prefix) && !this.fileExist(existingThumbsArray, docImage, prefix)) {
                        if (docImage.getResourceType() != 1 || !docImage.getMetadata().getMimeType().startsWith("image/jpeg")) continue;
                        binImage = (BinaryDocument)docImage;
                        try {
                            InputStream is = dbbroker.getBinaryResource(binImage);
                            image = ImageIO.read(is);
                        }
                        catch (IOException ioe) {
                            throw new XPathException((Expression)this, ioe.getMessage());
                        }
                        try {
                            bImage = ImageModule.createThumb(image, maxThumbHeight, maxThumbWidth);
                        }
                        catch (Exception e) {
                            throw new XPathException((Expression)this, e.getMessage());
                        }
                        if (isSaveToDataBase) {
                            os = new ByteArrayOutputStream();
                            try {
                                ImageIO.write((RenderedImage)bImage, "jpg", (OutputStream)os);
                            }
                            catch (Exception e) {
                                throw new XPathException((Expression)this, e.getMessage());
                            }
                            try {
                                doc = thumbCollection.addBinaryResource(transaction, dbbroker, XmldbURI.create((String)(prefix + docImage.getFileURI())), os.toByteArray(), "image/jpeg");
                                continue;
                            }
                            catch (Exception e) {
                                throw new XPathException((Expression)this, e.getMessage());
                            }
                        }
                        try {
                            ImageIO.write((RenderedImage)bImage, "jpg", Paths.get(thumbPath.toString() + "/" + prefix + docImage.getFileURI(), new String[0]).toFile());
                            continue;
                        }
                        catch (Exception e) {
                            throw new XPathException((Expression)this, e.getMessage());
                        }
                    }
                    result.add((Item)new StringValue(docImage.getFileURI().toString()));
                }
            }
            catch (PermissionDeniedException | LockException e) {
                throw new XPathException((Expression)this, e.getMessage(), e);
            }
            try {
                transact.commit(transaction);
            }
            catch (Exception e) {
                throw new XPathException((Expression)this, e.getMessage());
            }
        }
        Optional journalManager = pool.getJournalManager();
        journalManager.ifPresent(j -> j.flush(true, false));
        dbbroker.closeDocument();
        return result;
    }

    private boolean fileExist(DBBroker broker, Collection col, DocumentImpl file, String prefix) throws PermissionDeniedException {
        if (col != null) {
            return col.hasDocument(broker, XmldbURI.create((String)(prefix + file.getFileURI())));
        }
        return false;
    }

    private boolean fileExist(List<Path> cols, DocumentImpl file, String prefix) {
        if (cols != null) {
            for (Path col : cols) {
                if (!FileUtils.fileName((Path)col).endsWith(prefix + file.getFileURI())) continue;
                return true;
            }
        }
        return false;
    }
}

