/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.mail;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.xquery.AbstractInternalModule;
import org.exist.xquery.FunctionDef;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.ModuleUtils;
import org.exist.xquery.modules.mail.MailFolderFunctions;
import org.exist.xquery.modules.mail.MailSessionFunctions;
import org.exist.xquery.modules.mail.MailStoreFunctions;
import org.exist.xquery.modules.mail.MessageFunctions;
import org.exist.xquery.modules.mail.MessageListFunctions;
import org.exist.xquery.modules.mail.SendEmailFunction;

public class MailModule
extends AbstractInternalModule {
    private static final Logger LOG = LogManager.getLogger(MailModule.class);
    public static final String NAMESPACE_URI = "http://exist-db.org/xquery/mail";
    public static final String PREFIX = "mail";
    public static final String INCLUSION_DATE = "2005-05-12, 2009-03-14";
    public static final String RELEASED_IN_VERSION = "eXist-1.2 (JavaMail-based in trunk)";
    private static final FunctionDef[] functions = new FunctionDef[]{new FunctionDef(MailSessionFunctions.signatures[0], MailSessionFunctions.class), new FunctionDef(MailStoreFunctions.signatures[0], MailStoreFunctions.class), new FunctionDef(MailStoreFunctions.signatures[1], MailStoreFunctions.class), new FunctionDef(MailFolderFunctions.signatures[0], MailFolderFunctions.class), new FunctionDef(MailFolderFunctions.signatures[1], MailFolderFunctions.class), new FunctionDef(MessageListFunctions.signatures[0], MessageListFunctions.class), new FunctionDef(MessageListFunctions.signatures[1], MessageListFunctions.class), new FunctionDef(MessageListFunctions.signatures[2], MessageListFunctions.class), new FunctionDef(MessageListFunctions.signatures[3], MessageListFunctions.class), new FunctionDef(MessageFunctions.signatures[0], MessageFunctions.class), new FunctionDef(SendEmailFunction.signatures[0], SendEmailFunction.class), new FunctionDef(SendEmailFunction.deprecated, SendEmailFunction.class)};
    public static final String SESSIONS_CONTEXTVAR = "_eXist_mail_sessions";
    public static final String STORES_CONTEXTVAR = "_eXist_mail_stores";
    public static final String FOLDERS_CONTEXTVAR = "_eXist_mail_folders";
    public static final String FOLDERMSGLISTS_CONTEXTVAR = "_eXist_folder_message_lists";
    public static final String MSGLISTS_CONTEXTVAR = "_eXist_mail_message_lists";
    private static long currentSessionHandle = System.currentTimeMillis();

    public MailModule(Map<String, List<?>> parameters) {
        super(functions, parameters);
    }

    public String getNamespaceURI() {
        return NAMESPACE_URI;
    }

    public String getDefaultPrefix() {
        return PREFIX;
    }

    public String getDescription() {
        return "A module for performing email related functions";
    }

    public String getReleaseVersion() {
        return RELEASED_IN_VERSION;
    }

    static Session retrieveSession(XQueryContext context, long sessionHandle) {
        return (Session)ModuleUtils.retrieveObjectFromContextMap((XQueryContext)context, (String)SESSIONS_CONTEXTVAR, (long)sessionHandle);
    }

    static long storeSession(XQueryContext context, Session session) {
        return ModuleUtils.storeObjectInContextMap((XQueryContext)context, (String)SESSIONS_CONTEXTVAR, (Object)session);
    }

    static Store retrieveStore(XQueryContext context, long storeHandle) {
        return (Store)ModuleUtils.retrieveObjectFromContextMap((XQueryContext)context, (String)STORES_CONTEXTVAR, (long)storeHandle);
    }

    static long storeStore(XQueryContext context, Store store) {
        return ModuleUtils.storeObjectInContextMap((XQueryContext)context, (String)STORES_CONTEXTVAR, (Object)store);
    }

    static void removeStore(XQueryContext context, long storeHandle) {
        ModuleUtils.modifyContextMap((XQueryContext)context, (String)STORES_CONTEXTVAR, map -> {
            Store cfr_ignored_0 = (Store)map.remove(storeHandle);
        });
    }

    private static void closeAllStores(XQueryContext context) {
        ModuleUtils.modifyContextMap((XQueryContext)context, (String)STORES_CONTEXTVAR, (ModuleUtils.ContextMapModifier)new ModuleUtils.ContextMapEntryModifier<Store>(){

            public void modify(Map<Long, Store> map) {
                super.modify(map);
                map.clear();
            }

            public void modify(Map.Entry<Long, Store> entry) {
                Store store = entry.getValue();
                try {
                    store.close();
                }
                catch (MessagingException me) {
                    LOG.warn("Unable to close Mail Store: " + me.getMessage(), (Throwable)me);
                }
            }
        });
    }

    static Folder retrieveFolder(XQueryContext context, long folderHandle) {
        return (Folder)ModuleUtils.retrieveObjectFromContextMap((XQueryContext)context, (String)FOLDERS_CONTEXTVAR, (long)folderHandle);
    }

    static long storeFolder(XQueryContext context, Folder folder) {
        return ModuleUtils.storeObjectInContextMap((XQueryContext)context, (String)FOLDERS_CONTEXTVAR, (Object)folder);
    }

    static void removeFolder(XQueryContext context, long folderHandle) {
        ModuleUtils.modifyContextMap((XQueryContext)context, (String)FOLDERS_CONTEXTVAR, map -> {
            ModuleUtils.modifyContextMap((XQueryContext)context, (String)FOLDERMSGLISTS_CONTEXTVAR, map12 -> {
                Map folderMsgList = (Map)map12.get(folderHandle);
                ModuleUtils.modifyContextMap((XQueryContext)context, (String)MSGLISTS_CONTEXTVAR, map1 -> folderMsgList.keySet().forEach(map1::remove));
                map12.remove(folderHandle);
            });
            map.remove(folderHandle);
        });
    }

    private static void closeAllFolders(XQueryContext context) {
        ModuleUtils.modifyContextMap((XQueryContext)context, (String)FOLDERS_CONTEXTVAR, (ModuleUtils.ContextMapModifier)new ModuleUtils.ContextMapEntryModifier<Folder>(){

            public void modify(Map<Long, Folder> map) {
                super.modify(map);
                map.clear();
            }

            public void modify(Map.Entry<Long, Folder> entry) {
                Folder folder = entry.getValue();
                try {
                    folder.close(false);
                }
                catch (MessagingException me) {
                    LOG.warn("Unable to close Mail Folder: " + me.getMessage(), (Throwable)me);
                }
            }
        });
    }

    static Message[] retrieveMessageList(XQueryContext context, long msgListHandle) {
        return (Message[])ModuleUtils.retrieveObjectFromContextMap((XQueryContext)context, (String)MSGLISTS_CONTEXTVAR, (long)msgListHandle);
    }

    static long storeMessageList(XQueryContext context, Message[] msgList, long folderHandle) {
        long msgListHandle = ModuleUtils.storeObjectInContextMap((XQueryContext)context, (String)MSGLISTS_CONTEXTVAR, (Object)msgList);
        ModuleUtils.modifyContextMap((XQueryContext)context, (String)FOLDERMSGLISTS_CONTEXTVAR, map -> {
            Map folderMsgList = map.computeIfAbsent(folderHandle, k -> new HashMap());
            folderMsgList.put(msgListHandle, msgList);
        });
        return msgListHandle;
    }

    static void removeMessageList(XQueryContext context, long msgListHandle) {
        ModuleUtils.modifyContextMap((XQueryContext)context, (String)MSGLISTS_CONTEXTVAR, map -> {
            Message[] cfr_ignored_0 = (Message[])map.remove(msgListHandle);
        });
    }

    private static void closeAllMessageLists(XQueryContext context) {
        ModuleUtils.modifyContextMap((XQueryContext)context, (String)MSGLISTS_CONTEXTVAR, Map::clear);
    }

    public void reset(XQueryContext context, boolean keepGlobals) {
        super.reset(context, keepGlobals);
        MailModule.closeAllMessageLists(context);
        MailModule.closeAllFolders(context);
        MailModule.closeAllStores(context);
    }
}

