/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.math;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.AtomicValue;
import org.exist.xquery.value.DoubleValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.NumericValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class OneParamFunctions
extends BasicFunction {
    private static final Logger logger = LogManager.getLogger(OneParamFunctions.class);
    public static final FunctionSignature[] signature = new FunctionSignature[]{new FunctionSignature(new QName("abs", "http://exist-db.org/xquery/math"), "Calculates the absolute value (distance from zero) of a value or expression", new SequenceType[]{new FunctionParameterSequenceType("x", 34, 2, "The value to return the absolute value of")}, (SequenceType)new FunctionReturnSequenceType(34, 2, "the absolute value (distance from zero) of a value or expression")), new FunctionSignature(new QName("acos", "http://exist-db.org/xquery/math"), "Returns the arc cosine of an angle, in the range of 0.0 through pi.", new SequenceType[]{new FunctionParameterSequenceType("x", 34, 2, "The input number")}, (SequenceType)new FunctionReturnSequenceType(34, 2, "the result"), org.exist.xquery.functions.math.OneParamFunctions.FNS_ACOS), new FunctionSignature(new QName("asin", "http://exist-db.org/xquery/math"), "Returns the arc sine of an angle, in the range of -pi/2 through pi/2.", new SequenceType[]{new FunctionParameterSequenceType("x", 34, 2, "The input number")}, (SequenceType)new FunctionReturnSequenceType(34, 2, "result"), org.exist.xquery.functions.math.OneParamFunctions.FNS_ASIN), new FunctionSignature(new QName("atan", "http://exist-db.org/xquery/math"), "Returns the arc tangent of an angle, in the range of -pi/2 through pi/2.", new SequenceType[]{new FunctionParameterSequenceType("x", 34, 2, "The input number")}, (SequenceType)new FunctionReturnSequenceType(34, 2, "the result"), org.exist.xquery.functions.math.OneParamFunctions.FNS_ATAN), new FunctionSignature(new QName("ceil", "http://exist-db.org/xquery/math"), "Returns the smallest (closest to negative infinity) value that is not less than the argument and is equal to a mathematical integer.", new SequenceType[]{new FunctionParameterSequenceType("x", 34, 2, "The input number")}, (SequenceType)new FunctionReturnSequenceType(34, 2, "result")), new FunctionSignature(new QName("cos", "http://exist-db.org/xquery/math"), "Returns the trigonometric cosine of an angle.", new SequenceType[]{new FunctionParameterSequenceType("x", 34, 2, "The input number")}, (SequenceType)new FunctionReturnSequenceType(34, 2, "the cosine"), org.exist.xquery.functions.math.OneParamFunctions.FNS_COS), new FunctionSignature(new QName("exp", "http://exist-db.org/xquery/math"), "Calculates e (the Euler Constant) raised to the power of a value or expression", new SequenceType[]{new FunctionParameterSequenceType("x", 34, 2, "The input number")}, (SequenceType)new FunctionReturnSequenceType(34, 2, "e (the Euler Constant) raised to the power of a value or expression"), org.exist.xquery.functions.math.OneParamFunctions.FNS_EXP), new FunctionSignature(new QName("floor", "http://exist-db.org/xquery/math"), "Returns the largest (closest to positive infinity) value that is not greater than the argument and is equal to a mathematical integer.", new SequenceType[]{new FunctionParameterSequenceType("x", 34, 2, "The input number")}, (SequenceType)new FunctionReturnSequenceType(34, 2, "the floor value")), new FunctionSignature(new QName("log", "http://exist-db.org/xquery/math"), "Returns the natural logarithm (base e) of a number.", new SequenceType[]{new FunctionParameterSequenceType("x", 34, 2, "The input number")}, (SequenceType)new FunctionReturnSequenceType(34, 2, "the log"), org.exist.xquery.functions.math.OneParamFunctions.FNS_LOG), new FunctionSignature(new QName("round", "http://exist-db.org/xquery/math"), "Returns the double value that is closest to a integer.", new SequenceType[]{new FunctionParameterSequenceType("x", 34, 2, "The input number")}, (SequenceType)new FunctionReturnSequenceType(34, 2, "the rounded value")), new FunctionSignature(new QName("sin", "http://exist-db.org/xquery/math"), "Returns the trigonometric sine of an angle.", new SequenceType[]{new FunctionParameterSequenceType("x", 34, 2, "The input number")}, (SequenceType)new FunctionReturnSequenceType(34, 2, "the sine"), org.exist.xquery.functions.math.OneParamFunctions.FNS_SIN), new FunctionSignature(new QName("sqrt", "http://exist-db.org/xquery/math"), "Returns the correctly rounded positive square root of a number.", new SequenceType[]{new FunctionParameterSequenceType("x", 34, 2, "The input number")}, (SequenceType)new FunctionReturnSequenceType(34, 2, "the square root of $x"), org.exist.xquery.functions.math.OneParamFunctions.FNS_SQRT), new FunctionSignature(new QName("tan", "http://exist-db.org/xquery/math"), "Returns the tangent of the number passed as an argument in radians.", new SequenceType[]{new FunctionParameterSequenceType("radians", 34, 2, "The radians")}, (SequenceType)new FunctionReturnSequenceType(34, 2, "the tangent"), org.exist.xquery.functions.math.OneParamFunctions.FNS_TAN), new FunctionSignature(new QName("degrees", "http://exist-db.org/xquery/math"), "Converts angle in radians to degrees.", new SequenceType[]{new FunctionParameterSequenceType("radians", 34, 2, "The radians")}, (SequenceType)new FunctionReturnSequenceType(34, 2, "the degrees")), new FunctionSignature(new QName("radians", "http://exist-db.org/xquery/math"), "Converts angle in degrees to radians.", new SequenceType[]{new FunctionParameterSequenceType("degrees", 34, 2, "The degrees")}, (SequenceType)new FunctionReturnSequenceType(34, 2, "the radians"))};

    public OneParamFunctions(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        Sequence result;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start((Expression)this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName((int)this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
        }
        AtomicValue seq = args[0].convertTo(34);
        NumericValue value = (NumericValue)seq.itemAt(0).convertTo(34);
        if (seq.isEmpty()) {
            result = Sequence.EMPTY_SEQUENCE;
        } else {
            double calcValue = 0.0;
            String functionName = this.getSignature().getName().getLocalPart();
            if ("abs".equals(functionName)) {
                calcValue = Math.abs(value.getDouble());
            } else if ("acos".equals(functionName)) {
                calcValue = Math.acos(value.getDouble());
            } else if ("asin".equals(functionName)) {
                calcValue = Math.asin(value.getDouble());
            } else if ("atan".equals(functionName)) {
                calcValue = Math.atan(value.getDouble());
            } else if ("ceil".equals(functionName)) {
                calcValue = Math.ceil(value.getDouble());
            } else if ("cos".equals(functionName)) {
                calcValue = Math.cos(value.getDouble());
            } else if ("exp".equals(functionName)) {
                calcValue = Math.exp(value.getDouble());
            } else if ("floor".equals(functionName)) {
                calcValue = Math.floor(value.getDouble());
            } else if ("log".equals(functionName)) {
                calcValue = Math.log(value.getDouble());
            } else if ("round".equals(functionName)) {
                calcValue = Math.rint(value.getDouble());
            } else if ("sin".equals(functionName)) {
                calcValue = Math.sin(value.getDouble());
            } else if ("sqrt".equals(functionName)) {
                calcValue = Math.sqrt(value.getDouble());
            } else if ("tan".equals(functionName)) {
                calcValue = Math.tan(value.getDouble());
            } else if ("degrees".equals(functionName)) {
                calcValue = Math.toDegrees(value.getDouble());
            } else if ("radians".equals(functionName)) {
                calcValue = Math.toRadians(value.getDouble());
            } else {
                throw new XPathException((Expression)this, "Function " + functionName + " not found.");
            }
            result = new DoubleValue(calcValue);
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end((Expression)this, "", result);
        }
        return result;
    }
}

