/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.persistentlogin;

import java.security.SecureRandom;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.util.Base64Encoder;
import org.exist.xquery.XPathException;
import org.exist.xquery.value.ComputableValue;
import org.exist.xquery.value.DateTimeValue;
import org.exist.xquery.value.DurationValue;

public class PersistentLogin {
    private static final PersistentLogin instance = new PersistentLogin();
    private static final Logger LOG = LogManager.getLogger(PersistentLogin.class);
    public static final int DEFAULT_SERIES_LENGTH = 16;
    public static final int DEFAULT_TOKEN_LENGTH = 16;
    public static final int INVALIDATION_TIMEOUT = 20000;
    private Map<String, LoginDetails> seriesMap = Collections.synchronizedMap(new HashMap());
    private SecureRandom random = new SecureRandom();

    public static PersistentLogin getInstance() {
        return instance;
    }

    public LoginDetails register(String user, String password, DurationValue timeToLive) throws XPathException {
        DateTimeValue now = new DateTimeValue(new Date());
        DateTimeValue expires = (DateTimeValue)now.plus((ComputableValue)timeToLive);
        LoginDetails login = new LoginDetails(user, password, timeToLive, expires.getTimeInMillis());
        this.seriesMap.put(login.getSeries(), login);
        return login;
    }

    public LoginDetails lookup(String token) throws XPathException {
        String[] tokens = token.split(":");
        LoginDetails data = this.seriesMap.get(tokens[0]);
        if (data == null) {
            LOG.debug("No session found for series " + tokens[0]);
            return null;
        }
        long now = System.currentTimeMillis();
        if (now > data.expires) {
            LOG.debug("Persistent session expired");
            this.seriesMap.remove(tokens[0]);
            return null;
        }
        if (data.seqBehavior) {
            LOG.debug("Using sequential tokens");
            if (!data.checkAndUpdateToken(tokens[1])) {
                LOG.debug("Out-of-sequence request or cookie theft attack. Deleting session.");
                this.seriesMap.remove(tokens[0]);
                throw new XPathException("Token mismatch. This may indicate an out-of-sequence request (likely) or a cookie theft attack.  Session is deleted for security reasons.");
            }
        }
        return data;
    }

    public void invalidate(String token) {
        String[] tokens = token.split(":");
        this.seriesMap.remove(tokens[0]);
    }

    private String generateSeriesToken() {
        byte[] newSeries = new byte[16];
        this.random.nextBytes(newSeries);
        Base64Encoder encoder = new Base64Encoder();
        encoder.translate(newSeries);
        return new String(encoder.getCharArray());
    }

    private String generateToken() {
        byte[] newSeries = new byte[16];
        this.random.nextBytes(newSeries);
        Base64Encoder encoder = new Base64Encoder();
        encoder.translate(newSeries);
        return new String(encoder.getCharArray());
    }

    public class LoginDetails {
        private String userName;
        private String password;
        private String token;
        private String series;
        private long expires;
        private DurationValue timeToLive;
        private boolean seqBehavior = false;
        private Map<String, Long> invalidatedTokens = new HashMap<String, Long>();

        public LoginDetails(String user, String password, DurationValue timeToLive, long expires) {
            this.userName = user;
            this.password = password;
            this.timeToLive = timeToLive;
            this.expires = expires;
            this.token = PersistentLogin.this.generateToken();
            this.series = PersistentLogin.this.generateSeriesToken();
        }

        public String getToken() {
            return this.token;
        }

        public String getSeries() {
            return this.series;
        }

        public String getUser() {
            return this.userName;
        }

        public String getPassword() {
            return this.password;
        }

        public DurationValue getTimeToLive() {
            return this.timeToLive;
        }

        public boolean checkAndUpdateToken(String token) {
            if (this.token.equals(token)) {
                this.update();
                return true;
            }
            Long timeout = this.invalidatedTokens.get(token);
            if (timeout == null) {
                return false;
            }
            if (System.currentTimeMillis() > timeout) {
                this.invalidatedTokens.remove(token);
                return false;
            }
            return true;
        }

        public String update() {
            this.timeoutCheck();
            this.invalidatedTokens.put(this.token, System.currentTimeMillis() + 20000L);
            this.token = PersistentLogin.this.generateToken();
            return this.token;
        }

        private void timeoutCheck() {
            long now = System.currentTimeMillis();
            this.invalidatedTokens.entrySet().removeIf(entry -> (Long)entry.getValue() < now);
        }

        public String toString() {
            return this.series + ":" + this.token;
        }
    }
}

