/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.scheduler;

import org.exist.dom.QName;
import org.exist.scheduler.Scheduler;
import org.exist.security.Subject;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class DeleteScheduledJob
extends BasicFunction {
    public static final FunctionSignature signature = new FunctionSignature(new QName("delete-scheduled-job", "http://exist-db.org/xquery/scheduler", "scheduler"), "Delete the named job named from the Scheduler. Will only delete User Scheduled Jobs! Returns true if the Job was deleted.", new SequenceType[]{new FunctionParameterSequenceType("job-name", 22, 2, "The name of the job to be deleted")}, (SequenceType)new FunctionReturnSequenceType(23, 2, "a boolean value indicating success or failure on deleting the named job."));
    private Scheduler scheduler = null;

    public DeleteScheduledJob(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
        this.scheduler = context.getBroker().getBrokerPool().getScheduler();
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        String jobName = args[0].getStringValue();
        Subject user = this.context.getUser();
        if (!user.hasDbaRole()) {
            return BooleanValue.FALSE;
        }
        return BooleanValue.valueOf((boolean)this.scheduler.deleteJob(jobName, "eXist.User"));
    }
}

