/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.sql;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.util.ParametersExtractor;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.sql.SQLModule;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.w3c.dom.Node;

public class GetConnectionFunction
extends BasicFunction {
    protected static final FunctionReturnSequenceType RETURN_TYPE = new FunctionReturnSequenceType(37, 3, "an xs:long representing the connection handle");
    protected static final FunctionParameterSequenceType JDBC_PASSWORD_PARAM = new FunctionParameterSequenceType("password", 22, 2, "The SQL database password");
    protected static final FunctionParameterSequenceType JDBC_USERNAME_PARAM = new FunctionParameterSequenceType("username", 22, 2, "The SQL database username");
    protected static final FunctionParameterSequenceType JDBC_PROPERTIES_PARAM = new FunctionParameterSequenceType("properties", 1, 3, "The JDBC database connection properties in the form <properties><property name=\"\" value=\"\"/></properties>.");
    protected static final FunctionParameterSequenceType JDBC_URL_PARAM = new FunctionParameterSequenceType("url", 22, 2, "The JDBC connection URL");
    protected static final FunctionParameterSequenceType JDBC_DRIVER_CLASSNAME_PARAM = new FunctionParameterSequenceType("driver-classname", 22, 2, "The JDBC driver classname");
    private static final Logger logger = LogManager.getLogger(GetConnectionFunction.class);
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("get-connection", "http://exist-db.org/xquery/sql", "sql"), "Opens a connection to a SQL Database", new SequenceType[]{JDBC_DRIVER_CLASSNAME_PARAM, JDBC_URL_PARAM}, (SequenceType)RETURN_TYPE), new FunctionSignature(new QName("get-connection", "http://exist-db.org/xquery/sql", "sql"), "Opens a connection to a SQL Database", new SequenceType[]{JDBC_DRIVER_CLASSNAME_PARAM, JDBC_URL_PARAM, JDBC_PROPERTIES_PARAM}, (SequenceType)RETURN_TYPE), new FunctionSignature(new QName("get-connection", "http://exist-db.org/xquery/sql", "sql"), "Opens a connection to a SQL Database", new SequenceType[]{JDBC_DRIVER_CLASSNAME_PARAM, JDBC_URL_PARAM, JDBC_USERNAME_PARAM, JDBC_PASSWORD_PARAM}, (SequenceType)RETURN_TYPE)};

    public GetConnectionFunction(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (args[0].isEmpty() || args[1].isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        String dbDriver = args[0].getStringValue();
        String dbURL = args[1].getStringValue();
        try {
            Class.forName(dbDriver).newInstance();
            Connection con = null;
            if (args.length == 2) {
                con = DriverManager.getConnection(dbURL);
            } else if (args.length == 3) {
                Properties props = ParametersExtractor.parseProperties((Node)((NodeValue)args[2].itemAt(0)).getNode());
                con = DriverManager.getConnection(dbURL, props);
            } else if (args.length == 4) {
                String dbUser = args[2].getStringValue();
                String dbPassword = args[3].getStringValue();
                con = DriverManager.getConnection(dbURL, dbUser, dbPassword);
            }
            return new IntegerValue(SQLModule.storeConnection(this.context, con));
        }
        catch (IllegalAccessException iae) {
            logger.error("sql:get-connection() Illegal Access to database driver class: " + dbDriver, (Throwable)iae);
            throw new XPathException((Expression)this, "sql:get-connection() Illegal Access to database driver class: " + dbDriver, (Throwable)iae);
        }
        catch (ClassNotFoundException cnfe) {
            logger.error("sql:get-connection() Cannot find database driver class: " + dbDriver, (Throwable)cnfe);
            throw new XPathException((Expression)this, "sql:get-connection() Cannot find database driver class: " + dbDriver, (Throwable)cnfe);
        }
        catch (InstantiationException ie) {
            logger.error("sql:get-connection() Cannot instantiate database driver class: " + dbDriver, (Throwable)ie);
            throw new XPathException((Expression)this, "sql:get-connection() Cannot instantiate database driver class: " + dbDriver, (Throwable)ie);
        }
        catch (SQLException sqle) {
            logger.error("sql:get-connection() Cannot connect to database: " + dbURL, (Throwable)sqle);
            throw new XPathException((Expression)this, "sql:get-connection() Cannot connect to database: " + dbURL, (Throwable)sqle);
        }
    }
}

