/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.sql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.sql.PreparedStatementWithSQL;
import org.exist.xquery.modules.sql.SQLModule;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class PrepareFunction
extends BasicFunction {
    private static final Logger LOG = LogManager.getLogger(PrepareFunction.class);
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("prepare", "http://exist-db.org/xquery/sql", "sql"), "Prepares a SQL statement against a SQL db using the connection indicated by the connection handle.", new SequenceType[]{new FunctionParameterSequenceType("handle", 37, 2, "The connection handle"), new FunctionParameterSequenceType("sql-statement", 22, 2, "The SQL statement")}, (SequenceType)new FunctionReturnSequenceType(37, 3, "an xs:long representing the statement handle"))};

    public PrepareFunction(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (args[0].isEmpty() || args[1].isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        long connectionUID = ((IntegerValue)args[0].itemAt(0)).getLong();
        Connection con = SQLModule.retrieveConnection(this.context, connectionUID);
        if (con == null) {
            return Sequence.EMPTY_SEQUENCE;
        }
        String sql = args[1].getStringValue();
        PreparedStatement stmt = null;
        try {
            stmt = con.prepareStatement(sql);
            return new IntegerValue(SQLModule.storePreparedStatement(this.context, new PreparedStatementWithSQL(sql, stmt)));
        }
        catch (SQLException sqle) {
            LOG.error("sql:prepare() Caught SQLException \"" + sqle.getMessage() + "\" for SQL: \"" + sql + "\"", (Throwable)sqle);
            throw new XPathException((Expression)this, "sql:prepare() Caught SQLException \"" + sqle.getMessage() + "\" for SQL: \"" + sql + "\"", (Throwable)sqle);
        }
    }
}

