/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.sql;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.xquery.AbstractInternalModule;
import org.exist.xquery.FunctionDef;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.ModuleUtils;
import org.exist.xquery.modules.sql.ExecuteFunction;
import org.exist.xquery.modules.sql.GetConnectionFunction;
import org.exist.xquery.modules.sql.GetJNDIConnectionFunction;
import org.exist.xquery.modules.sql.PrepareFunction;
import org.exist.xquery.modules.sql.PreparedStatementWithSQL;

public class SQLModule
extends AbstractInternalModule {
    protected static final Logger LOG = LogManager.getLogger(SQLModule.class);
    public static final String NAMESPACE_URI = "http://exist-db.org/xquery/sql";
    public static final String PREFIX = "sql";
    public static final String INCLUSION_DATE = "2006-09-25";
    public static final String RELEASED_IN_VERSION = "eXist-1.2";
    private static final FunctionDef[] functions = new FunctionDef[]{new FunctionDef(GetConnectionFunction.signatures[0], GetConnectionFunction.class), new FunctionDef(GetConnectionFunction.signatures[1], GetConnectionFunction.class), new FunctionDef(GetConnectionFunction.signatures[2], GetConnectionFunction.class), new FunctionDef(GetJNDIConnectionFunction.signatures[0], GetJNDIConnectionFunction.class), new FunctionDef(GetJNDIConnectionFunction.signatures[1], GetJNDIConnectionFunction.class), new FunctionDef(ExecuteFunction.signatures[0], ExecuteFunction.class), new FunctionDef(ExecuteFunction.signatures[1], ExecuteFunction.class), new FunctionDef(PrepareFunction.signatures[0], PrepareFunction.class)};
    private static final long currentUID = System.currentTimeMillis();
    public static final String CONNECTIONS_CONTEXTVAR = "_eXist_sql_connections";
    public static final String PREPARED_STATEMENTS_CONTEXTVAR = "_eXist_sql_prepared_statements";

    public SQLModule(Map<String, List<?>> parameters) {
        super(functions, parameters);
    }

    public String getNamespaceURI() {
        return NAMESPACE_URI;
    }

    public String getDefaultPrefix() {
        return PREFIX;
    }

    public String getDescription() {
        return "A module for performing SQL queries against Databases, returning XML representations of the result sets.";
    }

    public String getReleaseVersion() {
        return RELEASED_IN_VERSION;
    }

    public static Connection retrieveConnection(XQueryContext context, long connectionUID) {
        return (Connection)ModuleUtils.retrieveObjectFromContextMap((XQueryContext)context, (String)CONNECTIONS_CONTEXTVAR, (long)connectionUID);
    }

    public static synchronized long storeConnection(XQueryContext context, Connection con) {
        return ModuleUtils.storeObjectInContextMap((XQueryContext)context, (String)CONNECTIONS_CONTEXTVAR, (Object)con);
    }

    public static PreparedStatementWithSQL retrievePreparedStatement(XQueryContext context, long preparedStatementUID) {
        return (PreparedStatementWithSQL)ModuleUtils.retrieveObjectFromContextMap((XQueryContext)context, (String)PREPARED_STATEMENTS_CONTEXTVAR, (long)preparedStatementUID);
    }

    public static synchronized long storePreparedStatement(XQueryContext context, PreparedStatementWithSQL stmt) {
        return ModuleUtils.storeObjectInContextMap((XQueryContext)context, (String)PREPARED_STATEMENTS_CONTEXTVAR, (Object)stmt);
    }

    public void reset(XQueryContext xqueryContext, boolean keepGlobals) {
        super.reset(xqueryContext, keepGlobals);
        SQLModule.closeAllPreparedStatements(xqueryContext);
        SQLModule.closeAllConnections(xqueryContext);
    }

    private static void closeAllConnections(XQueryContext xqueryContext) {
        ModuleUtils.modifyContextMap((XQueryContext)xqueryContext, (String)CONNECTIONS_CONTEXTVAR, (ModuleUtils.ContextMapModifier)new ModuleUtils.ContextMapEntryModifier<Connection>(){

            public void modify(Map<Long, Connection> map) {
                super.modify(map);
                map.clear();
            }

            public void modify(Map.Entry<Long, Connection> entry) {
                Connection con = entry.getValue();
                try {
                    con.close();
                }
                catch (SQLException se) {
                    LOG.warn("Unable to close JDBC Connection: " + se.getMessage(), (Throwable)se);
                }
            }
        });
    }

    private static void closeAllPreparedStatements(XQueryContext xqueryContext) {
        ModuleUtils.modifyContextMap((XQueryContext)xqueryContext, (String)PREPARED_STATEMENTS_CONTEXTVAR, (ModuleUtils.ContextMapModifier)new ModuleUtils.ContextMapEntryModifier<PreparedStatementWithSQL>(){

            public void modify(Map<Long, PreparedStatementWithSQL> map) {
                super.modify(map);
                map.clear();
            }

            public void modify(Map.Entry<Long, PreparedStatementWithSQL> entry) {
                PreparedStatementWithSQL stmt = entry.getValue();
                try {
                    stmt.getStmt().close();
                }
                catch (SQLException se) {
                    LOG.warn("Unable to close JDBC PreparedStatement: " + se.getMessage(), (Throwable)se);
                }
            }
        });
    }
}

