/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.xmldiff;

import java.util.Properties;
import javax.xml.transform.Source;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.storage.serializers.Serializer;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.BooleanValue;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.FunctionReturnSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.xml.sax.SAXException;
import org.xmlunit.builder.DiffBuilder;
import org.xmlunit.builder.Input;
import org.xmlunit.diff.Diff;

public class Compare
extends Function {
    private static final Logger logger = LogManager.getLogger(Compare.class);
    private static final Properties OUTPUT_PROPERTIES = new Properties();
    public static final FunctionSignature signature;

    public Compare(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start((Expression)this);
            this.context.getProfiler().message((Expression)this, 4, "DEPENDENCIES", Dependency.getDependenciesName((int)this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, 4, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        Expression arg1 = this.getArgument(0);
        Sequence s1 = arg1.eval(contextSequence, contextItem);
        Expression arg2 = this.getArgument(1);
        this.context.pushDocumentContext();
        Sequence s2 = arg2.eval(contextSequence, contextItem);
        this.context.popDocumentContext();
        if (s1.isEmpty()) {
            return BooleanValue.valueOf((boolean)s2.isEmpty());
        }
        if (s2.isEmpty()) {
            return BooleanValue.valueOf((boolean)s1.isEmpty());
        }
        BooleanValue result = null;
        StringBuilder v1 = new StringBuilder();
        StringBuilder v2 = new StringBuilder();
        try {
            boolean identical;
            int i;
            if (s1.hasMany()) {
                for (i = 0; i < s1.getItemCount(); ++i) {
                    v1.append(this.serialize((NodeValue)s1.itemAt(i)));
                }
            } else {
                v1.append(this.serialize((NodeValue)s1.itemAt(0)));
            }
            if (s2.hasMany()) {
                for (i = 0; i < s2.getItemCount(); ++i) {
                    v2.append(this.serialize((NodeValue)s2.itemAt(i)));
                }
            } else {
                v2.append(this.serialize((NodeValue)s2.itemAt(0)));
            }
            Source expected = Input.fromString((String)v1.toString()).build();
            Source actual = Input.fromString((String)v2.toString()).build();
            Diff diff = DiffBuilder.compare((Object)expected).withTest((Object)actual).checkForIdentical().build();
            boolean bl = identical = !diff.hasDifferences();
            if (!identical) {
                logger.warn("Diff result: " + diff.toString());
            }
            result = new BooleanValue(identical);
        }
        catch (Exception e) {
            throw new XPathException((Expression)this, "An exception occurred while serializing node for comparison: " + e.getMessage(), (Throwable)e);
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end((Expression)this, "", (Sequence)result);
        }
        return result;
    }

    private String serialize(NodeValue node) throws SAXException {
        Serializer serializer = this.context.getBroker().getSerializer();
        serializer.reset();
        serializer.setProperties(OUTPUT_PROPERTIES);
        return serializer.serialize(node);
    }

    static {
        OUTPUT_PROPERTIES.setProperty("indent", "no");
        OUTPUT_PROPERTIES.setProperty("omit-xml-declaration", "yes");
        signature = new FunctionSignature(new QName("compare", "http://exist-db.org/xquery/xmldiff", "xmldiff"), "Returns true() if the two node sets $node-set-1 and $node-set-2 are equal, otherwise false()", new SequenceType[]{new FunctionParameterSequenceType("node-set-1", -1, 7, "the first node set"), new FunctionParameterSequenceType("node-set-2", -1, 7, "the second node set")}, (SequenceType)new FunctionReturnSequenceType(23, 3, "true() if the two node sets $node-set-1 and $node-set-2 are equal, otherwise false()"));
    }
}

