/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.xslfo;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.dom.QName;
import org.exist.util.ParametersExtractor;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.modules.xslfo.ProcessorAdapter;
import org.exist.xquery.modules.xslfo.XSLFOModule;
import org.exist.xquery.value.Base64BinaryValueType;
import org.exist.xquery.value.BinaryValueFromInputStream;
import org.exist.xquery.value.BinaryValueManager;
import org.exist.xquery.value.BinaryValueType;
import org.exist.xquery.value.FunctionParameterSequenceType;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.NodeValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class RenderFunction
extends BasicFunction {
    private static final Logger logger = LogManager.getLogger(RenderFunction.class);
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("render", "http://exist-db.org/xquery/xslfo", "xslfo"), "Renders a given FO document. Returns an xs:base64binary of the result. Parameters are specified with the structure: <parameters><param name=\"param-name1\" value=\"param-value1\"/></parameters>. Recognised rendering parameters are: author, title, keywords and dpi. URL's in the FO can be resolved from: http, https, file and exist URI schemes. If you wish to access a resource in the local database then the URI 'exist://localhost/db' refers to the root collection.", new SequenceType[]{new FunctionParameterSequenceType("document", -1, 2, "FO document"), new FunctionParameterSequenceType("mime-type", 22, 2, ""), new FunctionParameterSequenceType("parameters", -1, 3, "parameters for the transform")}, (SequenceType)new FunctionParameterSequenceType("result", 26, 3, "result")), new FunctionSignature(new QName("render", "http://exist-db.org/xquery/xslfo", "xslfo"), "Renders a given FO document. Returns an xs:base64binary of the result. Parameters are specified with the structure: <parameters><param name=\"param-name1\" value=\"param-value1\"/></parameters>. Recognised rendering parameters are: author, title, keywords and dpi. URL's in the FO can be resolved from: http, https, file and exist URI schemes. If you wish to access a resource in the local database then the URI 'exist://localhost/db' refers to the root collection.", new SequenceType[]{new FunctionParameterSequenceType("document", -1, 2, "FO document"), new FunctionParameterSequenceType("mime-type", 22, 2, ""), new FunctionParameterSequenceType("parameters", -1, 3, "parameters for the transform"), new FunctionParameterSequenceType("config-file", -1, 3, "FOP Processor Configuration file")}, (SequenceType)new FunctionParameterSequenceType("result", 26, 3, "result"))};

    public RenderFunction(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (args[0].isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        Item inputNode = args[0].itemAt(0);
        String mimeType = args[1].getStringValue();
        Properties parameters = new Properties();
        if (!args[2].isEmpty()) {
            parameters = ParametersExtractor.parseParameters((Node)((NodeValue)args[2].itemAt(0)).getNode());
        }
        ProcessorAdapter adapter = null;
        try {
            adapter = ((XSLFOModule)this.getParentModule()).getProcessorAdapter();
            NodeValue configFile = args.length == 4 ? (NodeValue)args[3].itemAt(0) : null;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ContentHandler contentHandler = adapter.getContentHandler(this.context.getBroker(), configFile, parameters, mimeType, (OutputStream)baos);
            contentHandler.startDocument();
            inputNode.toSAX(this.context.getBroker(), contentHandler, new Properties());
            contentHandler.endDocument();
            BinaryValueFromInputStream binaryValueFromInputStream = BinaryValueFromInputStream.getInstance((BinaryValueManager)this.context, (BinaryValueType)new Base64BinaryValueType(), (InputStream)new ByteArrayInputStream(baos.toByteArray()));
            return binaryValueFromInputStream;
        }
        catch (SAXException se) {
            throw new XPathException((Expression)this, se.getMessage(), (Throwable)se);
        }
        finally {
            if (adapter != null) {
                adapter.cleanup();
            }
        }
    }
}

