/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.modules.xslfo;

import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.xquery.AbstractInternalModule;
import org.exist.xquery.FunctionDef;
import org.exist.xquery.modules.xslfo.ProcessorAdapter;
import org.exist.xquery.modules.xslfo.RenderFunction;

public class XSLFOModule
extends AbstractInternalModule {
    private static final Logger logger = LogManager.getLogger(XSLFOModule.class);
    public static final String NAMESPACE_URI = "http://exist-db.org/xquery/xslfo";
    public static final String PREFIX = "xslfo";
    public static final String INCLUSION_DATE = "2007-10-04";
    public static final String RELEASED_IN_VERSION = "eXist-1.2";
    private static final FunctionDef[] functions = new FunctionDef[]{new FunctionDef(RenderFunction.signatures[0], RenderFunction.class), new FunctionDef(RenderFunction.signatures[1], RenderFunction.class)};
    private ProcessorAdapter adapter = null;

    public XSLFOModule(Map<String, List<? extends Object>> parameters) {
        super(functions, parameters);
    }

    public String getNamespaceURI() {
        return NAMESPACE_URI;
    }

    public String getDefaultPrefix() {
        return PREFIX;
    }

    public String getDescription() {
        return "A module for performing XSL-FO transformations";
    }

    public String getReleaseVersion() {
        return RELEASED_IN_VERSION;
    }

    public synchronized ProcessorAdapter getProcessorAdapter() {
        List processorAdapterParamList;
        if (this.adapter == null && !(processorAdapterParamList = this.getParameter("processorAdapter")).isEmpty()) {
            String processorAdapter = (String)processorAdapterParamList.get(0);
            try {
                Class<?> clazzAdapter = Class.forName(processorAdapter);
                this.adapter = (ProcessorAdapter)clazzAdapter.newInstance();
            }
            catch (ClassNotFoundException cnfe) {
                logger.error("Unable to instantiate FO Processor Adapter:" + cnfe.getMessage(), (Throwable)cnfe);
            }
            catch (InstantiationException ie) {
                logger.error("Unable to instantiate FO Processor Adapter:" + ie.getMessage(), (Throwable)ie);
            }
            catch (IllegalAccessException iae) {
                logger.error("Unable to instantiate FO Processor Adapter:" + iae.getMessage(), (Throwable)iae);
            }
        }
        return this.adapter;
    }
}

