/*
 * Decompiled with CFR 0.152.
 */
package org.exist.webdav;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.collections.IndexInfo;
import org.exist.collections.triggers.TriggerException;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.lock.Lock;
import org.exist.storage.txn.TransactionManager;
import org.exist.storage.txn.Txn;
import org.exist.util.LockException;
import org.exist.util.MimeTable;
import org.exist.util.MimeType;
import org.exist.util.VirtualTempFile;
import org.exist.util.VirtualTempFileInputSource;
import org.exist.webdav.ExistResource;
import org.exist.webdav.exceptions.CollectionDoesNotExistException;
import org.exist.webdav.exceptions.CollectionExistsException;
import org.exist.xmldb.XmldbURI;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ExistCollection
extends ExistResource {
    public ExistCollection(XmldbURI uri, BrokerPool pool) {
        if (LOG.isTraceEnabled()) {
            LOG.trace(String.format("New collection object for %s", uri));
        }
        this.brokerPool = pool;
        this.xmldbUri = uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initMetadata() {
        if (this.subject == null) {
            LOG.error("User not initialized yet");
            return;
        }
        if (this.isInitialized) {
            LOG.debug("Already initialized");
            return;
        }
        try (DBBroker broker = this.brokerPool.get(Optional.of(this.subject));){
            Collection collection = null;
            try {
                collection = broker.openCollection(this.xmldbUri, Lock.LockMode.READ_LOCK);
                if (collection == null) {
                    LOG.error(String.format("Collection for %s cannot be opened for metadata", this.xmldbUri));
                    return;
                }
                this.permissions = collection.getPermissionsNoLock();
                this.readAllowed = this.permissions.validate(this.subject, 4);
                this.writeAllowed = this.permissions.validate(this.subject, 2);
                this.executeAllowed = this.permissions.validate(this.subject, 1);
                this.lastModified = this.creationTime = Long.valueOf(collection.getCreationTime());
                this.ownerUser = this.permissions.getOwner().getUsername();
                this.ownerGroup = this.permissions.getGroup().getName();
            }
            finally {
                if (collection != null) {
                    collection.release(Lock.LockMode.READ_LOCK);
                }
            }
        }
        catch (EXistException | PermissionDeniedException pde) {
            LOG.error((Object)pde);
        }
        this.isInitialized = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<XmldbURI> getCollectionURIs() {
        ArrayList<XmldbURI> collectionURIs = new ArrayList<XmldbURI>();
        try (DBBroker broker = this.brokerPool.get(Optional.ofNullable(this.subject));){
            Collection collection = null;
            try {
                collection = broker.openCollection(this.xmldbUri, Lock.LockMode.READ_LOCK);
                Iterator collections = collection.collectionIteratorNoLock(broker);
                while (collections.hasNext()) {
                    collectionURIs.add(this.xmldbUri.append((XmldbURI)collections.next()));
                }
            }
            finally {
                if (collection != null) {
                    collection.release(Lock.LockMode.READ_LOCK);
                }
            }
        }
        catch (EXistException | PermissionDeniedException e) {
            LOG.error((Object)e);
            return new ArrayList<XmldbURI>();
        }
        return collectionURIs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<XmldbURI> getDocumentURIs() {
        ArrayList<XmldbURI> documentURIs = new ArrayList<XmldbURI>();
        try (DBBroker broker = this.brokerPool.get(Optional.ofNullable(this.subject));){
            Collection collection = null;
            try {
                collection = broker.openCollection(this.xmldbUri, Lock.LockMode.READ_LOCK);
                Iterator documents = collection.iteratorNoLock(broker);
                while (documents.hasNext()) {
                    documentURIs.add(((DocumentImpl)documents.next()).getURI());
                }
            }
            finally {
                if (collection != null) {
                    collection.release(Lock.LockMode.READ_LOCK);
                }
            }
        }
        catch (EXistException | PermissionDeniedException e) {
            LOG.error((Object)e);
            return new ArrayList<XmldbURI>();
        }
        return documentURIs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void delete() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Deleting '%s'", this.xmldbUri));
        }
        Collection collection = null;
        TransactionManager txnManager = this.brokerPool.getTransactionManager();
        try (DBBroker broker = this.brokerPool.get(Optional.ofNullable(this.subject));
             Txn txn = txnManager.beginTransaction();){
            collection = broker.openCollection(this.xmldbUri, Lock.LockMode.WRITE_LOCK);
            if (collection == null) {
                txnManager.abort(txn);
                return;
            }
            broker.removeCollection(txn, collection);
            txnManager.commit(txn);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Document deleted sucessfully");
            }
        }
        catch (IOException | EXistException | TriggerException | PermissionDeniedException e) {
            LOG.error((Object)e);
        }
        finally {
            if (collection != null) {
                collection.release(Lock.LockMode.WRITE_LOCK);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Finished delete");
            }
        }
    }

    public XmldbURI createCollection(String name) throws PermissionDeniedException, CollectionExistsException, EXistException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Create  '%s' in '%s'", name, this.xmldbUri));
        }
        XmldbURI newCollection = this.xmldbUri.append(name);
        Collection collection = null;
        TransactionManager txnManager = this.brokerPool.getTransactionManager();
        try (DBBroker broker = this.brokerPool.get(Optional.ofNullable(this.subject));
             Txn txn = txnManager.beginTransaction();){
            collection = broker.openCollection(newCollection, Lock.LockMode.WRITE_LOCK);
            if (collection != null) {
                String msg = "Collection already exists";
                LOG.debug("Collection already exists");
                txnManager.abort(txn);
                throw new CollectionExistsException("Collection already exists");
            }
            Collection created = broker.getOrCreateCollection(txn, newCollection);
            broker.saveCollection(txn, created);
            broker.flush();
            txnManager.commit(txn);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Collection created sucessfully");
            }
        }
        catch (EXistException | PermissionDeniedException e) {
            LOG.error((Object)e);
            throw e;
        }
        catch (Throwable e) {
            LOG.error((Object)e);
            throw new EXistException(e);
        }
        finally {
            if (collection != null) {
                collection.release(Lock.LockMode.WRITE_LOCK);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Finished creation");
            }
        }
        return newCollection;
    }

    public XmldbURI createFile(String newName, InputStream is, Long length, String contentType) throws IOException, PermissionDeniedException, CollectionDoesNotExistException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Create '%s' in '%s'", newName, this.xmldbUri));
        }
        XmldbURI newNameUri = XmldbURI.create((String)newName);
        MimeType mime = MimeTable.getInstance().getContentTypeFor(newName);
        if (mime == null) {
            mime = MimeType.BINARY_TYPE;
        }
        Collection collection = null;
        VirtualTempFile vtf = new VirtualTempFile();
        try (BufferedInputStream bis = new BufferedInputStream(is);
             BufferedOutputStream bos = new BufferedOutputStream((OutputStream)vtf);){
            IOUtils.copy((InputStream)bis, (OutputStream)bos);
        }
        vtf.close();
        if (mime.isXMLType() && vtf.length() == 0L) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Creating dummy XML file for null resource lock '%s'", newNameUri));
            }
            vtf = new VirtualTempFile();
            IOUtils.write((String)"<null_resource/>", (OutputStream)vtf);
            vtf.close();
        }
        TransactionManager txnManager = this.brokerPool.getTransactionManager();
        try (DBBroker broker = this.brokerPool.get(Optional.ofNullable(this.subject));
             Txn txn = txnManager.beginTransaction();){
            collection = broker.openCollection(this.xmldbUri, Lock.LockMode.WRITE_LOCK);
            if (collection == null) {
                LOG.debug(String.format("Collection %s does not exist", this.xmldbUri));
                txnManager.abort(txn);
                throw new CollectionDoesNotExistException(this.xmldbUri + "");
            }
            if (mime.isXMLType()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(String.format("Inserting XML document '%s'", mime.getName()));
                }
                try (VirtualTempFileInputSource vtfis = new VirtualTempFileInputSource(vtf);){
                    IndexInfo info = collection.validateXMLResource(txn, broker, newNameUri, (InputSource)vtfis);
                    DocumentImpl doc = info.getDocument();
                    doc.getMetadata().setMimeType(mime.getName());
                    collection.store(txn, broker, info, (InputSource)vtfis);
                }
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Inserting BINARY document '%s'", mime.getName()));
            }
            try (InputStream fis = vtf.getByteStream();
                 BufferedInputStream bis = new BufferedInputStream(fis);){
                collection.addBinaryResource(txn, broker, newNameUri, (InputStream)bis, mime.getName(), length.longValue());
            }
            txnManager.commit(txn);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Document created sucessfully");
            }
        }
        catch (EXistException | SAXException e) {
            LOG.error((Object)e);
            throw new IOException(e);
        }
        catch (LockException e) {
            LOG.error((Object)e);
            throw new PermissionDeniedException(this.xmldbUri + "");
        }
        catch (IOException | PermissionDeniedException e) {
            LOG.error((Object)e);
            throw e;
        }
        finally {
            if (vtf != null) {
                vtf.delete();
            }
            if (collection != null) {
                collection.release(Lock.LockMode.WRITE_LOCK);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Finished creation");
            }
        }
        XmldbURI newResource = this.xmldbUri.append(newName);
        return newResource;
    }

    /*
     * Exception decompiling
     */
    void resourceCopyMove(XmldbURI destCollectionUri, String newName, ExistResource.Mode mode) throws EXistException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

