/*
 * Decompiled with CFR 0.152.
 */
package org.exist.webdav;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.util.Optional;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.collections.triggers.TriggerException;
import org.exist.dom.persistent.BinaryDocument;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.dom.persistent.LockToken;
import org.exist.security.Account;
import org.exist.security.PermissionDeniedException;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.lock.Lock;
import org.exist.storage.serializers.Serializer;
import org.exist.storage.txn.TransactionManager;
import org.exist.storage.txn.Txn;
import org.exist.util.LockException;
import org.exist.util.VirtualTempFile;
import org.exist.webdav.ExistResource;
import org.exist.webdav.exceptions.DocumentAlreadyLockedException;
import org.exist.webdav.exceptions.DocumentNotLockedException;
import org.exist.xmldb.XmldbURI;
import org.xml.sax.SAXException;

public class ExistDocument
extends ExistResource {
    private String mimeType;
    private long contentLength = 0L;
    private boolean isXmlDocument = false;

    public ExistDocument(XmldbURI uri, BrokerPool pool) {
        if (LOG.isTraceEnabled()) {
            LOG.trace(String.format("New document object for %s", uri));
        }
        this.brokerPool = pool;
        this.xmldbUri = uri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initMetadata() {
        if (this.subject == null) {
            LOG.error("User not initialized yet");
            return;
        }
        if (this.isInitialized) {
            LOG.debug("Already initialized");
            return;
        }
        try (DBBroker broker = this.brokerPool.get(Optional.of(this.subject));){
            DocumentImpl document = null;
            try {
                document = broker.getXMLResource(this.xmldbUri, Lock.LockMode.READ_LOCK);
                if (document.getResourceType() == 0) {
                    this.isXmlDocument = true;
                }
                this.creationTime = document.getMetadata().getCreated();
                this.lastModified = document.getMetadata().getLastModified();
                this.mimeType = document.getMetadata().getMimeType();
                this.permissions = document.getPermissions();
                this.readAllowed = this.permissions.validate(this.subject, 4);
                this.writeAllowed = this.permissions.validate(this.subject, 2);
                this.executeAllowed = this.permissions.validate(this.subject, 1);
                this.ownerUser = this.permissions.getOwner().getUsername();
                this.ownerGroup = this.permissions.getGroup().getName();
                this.contentLength = document.getContentLength();
            }
            finally {
                if (document != null) {
                    document.getUpdateLock().release(Lock.LockMode.READ_LOCK);
                }
            }
        }
        catch (EXistException | PermissionDeniedException e) {
            LOG.error((Object)e);
        }
        this.isInitialized = true;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public boolean isXmlDocument() {
        return this.isXmlDocument;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stream(OutputStream os) throws IOException, PermissionDeniedException {
        long startTime;
        block40: {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Stream started");
            }
            startTime = System.currentTimeMillis();
            try (DBBroker broker = this.brokerPool.get(Optional.ofNullable(this.subject));){
                DocumentImpl document = null;
                try {
                    document = broker.getXMLResource(this.xmldbUri, Lock.LockMode.READ_LOCK);
                    if (document.getResourceType() == 0) {
                        Serializer serializer = broker.getSerializer();
                        serializer.reset();
                        try {
                            if (!this.configuration.isEmpty()) {
                                serializer.setProperties(this.configuration);
                            }
                            try (OutputStreamWriter w = new OutputStreamWriter(os, "UTF-8");){
                                serializer.serialize(document, (Writer)w);
                                ((Writer)w).flush();
                            }
                            if (!(os instanceof VirtualTempFile)) {
                                os.flush();
                            }
                            break block40;
                        }
                        catch (SAXException e) {
                            LOG.error((Object)e);
                            throw new IOException(String.format("Error while serializing XML document: %s", e.getMessage()), e);
                        }
                    }
                    broker.readBinaryResource((BinaryDocument)document, os);
                    os.flush();
                }
                finally {
                    if (document != null) {
                        document.getUpdateLock().release(Lock.LockMode.READ_LOCK);
                    }
                }
            }
            catch (EXistException e) {
                try {
                    LOG.error((Object)e);
                    throw new IOException(e.getMessage());
                    catch (PermissionDeniedException e2) {
                        LOG.error((Object)e2);
                        throw e2;
                    }
                }
                catch (Throwable throwable) {
                    if (!LOG.isDebugEnabled()) throw throwable;
                    LOG.debug(String.format("Stream stopped, duration %s msec.", System.currentTimeMillis() - startTime));
                    throw throwable;
                }
            }
        }
        if (!LOG.isDebugEnabled()) return;
        LOG.debug(String.format("Stream stopped, duration %s msec.", System.currentTimeMillis() - startTime));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void delete() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Deleting %s", this.xmldbUri));
        }
        Collection collection = null;
        DocumentImpl resource = null;
        TransactionManager txnManager = this.brokerPool.getTransactionManager();
        try (DBBroker broker = this.brokerPool.get(Optional.ofNullable(this.subject));
             Txn txn = txnManager.beginTransaction();){
            XmldbURI collName = this.xmldbUri.removeLastSegment();
            XmldbURI docName = this.xmldbUri.lastSegment();
            collection = broker.openCollection(collName, Lock.LockMode.WRITE_LOCK);
            if (collection == null) {
                LOG.debug("Collection does not exist");
                txnManager.abort(txn);
                return;
            }
            resource = collection.getDocument(broker, docName);
            if (resource == null) {
                LOG.debug(String.format("No resource found for path: %s", this.xmldbUri));
                txnManager.abort(txn);
                return;
            }
            if (resource.getResourceType() == 1) {
                collection.removeBinaryResource(txn, broker, resource.getFileURI());
            } else {
                collection.removeXMLResource(txn, broker, resource.getFileURI());
            }
            txnManager.commit(txn);
            if (!LOG.isDebugEnabled()) return;
            LOG.debug("Document deleted sucessfully");
            return;
        }
        catch (LockException e) {
            LOG.error("Resource is locked.", (Throwable)e);
            return;
        }
        catch (IOException | EXistException | TriggerException | PermissionDeniedException e) {
            LOG.error((Object)e);
            return;
        }
        finally {
            if (collection != null) {
                collection.release(Lock.LockMode.WRITE_LOCK);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Finished delete");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public LockToken getCurrentLock() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Get current lock " + this.xmldbUri);
        }
        DocumentImpl document = null;
        try {
            LockToken lockToken;
            Throwable throwable;
            DBBroker broker;
            block44: {
                block45: {
                    LockToken token;
                    block41: {
                        LockToken lockToken2;
                        block42: {
                            block43: {
                                block38: {
                                    LockToken lockToken3;
                                    block39: {
                                        block40: {
                                            block35: {
                                                LockToken lockToken4;
                                                block36: {
                                                    block37: {
                                                        broker = this.brokerPool.get(Optional.ofNullable(this.subject));
                                                        throwable = null;
                                                        document = broker.getXMLResource(this.xmldbUri, Lock.LockMode.READ_LOCK);
                                                        if (document != null) break block35;
                                                        LOG.debug("No resource found for path: " + this.xmldbUri);
                                                        lockToken4 = null;
                                                        if (broker == null) break block36;
                                                        if (throwable == null) break block37;
                                                        try {
                                                            broker.close();
                                                        }
                                                        catch (Throwable throwable2) {
                                                            throwable.addSuppressed(throwable2);
                                                        }
                                                        break block36;
                                                    }
                                                    broker.close();
                                                }
                                                return lockToken4;
                                            }
                                            Account lock = document.getUserLock();
                                            if (lock != null) break block38;
                                            if (LOG.isDebugEnabled()) {
                                                LOG.debug("Document " + this.xmldbUri + " does not contain userlock");
                                            }
                                            lockToken3 = null;
                                            if (broker == null) break block39;
                                            if (throwable == null) break block40;
                                            try {
                                                broker.close();
                                            }
                                            catch (Throwable throwable3) {
                                                throwable.addSuppressed(throwable3);
                                            }
                                            break block39;
                                        }
                                        broker.close();
                                    }
                                    return lockToken3;
                                }
                                token = document.getMetadata().getLockToken();
                                if (token != null) break block41;
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug("Document meta data does not contain a LockToken");
                                }
                                lockToken2 = null;
                                if (broker == null) break block42;
                                if (throwable == null) break block43;
                                try {
                                    broker.close();
                                }
                                catch (Throwable throwable4) {
                                    throwable.addSuppressed(throwable4);
                                }
                                break block42;
                            }
                            broker.close();
                        }
                        return lockToken2;
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Successfully retrieved token");
                    }
                    lockToken = token;
                    if (broker == null) break block44;
                    if (throwable == null) break block45;
                    try {
                        broker.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    break block44;
                }
                broker.close();
            }
            return lockToken;
            catch (Throwable throwable6) {
                try {
                    try {
                        throwable = throwable6;
                        throw throwable6;
                    }
                    catch (Throwable throwable7) {
                        if (broker != null) {
                            if (throwable != null) {
                                try {
                                    broker.close();
                                }
                                catch (Throwable throwable8) {
                                    throwable.addSuppressed(throwable8);
                                }
                            } else {
                                broker.close();
                            }
                        }
                        throw throwable7;
                    }
                }
                catch (EXistException | PermissionDeniedException e) {
                    LOG.error((Object)e);
                    throwable = null;
                    return throwable;
                }
            }
        }
        finally {
            if (document != null) {
                document.getUpdateLock().release(Lock.LockMode.READ_LOCK);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Finished probe lock");
            }
        }
    }

    /*
     * Exception decompiling
     */
    public LockToken lock(LockToken inputToken) throws PermissionDeniedException, DocumentAlreadyLockedException, EXistException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void unlock() throws PermissionDeniedException, DocumentNotLockedException, EXistException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("unlock " + this.xmldbUri);
        }
        DocumentImpl document = null;
        TransactionManager txnManager = this.brokerPool.getTransactionManager();
        try (DBBroker broker = this.brokerPool.get(Optional.ofNullable(this.subject));
             Txn txn = txnManager.beginTransaction();){
            document = broker.getXMLResource(this.xmldbUri, Lock.LockMode.WRITE_LOCK);
            if (document == null) {
                String msg = String.format("No resource found for path: %s", this.xmldbUri);
                LOG.debug(msg);
                throw new EXistException(msg);
            }
            Account lock = document.getUserLock();
            if (lock == null) {
                LOG.debug(String.format("Resource %s is not locked.", this.xmldbUri));
                throw new DocumentNotLockedException("" + this.xmldbUri);
            }
            if (!lock.getName().equals(this.subject.getName()) && !this.subject.hasDbaRole()) {
                LOG.debug(String.format("Resource lock is from user %s", lock.getName()));
                throw new PermissionDeniedException(lock.getName());
            }
            document.setUserLock(null);
            document.getMetadata().setLockToken(null);
            broker.storeMetadata(txn, document);
            txnManager.commit(txn);
        }
        catch (EXistException | PermissionDeniedException e) {
            LOG.error((Object)e);
            throw e;
        }
        catch (TriggerException e) {
            LOG.error((Object)e);
            throw new EXistException((Throwable)e);
        }
        finally {
            if (document != null) {
                document.getUpdateLock().release(Lock.LockMode.WRITE_LOCK);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Finished create lock");
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void resourceCopyMove(XmldbURI destCollectionUri, String newName, ExistResource.Mode mode) throws EXistException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("%s %s to %s named %s", new Object[]{mode, this.xmldbUri, destCollectionUri, newName}));
        }
        XmldbURI newNameUri = null;
        try {
            newNameUri = XmldbURI.xmldbUriFor((String)newName);
        }
        catch (URISyntaxException ex) {
            LOG.error((Object)ex);
            throw new EXistException(ex.getMessage());
        }
        Collection srcCollection = null;
        Lock.LockMode srcCollectionLockMode = mode == ExistResource.Mode.MOVE || destCollectionUri.equals((Object)this.xmldbUri.removeLastSegment()) ? Lock.LockMode.WRITE_LOCK : Lock.LockMode.READ_LOCK;
        DocumentImpl srcDocument = null;
        Collection destCollection = null;
        TransactionManager txnManager = this.brokerPool.getTransactionManager();
        try (DBBroker broker = this.brokerPool.get(Optional.ofNullable(this.subject));
             Txn txn = txnManager.beginTransaction();){
            XmldbURI srcCollectionUri = this.xmldbUri.removeLastSegment();
            XmldbURI srdDocumentUri = this.xmldbUri.lastSegment();
            srcCollection = broker.openCollection(srcCollectionUri, srcCollectionLockMode);
            if (srcCollection == null) {
                txnManager.abort(txn);
                return;
            }
            srcDocument = srcCollection.getDocument(broker, srdDocumentUri);
            if (srcDocument == null) {
                LOG.debug(String.format("No resource found for path: %s", this.xmldbUri));
                txnManager.abort(txn);
                return;
            }
            destCollection = broker.openCollection(destCollectionUri, Lock.LockMode.WRITE_LOCK);
            if (destCollection == null) {
                LOG.debug(String.format("Destination collection %s does not exist.", this.xmldbUri));
                txnManager.abort(txn);
                return;
            }
            if (mode == ExistResource.Mode.COPY) {
                broker.copyResource(txn, srcDocument, destCollection, newNameUri);
            } else {
                broker.moveResource(txn, srcDocument, destCollection, newNameUri);
            }
            txnManager.commit(txn);
            if (!LOG.isDebugEnabled()) return;
            LOG.debug(String.format("Document %sd successfully", new Object[]{mode}));
            return;
        }
        catch (LockException e) {
            LOG.error("Resource is locked.", (Throwable)e);
            throw new EXistException(e.getMessage());
        }
        catch (EXistException e) {
            LOG.error((Object)e);
            throw e;
        }
        catch (IOException | TriggerException | PermissionDeniedException e) {
            LOG.error((Object)e);
            throw new EXistException(e.getMessage());
        }
        finally {
            if (destCollection != null) {
                destCollection.release(Lock.LockMode.WRITE_LOCK);
            }
            if (srcCollection != null) {
                srcCollection.release(srcCollectionLockMode);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Finished " + (Object)((Object)mode));
            }
        }
    }

    /*
     * Exception decompiling
     */
    public LockToken refreshLock(String token) throws PermissionDeniedException, DocumentAlreadyLockedException, EXistException, DocumentNotLockedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

