/*
 * Decompiled with CFR 0.152.
 */
package org.exist.webdav;

import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.security.AuthenticationException;
import org.exist.security.Permission;
import org.exist.security.SecurityManager;
import org.exist.security.Subject;
import org.exist.storage.BrokerPool;
import org.exist.xmldb.XmldbURI;

public abstract class ExistResource {
    protected static final Logger LOG = LogManager.getLogger(ExistResource.class);
    protected boolean isInitialized = false;
    protected BrokerPool brokerPool;
    protected Subject subject;
    protected XmldbURI xmldbUri;
    protected Permission permissions;
    protected Long creationTime;
    protected Long lastModified;
    protected boolean readAllowed = false;
    protected boolean writeAllowed = false;
    protected boolean executeAllowed = false;
    protected String ownerUser;
    protected String ownerGroup;
    protected Properties configuration = new Properties();

    abstract void initMetadata();

    protected boolean isReadAllowed() {
        return this.readAllowed;
    }

    protected boolean isWriteAllowed() {
        return this.writeAllowed;
    }

    protected boolean isUpdateAllowed() {
        return this.executeAllowed;
    }

    protected Subject getUser() {
        return this.subject;
    }

    protected void setUser(Subject user) {
        this.subject = user;
    }

    protected Long getCreationTime() {
        return this.creationTime;
    }

    protected Long getLastModified() {
        return this.lastModified;
    }

    protected Permission getPermissions() {
        return this.permissions;
    }

    public String getOwnerGroup() {
        return this.ownerGroup;
    }

    public String getOwnerUser() {
        return this.ownerUser;
    }

    public Properties getSerializationConfiguration() {
        return this.configuration;
    }

    public void setSerializationConfiguration(Properties config) {
        this.configuration = config;
    }

    protected Subject authenticate(String username, String password) {
        if (username == null) {
            return null;
        }
        SecurityManager securityManager = this.brokerPool.getSecurityManager();
        try {
            this.subject = securityManager.authenticate(username, (Object)password);
        }
        catch (AuthenticationException e) {
            LOG.info(String.format("User %s could not be authenticated. %s", username, e.getMessage()));
        }
        return this.subject;
    }

    protected static enum Mode {
        MOVE,
        COPY;

    }
}

