/*
 * Decompiled with CFR 0.152.
 */
package org.exist.webdav;

import com.bradmcevoy.http.Resource;
import com.bradmcevoy.http.ResourceFactory;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.EXistException;
import org.exist.collections.Collection;
import org.exist.dom.persistent.DocumentImpl;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.storage.lock.Lock;
import org.exist.util.FileUtils;
import org.exist.webdav.MiltonCollection;
import org.exist.webdav.MiltonDocument;
import org.exist.xmldb.XmldbURI;

public class ExistResourceFactory
implements ResourceFactory {
    private static final Logger LOG = LogManager.getLogger(ExistResourceFactory.class);
    private BrokerPool brokerPool;
    private Properties webDavOptions;

    public ExistResourceFactory() {
        block17: {
            this.brokerPool = null;
            this.webDavOptions = new Properties();
            try {
                this.brokerPool = BrokerPool.getInstance();
            }
            catch (EXistException e) {
                LOG.error("Unable to initialize WebDAV interface.", (Throwable)e);
            }
            try {
                Optional eXistHome = this.brokerPool.getConfiguration().getExistHome();
                Path config = FileUtils.resolve((Optional)eXistHome, (String)"webdav.properties");
                if (Files.isReadable(config)) {
                    LOG.info(String.format("Read WebDAV configuration from %s", config.toAbsolutePath().toString()));
                    try (InputStream is = Files.newInputStream(config, new OpenOption[0]);){
                        this.webDavOptions.load(is);
                        break block17;
                    }
                }
                LOG.info("Using eXist-db default serialization options.");
            }
            catch (Throwable ex) {
                LOG.error(ex.getMessage());
            }
        }
    }

    public Resource getResource(String host, String path) {
        if (!path.contains("/db")) {
            LOG.error("path should at least contain /db");
            return null;
        }
        XmldbURI xmldbUri = null;
        try {
            path = path.substring(path.indexOf("/db"));
            if (path.endsWith("/")) {
                path = path.substring(0, path.lastIndexOf("/"));
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("host='%s' path='%s'", host, path));
            }
            xmldbUri = XmldbURI.xmldbUriFor((String)path);
        }
        catch (URISyntaxException e) {
            LOG.error(String.format("Unable to convert path '%s'into a XmldbURI representation.", path));
            return null;
        }
        switch (this.getResourceType(this.brokerPool, xmldbUri)) {
            case DOCUMENT: {
                MiltonDocument doc = new MiltonDocument(host, xmldbUri, this.brokerPool);
                doc.setSerializationConfiguration(this.webDavOptions);
                return doc;
            }
            case COLLECTION: {
                return new MiltonCollection(host, xmldbUri, this.brokerPool);
            }
            case IGNORABLE: {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("ignoring file");
                }
                return null;
            }
            case NOT_EXISTING: {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(String.format("Resource does not exist: '%s'", xmldbUri));
                }
                return null;
            }
        }
        LOG.error(String.format("Unkown resource type for %s", xmldbUri));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceType getResourceType(BrokerPool brokerPool, XmldbURI xmldbUri) {
        Collection collection = null;
        DocumentImpl document = null;
        ResourceType type = ResourceType.NOT_EXISTING;
        String documentSeqment = xmldbUri.lastSegment().toString();
        if (documentSeqment.startsWith("._") || documentSeqment.equals(".DS_Store")) {
            // empty if block
        }
        if (documentSeqment.startsWith(".")) {
            // empty if block
        }
        try (DBBroker broker = brokerPool.get(Optional.of(brokerPool.getSecurityManager().getSystemSubject()));){
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Path: %s", xmldbUri.toString()));
            }
            if ((collection = broker.openCollection(xmldbUri, Lock.LockMode.READ_LOCK)) != null) {
                type = ResourceType.COLLECTION;
                collection.release(Lock.LockMode.READ_LOCK);
                collection = null;
            } else {
                document = broker.getXMLResource(xmldbUri, Lock.LockMode.READ_LOCK);
                if (document != null) {
                    type = ResourceType.DOCUMENT;
                    document.getUpdateLock().release(Lock.LockMode.READ_LOCK);
                    document = null;
                } else {
                    type = ResourceType.NOT_EXISTING;
                }
            }
        }
        catch (Exception ex) {
            LOG.error(String.format("Error determining nature of resource %s", xmldbUri.toString()), (Throwable)ex);
            type = ResourceType.NOT_EXISTING;
        }
        finally {
            if (collection != null) {
                collection.release(Lock.LockMode.READ_LOCK);
            }
            if (document != null) {
                document.getUpdateLock().release(Lock.LockMode.READ_LOCK);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Resource type=%s", type.toString()));
        }
        return type;
    }

    private static enum ResourceType {
        DOCUMENT,
        COLLECTION,
        IGNORABLE,
        NOT_EXISTING;

    }
}

