/*
 * Decompiled with CFR 0.152.
 */
package org.exist.webdav;

import com.bradmcevoy.http.Auth;
import com.bradmcevoy.http.LockInfo;
import com.bradmcevoy.http.LockTimeout;
import com.bradmcevoy.http.LockToken;
import com.bradmcevoy.http.Request;
import com.bradmcevoy.http.Resource;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.exist.security.Subject;
import org.exist.storage.BrokerPool;
import org.exist.webdav.ExistResource;
import org.exist.xmldb.XmldbURI;

public class MiltonResource
implements Resource {
    protected static final Logger LOG = LogManager.getLogger(MiltonResource.class);
    protected static final String AUTHENTICATED = "AUTHENTICATED";
    protected XmldbURI resourceXmldbUri;
    protected BrokerPool brokerPool;
    protected String host;
    protected Subject subject;
    protected String REALM = "exist";
    protected ExistResource existResource;
    private DatatypeFactory datatypeFactory;

    public MiltonResource() {
        if (this.datatypeFactory == null) {
            try {
                this.datatypeFactory = DatatypeFactory.newInstance();
            }
            catch (DatatypeConfigurationException ex) {
                LOG.error((Object)ex);
            }
        }
    }

    protected XmldbURI getXmldbUri() {
        return this.resourceXmldbUri;
    }

    protected String getHost() {
        return this.host;
    }

    private Subject getUserAsSubject() {
        return this.subject;
    }

    protected String getXmlDateTime(Long date) {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(new Date(date));
        XMLGregorianCalendar xgc = this.datatypeFactory.newXMLGregorianCalendar(gc);
        return xgc.toXMLFormat();
    }

    protected LockToken convertToken(org.exist.dom.persistent.LockToken existLT) {
        LockInfo.LockScope scope = null;
        switch (existLT.getScope()) {
            case 2: {
                scope = LockInfo.LockScope.SHARED;
                break;
            }
            case 1: {
                scope = LockInfo.LockScope.EXCLUSIVE;
                break;
            }
            default: {
                scope = LockInfo.LockScope.NONE;
            }
        }
        LockInfo.LockType type = null;
        switch (existLT.getType()) {
            case 1: {
                type = LockInfo.LockType.WRITE;
                break;
            }
            default: {
                type = LockInfo.LockType.READ;
            }
        }
        String owner = existLT.getOwner();
        LockInfo.LockDepth depth = null;
        switch (existLT.getDepth()) {
            case 2: {
                depth = LockInfo.LockDepth.INFINITY;
                break;
            }
            default: {
                depth = LockInfo.LockDepth.ZERO;
            }
        }
        LockInfo li = new LockInfo(scope, type, owner, depth);
        Long timeout = existLT.getTimeOut();
        if (timeout == -2L) {
            timeout = null;
        } else if (timeout == -1L) {
            timeout = Long.MAX_VALUE;
        }
        LockTimeout lt = new LockTimeout(timeout);
        String id = existLT.getOpaqueLockToken();
        return new LockToken(id, li, lt);
    }

    protected org.exist.dom.persistent.LockToken convertToken(LockTimeout timeout, LockInfo lockInfo) {
        org.exist.dom.persistent.LockToken existToken = new org.exist.dom.persistent.LockToken();
        switch (lockInfo.depth) {
            case ZERO: {
                existToken.setDepth((byte)0);
                break;
            }
            case INFINITY: {
                existToken.setDepth((byte)2);
            }
        }
        switch (lockInfo.scope) {
            case EXCLUSIVE: {
                existToken.setScope((byte)1);
                break;
            }
            case SHARED: {
                existToken.setScope((byte)2);
                break;
            }
            case NONE: {
                existToken.setScope((byte)0);
            }
        }
        switch (lockInfo.type) {
            case READ: {
                existToken.setScope((byte)0);
                break;
            }
            case WRITE: {
                existToken.setScope((byte)1);
            }
        }
        if (timeout == null || timeout.getSeconds() == null) {
            existToken.setTimeOut(-2L);
        } else if (timeout.getSeconds() == Long.MAX_VALUE) {
            existToken.setTimeOut(-1L);
        } else {
            Long futureDate = new Date().getTime() / 1000L + timeout.getSeconds();
            existToken.setTimeOut(futureDate.longValue());
        }
        String user = lockInfo.lockedByUser;
        if (user != null) {
            existToken.setOwner(user);
        }
        return existToken;
    }

    protected XmldbURI decodePath(XmldbURI uri) {
        XmldbURI retval = null;
        try {
            String path = new URI(uri.toString()).getPath();
            retval = XmldbURI.xmldbUriFor((String)("" + path), (boolean)false);
        }
        catch (URISyntaxException ex) {
            LOG.error(ex.getMessage());
        }
        return retval;
    }

    protected String decodePath(String uri) {
        String path = null;
        try {
            path = new URI(uri).getPath();
        }
        catch (URISyntaxException ex) {
            LOG.error(ex.getMessage());
        }
        return path;
    }

    public String getUniqueId() {
        return null;
    }

    public String getName() {
        return this.decodePath("" + this.resourceXmldbUri.lastSegment());
    }

    public Object authenticate(String username, String password) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("Authenticating user %s for %s", username, this.resourceXmldbUri));
        }
        if (username == null) {
            return null;
        }
        if (this.subject != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("User was already authenticated.");
            }
            return AUTHENTICATED;
        }
        this.subject = this.existResource.authenticate(username, password);
        if (this.subject == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("User could not be authenticated.");
            }
            return null;
        }
        Subject guest = this.brokerPool.getSecurityManager().getGuestSubject();
        if (guest.equals(this.subject)) {
            LOG.error(String.format("The user %s is prohibited from logging in through WebDAV.", guest.getName()));
            return null;
        }
        this.existResource.initMetadata();
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("User '%s' has been authenticated.", this.subject.getName()));
        }
        return AUTHENTICATED;
    }

    public boolean authorise(Request request, Request.Method method, Auth auth) {
        String action;
        String value;
        LOG.info(String.format("%s %s (write=%s)", method.toString(), this.resourceXmldbUri, method.isWrite));
        if (auth == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("User hasn't been authenticated.");
            }
            return false;
        }
        String userName = auth.getUser();
        Object tag = auth.getTag();
        String authURI = auth.getUri();
        if (tag == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("No tag, user %s not authenticated", userName));
            }
            return false;
        }
        if (tag instanceof String && !AUTHENTICATED.equals(value = (String)tag)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("Authentication tag contains wrong value, user %s is not authenticated", userName));
            }
            return false;
        }
        if (method.isWrite) {
            if (!this.existResource.writeAllowed) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(String.format("User %s is NOT authorized to write resource, abort.", userName));
                }
                return false;
            }
        } else if (!this.existResource.readAllowed) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(String.format("User %s is NOT authorized to read resource, abort.", userName));
            }
            return false;
        }
        if (auth.getUri() == null && LOG.isTraceEnabled()) {
            LOG.trace("URI is null");
        }
        String string = action = method.isWrite ? "write" : "read";
        if (LOG.isDebugEnabled()) {
            LOG.debug(String.format("User %s is authorized to %s resource %s", userName, action, this.resourceXmldbUri.toString()));
        }
        return true;
    }

    public String getRealm() {
        return this.REALM;
    }

    public Date getModifiedDate() {
        Date modifiedDate = null;
        Long time = this.existResource.getLastModified();
        if (time != null) {
            modifiedDate = new Date(time);
        }
        return modifiedDate;
    }

    public String checkRedirect(Request request) {
        return null;
    }
}

