/*
 * Decompiled with CFR 0.152.
 */
package org.exist.webdav;

import com.bradmcevoy.http.MiltonServlet;
import com.bradmcevoy.http.http11.DefaultHttp11ResponseHandler;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MiltonWebDAVServlet
extends MiltonServlet {
    protected static final Logger LOG = LogManager.getLogger(MiltonWebDAVServlet.class);
    public static String POM_PROP = "/META-INF/maven/com.ettrema/milton-api/pom.properties";

    public void init(ServletConfig config) throws ServletException {
        LOG.info("Initializing webdav servlet");
        Properties props = new Properties();
        try {
            InputStream is = DefaultHttp11ResponseHandler.class.getResourceAsStream(POM_PROP);
            if (is == null) {
                LOG.error("Could not read the file milton.properties");
            } else {
                props.load(is);
            }
        }
        catch (IOException ex) {
            LOG.warn("Failed to load milton properties file", (Throwable)ex);
        }
        String miltonVersion = props.getProperty("version");
        if (miltonVersion == null) {
            LOG.error("Unable to determine Milton version");
        } else {
            LOG.info("Detected Milton WebDAV Server library version: " + miltonVersion);
        }
        super.init(config);
        String enableInitParameter = config.getInitParameter("enable.expect.continue");
        if (enableInitParameter == null) {
            enableInitParameter = "FALSE";
        }
        boolean enableExpectContinue = "TRUE".equalsIgnoreCase(enableInitParameter);
        this.httpManager.setEnableExpectContinue(enableExpectContinue);
        LOG.debug(String.format("Set 'Enable Expect Continue' to %s", enableExpectContinue));
    }
}

