/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.xUnit;

import java.util.Iterator;
import java.util.Optional;
import org.exist.Database;
import org.exist.source.ClassLoaderSource;
import org.exist.source.Source;
import org.exist.storage.BrokerPool;
import org.exist.storage.DBBroker;
import org.exist.xmldb.DatabaseInstanceManager;
import org.exist.xquery.Annotation;
import org.exist.xquery.CompiledXQuery;
import org.exist.xquery.ContextItemDeclaration;
import org.exist.xquery.FunctionCall;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.UserDefinedFunction;
import org.exist.xquery.XQuery;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Sequence;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.xmldb.api.DatabaseManager;
import org.xmldb.api.base.Collection;

public class xUnit {
    Collection rootCollection;

    public void test(String source) {
        try {
            BrokerPool db = BrokerPool.getInstance();
            try (DBBroker broker = db.get(Optional.of(db.getSecurityManager().getGuestSubject()));){
                XQuery xquery = broker.getBrokerPool().getXQueryService();
                XQueryContext context = new XQueryContext((Database)broker.getBrokerPool());
                ClassLoaderSource query = new ClassLoaderSource(source);
                CompiledXQuery compiledQuery = xquery.compile(broker, context, (Source)query);
                Iterator i = context.localFunctions();
                while (i.hasNext()) {
                    UserDefinedFunction func = (UserDefinedFunction)i.next();
                    FunctionSignature sig = func.getSignature();
                    for (Annotation ann : sig.getAnnotations()) {
                        if (!"http://exist-db.org/xquery/xUnit".equals(ann.getName().getNamespaceURI())) continue;
                        FunctionCall call = new FunctionCall(context, func);
                        ContextItemDeclaration cid = context.getContextItemDeclartion();
                        Sequence contextSequence = cid != null ? cid.eval(null) : Sequence.EMPTY_SEQUENCE;
                        call.eval(contextSequence);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)e.getMessage());
        }
    }

    @Before
    public void setUpBefore() throws Exception {
        Class<?> cl = Class.forName("org.exist.xmldb.DatabaseImpl");
        org.xmldb.api.base.Database database = (org.xmldb.api.base.Database)cl.newInstance();
        database.setProperty("create-database", "true");
        DatabaseManager.registerDatabase((org.xmldb.api.base.Database)database);
        this.rootCollection = DatabaseManager.getCollection((String)"xmldb:exist:///db", (String)"admin", (String)"");
    }

    @After
    public void tearDownAfter() {
        if (this.rootCollection != null) {
            try {
                DatabaseInstanceManager dim = (DatabaseInstanceManager)this.rootCollection.getService("DatabaseInstanceManager", "1.0");
                dim.shutdown();
            }
            catch (Exception e) {
                e.printStackTrace();
                Assert.fail((String)e.getMessage());
            }
        }
        this.rootCollection = null;
    }

    public static void main(String[] args) throws Exception {
        xUnit tester = new xUnit();
        tester.setUpBefore();
        try {
            tester.test("resource:org/exist/xquery/xUnit/test.xql");
        }
        finally {
            tester.tearDownAfter();
        }
    }
}

