/*
 * Decompiled with CFR 0.152.
 */
package org.exist.start;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.exist.start.Classpath;
import org.exist.start.EXistClassLoader;
import org.exist.start.LatestFileResolver;
import org.exist.start.Version;

public class Main {
    private static final String START_CONFIG = "start.config";
    public static final String STANDARD_ENABLED_JETTY_CONFIGS = "standard.enabled-jetty-configs";
    public static final String STANDALONE_ENABLED_JETTY_CONFIGS = "standalone.enabled-jetty-configs";
    private String _classname = null;
    private String _mode = "jetty";
    private static Main exist;
    private boolean _debug = Boolean.getBoolean("exist.start.debug");
    private String startConfigFileName = "";
    private final LatestFileResolver jarFileResolver = new LatestFileResolver();

    public static void main(String[] args) {
        try {
            Main.getMain().run(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Main getMain() {
        if (exist == null) {
            exist = new Main();
        }
        return exist;
    }

    public String getMode() {
        return this._mode;
    }

    private Main() {
    }

    public Main(String mode) {
        this._mode = mode;
    }

    static Path getDirectory(String name) {
        try {
            Path dir;
            if (name != null && Files.isDirectory(dir = Paths.get(name, new String[0]).normalize().toAbsolutePath(), new LinkOption[0])) {
                return dir;
            }
        }
        catch (InvalidPathException invalidPathException) {
            // empty catch block
        }
        return null;
    }

    boolean isAvailable(String classname, Classpath classpath) {
        try {
            Class.forName(classname);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            EXistClassLoader loader = classpath.getClassLoader(null);
            try {
                loader.loadClass(classname);
                return true;
            }
            catch (ClassNotFoundException classNotFoundException2) {
                return false;
            }
        }
    }

    public static void invokeMain(ClassLoader classloader, String classname, String[] args) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException {
        Class<?> invoked_class = classloader.loadClass(classname);
        Class[] method_param_types = new Class[]{args.getClass()};
        Method main = invoked_class.getDeclaredMethod("main", method_param_types);
        Object[] method_params = new Object[]{args};
        main.invoke(null, method_params);
    }

    void configureClasspath(Path home, Classpath classpath, InputStream config, String[] args, String mode) {
        ArrayList<Path> invalidJars = new ArrayList<Path>();
        try (BufferedReader cfg = new BufferedReader(new InputStreamReader(config, StandardCharsets.UTF_8));){
            String line;
            Version java_version = new Version(System.getProperty("java.version"));
            Version ver = new Version();
            HashSet<Path> done = new HashSet<Path>();
            while ((line = cfg.readLine()) != null) {
                try {
                    Path d;
                    String file;
                    if (line.length() <= 0 || line.startsWith("#")) continue;
                    if (this._debug) {
                        System.err.println(">" + line);
                    }
                    StringTokenizer st = new StringTokenizer(line);
                    String subject = st.nextToken();
                    boolean include_subject = true;
                    String condition = null;
                    while (include_subject && st.hasMoreTokens()) {
                        String operator;
                        String class_to_check;
                        condition = st.nextToken();
                        if ("never".equals(condition)) {
                            include_subject = false;
                            continue;
                        }
                        if ("always".equals(condition)) continue;
                        if ("available".equals(condition)) {
                            class_to_check = st.nextToken();
                            include_subject &= this.isAvailable(class_to_check, classpath);
                            continue;
                        }
                        if ("!available".equals(condition)) {
                            class_to_check = st.nextToken();
                            include_subject &= !this.isAvailable(class_to_check, classpath);
                            continue;
                        }
                        if ("java".equals(condition)) {
                            operator = st.nextToken();
                            String version = st.nextToken();
                            ver.parse(version);
                            include_subject &= "<".equals(operator) && java_version.compare(ver) < 0 || ">".equals(operator) && java_version.compare(ver) > 0 || "<=".equals(operator) && java_version.compare(ver) <= 0 || "=<".equals(operator) && java_version.compare(ver) <= 0 || "=>".equals(operator) && java_version.compare(ver) >= 0 || ">=".equals(operator) && java_version.compare(ver) >= 0 || "==".equals(operator) && java_version.compare(ver) == 0 || "!=".equals(operator) && java_version.compare(ver) != 0;
                            continue;
                        }
                        if ("nargs".equals(condition)) {
                            operator = st.nextToken();
                            int number = Integer.parseInt(st.nextToken());
                            include_subject &= "<".equals(operator) && args.length < number || ">".equals(operator) && args.length > number || "<=".equals(operator) && args.length <= number || "=<".equals(operator) && args.length <= number || "=>".equals(operator) && args.length >= number || ">=".equals(operator) && args.length >= number || "==".equals(operator) && args.length == number || "!=".equals(operator) && args.length != number;
                            continue;
                        }
                        if ("mode".equals(condition)) {
                            operator = st.nextToken();
                            String m = st.nextToken();
                            include_subject &= "==".equals(operator) && mode.equals(m) || "!=".equals(operator) && !mode.equals(m);
                            continue;
                        }
                        System.err.println("ERROR: Unknown condition: " + condition);
                    }
                    String string = file = subject.startsWith("/") ? subject.replace('/', File.separatorChar) : home.toAbsolutePath().toString() + File.separatorChar + subject.replace('/', File.separatorChar);
                    if (this._debug) {
                        System.err.println("subject=" + subject + " file=" + file + " condition=" + condition + " include_subject=" + include_subject);
                    }
                    if (subject.endsWith("/*")) {
                        Path extdir = Paths.get(file.substring(0, file.length() - 1), new String[0]);
                        List<Path> jars = Main.list(extdir, p -> Main.fileName(p).toLowerCase().endsWith(".jar") || Main.fileName(p).toLowerCase().endsWith(".zip"));
                        if (jars == null) continue;
                        for (Path jarFile : jars) {
                            Path canonicalPath = jarFile.toAbsolutePath();
                            if (done.contains(canonicalPath) || !include_subject) continue;
                            done.add(canonicalPath);
                            if (!classpath.addComponent(canonicalPath) || !this._debug) continue;
                            System.err.println("Adding JAR from directory: " + canonicalPath);
                        }
                        continue;
                    }
                    if (subject.endsWith("/")) {
                        Path p2 = Paths.get(file, new String[0]).toAbsolutePath();
                        if (done.contains(p2)) continue;
                        done.add(p2);
                        if (!include_subject || !classpath.addComponent(p2) || !this._debug) continue;
                        System.err.println("Adding directory: " + p2);
                        continue;
                    }
                    if (subject.toLowerCase().endsWith(".class")) {
                        this._classname = subject.substring(0, subject.length() - 6);
                        continue;
                    }
                    String resolvedFile = this.jarFileResolver.getResolvedFileName(file);
                    Path f = Paths.get(resolvedFile, new String[0]);
                    if (include_subject && !Files.exists(f, new LinkOption[0])) {
                        invalidJars.add(f.toAbsolutePath());
                    }
                    if (done.contains(d = f.toAbsolutePath()) || !include_subject) continue;
                    done.add(d);
                    if (!classpath.addComponent(d) || !this._debug) continue;
                    System.err.println("Adding single JAR: " + d);
                }
                catch (Exception e) {
                    if (!this._debug) continue;
                    System.err.println(line);
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void run(String[] args) {
        Path _home_dir;
        if (args.length > 0) {
            if ("client".equals(args[0])) {
                this._classname = "org.exist.client.InteractiveClient";
                this._mode = "client";
            } else if ("backup".equals(args[0])) {
                this._classname = "org.exist.backup.Main";
                this._mode = "backup";
            } else if ("jetty".equals(args[0]) || "standalone".equals(args[0])) {
                this._classname = "org.exist.jetty.JettyStart";
                this._mode = args[0];
            } else if ("launch".equals(args[0])) {
                this._classname = "org.exist.launcher.LauncherWrapper";
                this._mode = "jetty";
            } else if ("shutdown".equals(args[0])) {
                this._classname = "org.exist.jetty.ServerShutdown";
                this._mode = "other";
            } else {
                this._classname = args[0];
                this._mode = "other";
            }
            String[] nargs = new String[args.length - 1];
            if (args.length > 1) {
                System.arraycopy(args, 1, nargs, 0, args.length - 1);
            }
            args = nargs;
        } else {
            this._classname = "org.exist.launcher.LauncherWrapper";
            this._mode = "other";
        }
        if (this._debug) {
            System.err.println("mode = " + this._mode);
        }
        if ((_home_dir = this.detectHome()) != null) {
            Path log4j;
            if (this._debug) {
                System.err.println("EXIST_HOME=" + System.getProperty("exist.home"));
            }
            System.setProperty("exist.home", _home_dir.toString());
            System.setProperty("user.dir", _home_dir.toString());
            if ("jetty".equals(this._mode) || "standalone".equals(this._mode)) {
                if (System.getProperty("jetty.home") == null) {
                    Path _tools_dir = _home_dir.resolve("tools");
                    if (!Files.exists(_tools_dir, new LinkOption[0])) {
                        System.err.println("ERROR: tools directory not found in " + _home_dir.toAbsolutePath());
                        return;
                    }
                    try {
                        List<Path> _dirs = Main.list(_tools_dir, p -> Files.isDirectory(p, new LinkOption[0]) && Main.fileName(p).startsWith("jetty"));
                        if (_dirs.size() <= 0) {
                            System.err.println("ERROR: Jetty could not be found in " + _tools_dir.toAbsolutePath());
                            return;
                        }
                        System.setProperty("jetty.home", _dirs.get(0).toAbsolutePath().toString());
                    }
                    catch (IOException e) {
                        System.err.println("ERROR: Jetty could not be found in " + _tools_dir.toAbsolutePath());
                        e.printStackTrace();
                        return;
                    }
                }
                String config = "jetty".equals(this._mode) ? STANDARD_ENABLED_JETTY_CONFIGS : STANDALONE_ENABLED_JETTY_CONFIGS;
                args = new String[]{System.getProperty("jetty.home") + File.separatorChar + "etc" + File.separatorChar + config};
            }
            if (Files.isReadable(log4j = Optional.ofNullable(System.getProperty("log4j.configurationFile")).map(x$0 -> Paths.get(x$0, new String[0])).orElseGet(() -> _home_dir.resolve("log4j2.xml")))) {
                System.setProperty("log4j.configurationFile", log4j.toUri().toASCIIString());
            }
            System.setProperty("java.util.logging.manager", Optional.ofNullable(System.getProperty("java.util.logging.manager")).orElse("org.apache.logging.log4j.jul.LogManager"));
            try {
                Path tmpdir = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]).toAbsolutePath();
                if (Files.isDirectory(tmpdir, new LinkOption[0])) {
                    System.setProperty("java.io.tmpdir", tmpdir.toString());
                }
            }
            catch (InvalidPathException tmpdir) {
                // empty catch block
            }
            Classpath _classpath = this.constructClasspath(_home_dir, args);
            EXistClassLoader cl = _classpath.getClassLoader(null);
            Thread.currentThread().setContextClassLoader(cl);
            if (this._debug) {
                System.err.println("TEMPDIR=" + System.getProperty("java.io.tmpdir"));
            }
            try {
                Main.invokeMain(cl, this._classname, args);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            System.err.println("ERROR: exist.home could not be autodetected, bailing out.");
            System.err.flush();
        }
    }

    public Path detectHome() {
        Path jar;
        Path _home_dir = Main.getDirectory(System.getProperty("exist.home"));
        if (_home_dir == null) {
            Path jar2;
            Path webinf = Paths.get("WEB-INF", new String[0]);
            if (this._debug) {
                System.err.println("trying " + webinf.toAbsolutePath());
            }
            if (Files.exists(webinf, new LinkOption[0]) && Files.exists(jar2 = webinf.resolve("lib").resolve("exist.jar"), new LinkOption[0])) {
                try {
                    _home_dir = webinf.toAbsolutePath();
                }
                catch (InvalidPathException invalidPathException) {
                    // empty catch block
                }
            }
        }
        if (_home_dir == null) {
            jar = Paths.get("exist.jar", new String[0]);
            if (this._debug) {
                System.err.println("trying " + jar.toAbsolutePath());
            }
            if (Files.isReadable(jar)) {
                try {
                    _home_dir = Paths.get(".", new String[0]).normalize().toAbsolutePath();
                }
                catch (InvalidPathException invalidPathException) {
                    // empty catch block
                }
            }
        }
        if (_home_dir == null) {
            jar = Paths.get("..", new String[0]).resolve("exist.jar").normalize();
            if (this._debug) {
                System.err.println("trying " + jar.toAbsolutePath());
            }
            if (Files.exists(jar, new LinkOption[0])) {
                try {
                    _home_dir = jar.getParent().toAbsolutePath();
                }
                catch (InvalidPathException invalidPathException) {
                    // empty catch block
                }
            }
        }
        if (_home_dir == null) {
            jar = Paths.get("conf.xml", new String[0]);
            if (this._debug) {
                System.err.println("trying " + jar.toAbsolutePath());
            }
            if (Files.isReadable(jar)) {
                try {
                    _home_dir = Paths.get(".", new String[0]).toAbsolutePath();
                }
                catch (InvalidPathException invalidPathException) {
                    // empty catch block
                }
            }
        }
        if (_home_dir == null) {
            jar = Paths.get("..", new String[0]).resolve("conf.xml").normalize();
            if (this._debug) {
                System.err.println("trying " + jar.toAbsolutePath());
            }
            if (Files.exists(jar, new LinkOption[0])) {
                try {
                    _home_dir = jar.getParent().toAbsolutePath();
                }
                catch (InvalidPathException invalidPathException) {
                    // empty catch block
                }
            }
        }
        return _home_dir;
    }

    public Classpath constructClasspath(Path homeDir, String[] args) {
        Classpath _classpath;
        block39: {
            _classpath = new Classpath();
            if (this._debug) {
                System.out.println("existing classpath = " + System.getProperty("java.class.path"));
            }
            _classpath.addClasspath(System.getProperty("java.class.path"));
            try {
                BiConsumer<String, InputStream> configureClasspath = (path, is) -> {
                    if (this._debug) {
                        System.err.println("Configuring classpath from: " + path);
                    }
                    this.configureClasspath(homeDir, _classpath, (InputStream)is, args, this._mode);
                };
                Path configFilePath1 = homeDir.resolve(START_CONFIG);
                if (Files.exists(configFilePath1, new LinkOption[0])) {
                    try (InputStream cpcfg = Files.newInputStream(configFilePath1, new OpenOption[0]);){
                        String cfgPath = configFilePath1.toAbsolutePath().toString();
                        configureClasspath.accept(cfgPath, cpcfg);
                        this.startConfigFileName = cfgPath;
                        break block39;
                    }
                }
                if (this._debug) {
                    System.err.println("Configuring classpath from default resource");
                }
                String configFilePath2 = "org/exist/start/start.config";
                URL configFilePath2Url = this.getClass().getClassLoader().getResource("org/exist/start/start.config");
                if (configFilePath2Url != null) {
                    try (InputStream cpcfg = this.getClass().getClassLoader().getResourceAsStream("org/exist/start/start.config");){
                        configureClasspath.accept("org/exist/start/start.config", cpcfg);
                        this.startConfigFileName = "org/exist/start/start.config";
                        break block39;
                    }
                }
                throw new RuntimeException("start.config not found at " + configFilePath1 + " or " + "org/exist/start/start.config" + ", Bailing out.");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        String java_home = System.getProperty("java.home");
        if (java_home != null) {
            Path jdk_home = null;
            try {
                jdk_home = Paths.get(java_home, new String[0]).getParent().toAbsolutePath();
            }
            catch (InvalidPathException configFilePath2) {
                // empty catch block
            }
            if (jdk_home != null) {
                Path tools_jar_file = null;
                try {
                    tools_jar_file = jdk_home.resolve("lib").resolve("tools.jar").toAbsolutePath();
                }
                catch (InvalidPathException invalidPathException) {
                    // empty catch block
                }
                if (tools_jar_file != null && Files.isRegularFile(tools_jar_file, new LinkOption[0])) {
                    _classpath.addComponent(tools_jar_file);
                    if (this._debug) {
                        System.err.println("JAVAC = " + tools_jar_file);
                    }
                }
            }
        }
        System.setProperty("java.class.path", _classpath.toString());
        if (this._debug) {
            System.err.println("CLASSPATH=" + _classpath.toString());
        }
        return _classpath;
    }

    public void shutdown() {
        try {
            Class<?> brokerPool = Class.forName("org.exist.storage.BrokerPools");
            Method stopAll = brokerPool.getDeclaredMethod("stopAll", Boolean.TYPE);
            stopAll.setAccessible(true);
            stopAll.invoke(null, false);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    static List<Path> list(Path directory, Predicate<Path> filter) throws IOException {
        try (Stream<Path> entries = Files.list(directory).filter(filter);){
            List<Path> list = entries.collect(Collectors.toList());
            return list;
        }
    }

    static String fileName(Path path) {
        return path.getFileName().toString();
    }
}

