/*
 * Decompiled with CFR 0.152.
 */
package com.github.krukow.clj_lang;

import com.github.krukow.clj_lang.AFn;
import com.github.krukow.clj_lang.ASeq;
import com.github.krukow.clj_lang.Counted;
import com.github.krukow.clj_lang.IFn;
import com.github.krukow.clj_lang.IHashEq;
import com.github.krukow.clj_lang.IMapEntry;
import com.github.krukow.clj_lang.IObj;
import com.github.krukow.clj_lang.IPersistentCollection;
import com.github.krukow.clj_lang.IPersistentMap;
import com.github.krukow.clj_lang.IPersistentStack;
import com.github.krukow.clj_lang.IPersistentVector;
import com.github.krukow.clj_lang.IReduce;
import com.github.krukow.clj_lang.ISeq;
import com.github.krukow.clj_lang.IndexedSeq;
import com.github.krukow.clj_lang.MapEntry;
import com.github.krukow.clj_lang.PersistentVector;
import com.github.krukow.clj_lang.RT;
import com.github.krukow.clj_lang.Sequential;
import com.github.krukow.clj_lang.Util;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.RandomAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class APersistentVector<T>
extends AFn
implements IPersistentVector<T>,
Iterable<T>,
List<T>,
RandomAccess,
Comparable<T>,
Serializable,
IHashEq {
    int _hash = -1;
    int _hasheq = -1;

    public String toString() {
        return RT.printString(this);
    }

    @Override
    public ISeq<T> seq() {
        if (this.count() > 0) {
            return new Seq(this, 0);
        }
        return null;
    }

    @Override
    public ISeq<T> rseq() {
        if (this.count() > 0) {
            return new RSeq(this, this.count() - 1);
        }
        return null;
    }

    static boolean doEquals(IPersistentVector v, Object obj) {
        if (v == obj) {
            return true;
        }
        if (obj instanceof List || obj instanceof IPersistentVector) {
            Collection ma = (Collection)obj;
            if (ma.size() != v.count() || ((Object)ma).hashCode() != v.hashCode()) {
                return false;
            }
            Iterator i1 = ((List)((Object)v)).iterator();
            Iterator i2 = ma.iterator();
            while (i1.hasNext()) {
                if (Util.equals(i1.next(), i2.next())) continue;
                return false;
            }
            return true;
        }
        if (!(obj instanceof Sequential)) {
            return false;
        }
        ISeq ms = RT.seq(obj);
        int i = 0;
        while (i < v.count()) {
            if (ms == null || !Util.equals(v.nth(i), ms.first())) {
                return false;
            }
            ++i;
            ms = ms.next();
        }
        return ms == null;
    }

    static boolean doEquiv(IPersistentVector v, Object obj) {
        if (obj instanceof List || obj instanceof IPersistentVector) {
            Collection ma = (Collection)obj;
            if (ma.size() != v.count()) {
                return false;
            }
            Iterator i1 = ((List)((Object)v)).iterator();
            Iterator i2 = ma.iterator();
            while (i1.hasNext()) {
                if (Util.equiv(i1.next(), i2.next())) continue;
                return false;
            }
            return true;
        }
        if (!(obj instanceof Sequential)) {
            return false;
        }
        ISeq ms = RT.seq(obj);
        int i = 0;
        while (i < v.count()) {
            if (ms == null || !Util.equiv(v.nth(i), ms.first())) {
                return false;
            }
            ++i;
            ms = ms.next();
        }
        return ms == null;
    }

    @Override
    public boolean equals(Object obj) {
        return APersistentVector.doEquals(this, obj);
    }

    @Override
    public boolean equiv(Object obj) {
        return APersistentVector.doEquiv(this, obj);
    }

    @Override
    public int hashCode() {
        if (this._hash == -1) {
            int hash = 1;
            for (T obj : this) {
                hash = 31 * hash + (obj == null ? 0 : obj.hashCode());
            }
            this._hash = hash;
        }
        return this._hash;
    }

    @Override
    public int hasheq() {
        if (this._hasheq == -1) {
            int hash = 1;
            for (T obj : this) {
                hash = 31 * hash + Util.hasheq(obj);
            }
            this._hasheq = hash;
        }
        return this._hasheq;
    }

    @Override
    public T get(int index) {
        return this.nth(index);
    }

    @Override
    public T nth(int i, T notFound) {
        if (i >= 0 && i < this.count()) {
            return this.nth(i);
        }
        return notFound;
    }

    @Override
    public T remove(int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int indexOf(Object o) {
        for (int i = 0; i < this.count(); ++i) {
            if (!Util.equiv(this.nth(i), o)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        for (int i = this.count() - 1; i >= 0; --i) {
            if (!Util.equiv(this.nth(i), o)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<T> listIterator(final int index) {
        return new ListIterator<T>(){
            int nexti;
            {
                this.nexti = index;
            }

            @Override
            public boolean hasNext() {
                return this.nexti < APersistentVector.this.count();
            }

            @Override
            public T next() {
                return APersistentVector.this.nth(this.nexti++);
            }

            @Override
            public boolean hasPrevious() {
                return this.nexti > 0;
            }

            @Override
            public T previous() {
                return APersistentVector.this.nth(--this.nexti);
            }

            @Override
            public int nextIndex() {
                return this.nexti;
            }

            @Override
            public int previousIndex() {
                return this.nexti - 1;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void set(Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void add(Object o) {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        return (List)((Object)RT.subvec(this, fromIndex, toIndex));
    }

    @Override
    public T set(int i, T o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void add(int i, T o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int i, Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object invoke(Object arg1) {
        if (Util.isInteger(arg1)) {
            return this.nth(((Number)arg1).intValue());
        }
        throw new IllegalArgumentException("Key must be integer");
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < APersistentVector.this.count();
            }

            @Override
            public T next() {
                return APersistentVector.this.nth(this.i++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public T peek() {
        if (this.count() > 0) {
            return this.nth(this.count() - 1);
        }
        return null;
    }

    public boolean containsKey(Object key) {
        if (!Util.isInteger(key)) {
            return false;
        }
        int i = ((Number)key).intValue();
        return i >= 0 && i < this.count();
    }

    public IMapEntry<Object, T> entryAt(Object key) {
        int i;
        if (Util.isInteger(key) && (i = ((Number)key).intValue()) >= 0 && i < this.count()) {
            return new MapEntry(key, this.nth(i));
        }
        return null;
    }

    public IPersistentVector<T> assoc(Object key, T val) {
        if (Util.isInteger(key)) {
            int i = ((Number)key).intValue();
            return this.assocN(i, val);
        }
        throw new IllegalArgumentException("Key must be integer");
    }

    public T valAt(Object key, T notFound) {
        int i;
        if (Util.isInteger(key) && (i = ((Number)key).intValue()) >= 0 && i < this.count()) {
            return this.nth(i);
        }
        return notFound;
    }

    public T valAt(Object key) {
        return this.valAt(key, null);
    }

    @Override
    public Object[] toArray() {
        return RT.seqToArray(this.seq());
    }

    @Override
    public boolean add(T o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object[] toArray(Object[] a) {
        return RT.seqToPassedArray(this.seq(), a);
    }

    @Override
    public int size() {
        return this.count();
    }

    @Override
    public boolean isEmpty() {
        return this.count() == 0;
    }

    @Override
    public boolean contains(Object o) {
        for (ISeq<T> s = this.seq(); s != null; s = s.next()) {
            if (!Util.equiv(s.first(), o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int length() {
        return this.count();
    }

    @Override
    public int compareTo(Object o) {
        IPersistentVector v = (IPersistentVector)o;
        if (this.count() < v.count()) {
            return -1;
        }
        if (this.count() > v.count()) {
            return 1;
        }
        for (int i = 0; i < this.count(); ++i) {
            int c = Util.compare(this.nth(i), v.nth(i));
            if (c == 0) continue;
            return c;
        }
        return 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SubVector<T>
    extends APersistentVector<T>
    implements IObj {
        public final IPersistentVector<T> v;
        public final int start;
        public final int end;
        final IPersistentMap _meta;

        public SubVector(IPersistentMap meta, IPersistentVector<T> v, int start, int end) {
            this._meta = meta;
            if (v instanceof SubVector) {
                SubVector sv = (SubVector)v;
                start += sv.start;
                end += sv.start;
                v = sv.v;
            }
            this.v = v;
            this.start = start;
            this.end = end;
        }

        @Override
        public Iterator<T> iterator() {
            return ((PersistentVector)this.v).rangedIterator(this.start, this.end);
        }

        @Override
        public T nth(int i) {
            if (this.start + i >= this.end) {
                throw new IndexOutOfBoundsException();
            }
            return this.v.nth(this.start + i);
        }

        @Override
        public IPersistentVector<T> assocN(int i, T val) {
            if (this.start + i > this.end) {
                throw new IndexOutOfBoundsException();
            }
            if (this.start + i == this.end) {
                return this.cons((Object)val);
            }
            return new SubVector<T>(this._meta, this.v.assocN(this.start + i, val), this.start, this.end);
        }

        @Override
        public int count() {
            return this.end - this.start;
        }

        @Override
        public IPersistentVector<T> cons(T o) {
            return new SubVector<T>(this._meta, this.v.assocN(this.end, o), this.start, this.end + 1);
        }

        @Override
        public IPersistentCollection<T> empty() {
            return PersistentVector.EMPTY.withMeta(this.meta());
        }

        @Override
        public IPersistentStack<T> pop() {
            if (this.end - 1 == this.start) {
                return PersistentVector.EMPTY;
            }
            return new SubVector<T>(this._meta, this.v, this.start, this.end - 1);
        }

        @Override
        public SubVector<T> withMeta(IPersistentMap meta) {
            if (meta == this._meta) {
                return this;
            }
            return new SubVector<T>(meta, this.v, this.start, this.end);
        }

        @Override
        public IPersistentMap meta() {
            return this._meta;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RSeq<T>
    extends ASeq<T>
    implements IndexedSeq<T>,
    Counted {
        final IPersistentVector<T> v;
        final int i;

        public RSeq(IPersistentVector<T> vector, int i) {
            this.v = vector;
            this.i = i;
        }

        RSeq(IPersistentMap meta, IPersistentVector<T> v, int i) {
            super(meta);
            this.v = v;
            this.i = i;
        }

        @Override
        public T first() {
            return this.v.nth(this.i);
        }

        @Override
        public ISeq<T> next() {
            if (this.i > 0) {
                return new RSeq<T>(this.v, this.i - 1);
            }
            return null;
        }

        @Override
        public int index() {
            return this.i;
        }

        @Override
        public int count() {
            return this.i + 1;
        }

        @Override
        public RSeq<T> withMeta(IPersistentMap meta) {
            return new RSeq<T>(meta, this.v, this.i);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Seq<T>
    extends ASeq<T>
    implements IndexedSeq<T>,
    IReduce {
        final IPersistentVector<T> v;
        final int i;

        public Seq(IPersistentVector<T> v, int i) {
            this.v = v;
            this.i = i;
        }

        Seq(IPersistentMap meta, IPersistentVector<T> v, int i) {
            super(meta);
            this.v = v;
            this.i = i;
        }

        @Override
        public T first() {
            return this.v.nth(this.i);
        }

        @Override
        public ISeq<T> next() {
            if (this.i + 1 < this.v.count()) {
                return new Seq<T>(this.v, this.i + 1);
            }
            return null;
        }

        @Override
        public int index() {
            return this.i;
        }

        @Override
        public int count() {
            return this.v.count() - this.i;
        }

        @Override
        public Seq<T> withMeta(IPersistentMap meta) {
            return new Seq<T>(meta, this.v, this.i);
        }

        @Override
        public Object reduce(IFn f) {
            Object ret = this.v.nth(this.i);
            for (int x = this.i + 1; x < this.v.count(); ++x) {
                ret = f.invoke(ret, this.v.nth(x));
            }
            return ret;
        }

        @Override
        public Object reduce(IFn f, Object start) {
            Object ret = f.invoke(start, this.v.nth(this.i));
            for (int x = this.i + 1; x < this.v.count(); ++x) {
                ret = f.invoke(ret, this.v.nth(x));
            }
            return ret;
        }
    }
}

