/*
 * Decompiled with CFR 0.152.
 */
package com.github.krukow.clj_lang;

import com.github.krukow.clj_lang.AFn;
import com.github.krukow.clj_lang.APersistentMap;
import com.github.krukow.clj_lang.ASeq;
import com.github.krukow.clj_lang.IFn;
import com.github.krukow.clj_lang.IMapEntry;
import com.github.krukow.clj_lang.IObj;
import com.github.krukow.clj_lang.IPersistentCollection;
import com.github.krukow.clj_lang.IPersistentMap;
import com.github.krukow.clj_lang.ISeq;
import com.github.krukow.clj_lang.MapEntry;
import com.github.krukow.clj_lang.Obj;
import com.github.krukow.clj_lang.PersistentArrayMap;
import com.github.krukow.clj_lang.PersistentHashMap;
import com.github.krukow.clj_lang.RT;
import com.github.krukow.clj_lang.Util;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentStructMap<K, V>
extends APersistentMap<K, V>
implements IObj {
    final Def def;
    final Object[] vals;
    final IPersistentMap<K, V> ext;
    final IPersistentMap _meta;

    public static Def createSlotMap(ISeq keys) {
        if (keys == null) {
            throw new IllegalArgumentException("Must supply keys");
        }
        int c = RT.count(keys);
        Object[] v = new Object[2 * c];
        int i = 0;
        ISeq s = keys;
        while (s != null) {
            v[2 * i] = s.first();
            v[2 * i + 1] = i;
            s = s.next();
            ++i;
        }
        return new Def(keys, PersistentStructMap.map(v));
    }

    public static <K, V> IPersistentMap<K, V> map(Object ... init) {
        if (init == null) {
            return PersistentArrayMap.EMPTY;
        }
        if (init.length <= 16) {
            return PersistentArrayMap.createWithCheck(init);
        }
        return PersistentHashMap.create(init);
    }

    public static <K, V> PersistentStructMap<K, V> create(Def def, ISeq keyvals) {
        Object[] vals = new Object[def.keyslots.count()];
        IPersistentMap<Object, Object> ext = PersistentHashMap.EMPTY;
        while (keyvals != null) {
            if (keyvals.next() == null) {
                throw new IllegalArgumentException(String.format("No value supplied for key: %s", keyvals.first()));
            }
            Object k = keyvals.first();
            Object v = RT.second(keyvals);
            IMapEntry e = def.keyslots.entryAt(k);
            if (e != null) {
                vals[((Integer)e.getValue()).intValue()] = v;
            } else {
                ext = ext.assoc(k, v);
            }
            keyvals = keyvals.next().next();
        }
        return new PersistentStructMap<K, V>(null, def, vals, ext);
    }

    public static <K, V> PersistentStructMap<K, V> construct(Def def, ISeq<V> valseq) {
        Object[] vals = new Object[def.keyslots.count()];
        PersistentHashMap ext = PersistentHashMap.EMPTY;
        for (int i = 0; i < vals.length && valseq != null; valseq = valseq.next(), ++i) {
            vals[i] = valseq.first();
        }
        if (valseq != null) {
            throw new IllegalArgumentException("Too many arguments to struct constructor");
        }
        return new PersistentStructMap<K, V>(null, def, vals, ext);
    }

    public static <K, V> IFn getAccessor(final Def def, K key) {
        IMapEntry e = def.keyslots.entryAt(key);
        if (e != null) {
            final int i = (Integer)e.getValue();
            return new AFn(){

                public Object invoke(Object arg1) {
                    PersistentStructMap m = (PersistentStructMap)arg1;
                    if (m.def != def) {
                        throw Util.runtimeException("Accessor/struct mismatch");
                    }
                    return m.vals[i];
                }
            };
        }
        throw new IllegalArgumentException("Not a key of struct");
    }

    protected PersistentStructMap(IPersistentMap meta, Def def, Object[] vals, IPersistentMap<K, V> ext) {
        this._meta = meta;
        this.ext = ext;
        this.def = def;
        this.vals = vals;
    }

    protected PersistentStructMap<K, V> makeNew(IPersistentMap meta, Def def, Object[] vals, IPersistentMap<K, V> ext) {
        return new PersistentStructMap<K, V>(meta, def, vals, ext);
    }

    @Override
    public IObj withMeta(IPersistentMap meta) {
        if (meta == this._meta) {
            return this;
        }
        return this.makeNew(meta, this.def, this.vals, this.ext);
    }

    @Override
    public IPersistentMap meta() {
        return this._meta;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.def.keyslots.containsKey(key) || ((Map)((Object)this.ext)).containsKey(key);
    }

    @Override
    public IMapEntry<K, V> entryAt(K key) {
        IMapEntry e = this.def.keyslots.entryAt(key);
        if (e != null) {
            return new MapEntry(e.getKey(), this.vals[(Integer)e.getValue()]);
        }
        return this.ext.entryAt(key);
    }

    @Override
    public IPersistentMap<K, V> assoc(K key, V val) {
        IMapEntry e = this.def.keyslots.entryAt(key);
        if (e != null) {
            int i = (Integer)e.getValue();
            Object[] newVals = (Object[])this.vals.clone();
            newVals[i] = val;
            return this.makeNew(this._meta, this.def, newVals, this.ext);
        }
        return this.makeNew(this._meta, this.def, this.vals, this.ext.assoc(key, val));
    }

    @Override
    public V valAt(K key) {
        Integer i = (Integer)this.def.keyslots.valAt(key);
        if (i != null) {
            return (V)this.vals[i];
        }
        return this.ext.valAt(key);
    }

    @Override
    public V valAt(K key, V notFound) {
        Integer i = (Integer)this.def.keyslots.valAt(key);
        if (i != null) {
            return (V)this.vals[i];
        }
        return this.ext.valAt(key, notFound);
    }

    @Override
    public IPersistentMap<K, V> assocEx(K key, V val) {
        if (this.containsKey((Object)key)) {
            throw Util.runtimeException("Key already present");
        }
        return this.assoc((Object)key, (Object)val);
    }

    @Override
    public IPersistentMap<K, V> without(K key) {
        IMapEntry e = this.def.keyslots.entryAt(key);
        if (e != null) {
            throw Util.runtimeException("Can't remove struct key");
        }
        IPersistentMap<K, V> newExt = this.ext.without(key);
        if (newExt == this.ext) {
            return this;
        }
        return this.makeNew(this._meta, this.def, this.vals, newExt);
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return new Iterator<Map.Entry<K, V>>(){
            ISeq<IMapEntry<K, V>> seq;
            {
                this.seq = PersistentStructMap.this.seq();
            }

            @Override
            public boolean hasNext() {
                return this.seq != null;
            }

            @Override
            public Map.Entry<K, V> next() {
                Map.Entry first = this.seq.first();
                this.seq = this.seq.next();
                return first;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Iterator<Map.Entry<K, V>> reverseIterator() {
        return new Iterator<Map.Entry<K, V>>(){
            Iterator<Map.Entry<K, V>> mapIter;
            Object[] keys;
            int index;
            {
                this.mapIter = PersistentStructMap.this.ext.reverseIterator();
                this.keys = RT.seqToArray(PersistentStructMap.this.def.keys);
                this.index = this.keys.length;
            }

            @Override
            public boolean hasNext() {
                return this.mapIter.hasNext() || this.index > 0;
            }

            @Override
            public Map.Entry<K, V> next() {
                if (this.mapIter.hasNext()) {
                    return this.mapIter.next();
                }
                --this.index;
                return new MapEntry<Object, Object>(this.keys[this.index], PersistentStructMap.this.vals[this.index]);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Iterator<Map.Entry<K, V>> iteratorFrom(K key) {
        IMapEntry e = this.def.keyslots.entryAt(key);
        if (e != null) {
            final int start = (Integer)e.getValue();
            return new Iterator<Map.Entry<K, V>>(){
                int index;
                final Object[] keys;
                Iterator<Map.Entry<K, V>> extIt;
                {
                    this.index = start;
                    this.keys = RT.seqToArray(PersistentStructMap.this.def.keys);
                    this.extIt = PersistentStructMap.this.ext.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.index < PersistentStructMap.this.vals.length || this.extIt.hasNext();
                }

                @Override
                public Map.Entry<K, V> next() {
                    if (this.index < PersistentStructMap.this.vals.length) {
                        return new MapEntry<Object, Object>(this.keys[this.index], PersistentStructMap.this.vals[this.index++]);
                    }
                    return this.extIt.next();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return this.ext.iteratorFrom(key);
    }

    @Override
    public int count() {
        return this.vals.length + RT.count(this.ext);
    }

    @Override
    public ISeq<IMapEntry<K, V>> seq() {
        return new Seq(null, this.def.keys, this.vals, 0, this.ext);
    }

    @Override
    public IPersistentCollection empty() {
        return PersistentStructMap.construct(this.def, null);
    }

    static class Seq
    extends ASeq {
        final int i;
        final ISeq keys;
        final Object[] vals;
        final IPersistentMap ext;

        public Seq(IPersistentMap meta, ISeq keys, Object[] vals, int i, IPersistentMap ext) {
            super(meta);
            this.i = i;
            this.keys = keys;
            this.vals = vals;
            this.ext = ext;
        }

        public Obj withMeta(IPersistentMap meta) {
            if (meta != this._meta) {
                return new Seq(meta, this.keys, this.vals, this.i, this.ext);
            }
            return this;
        }

        public Object first() {
            return new MapEntry(this.keys.first(), this.vals[this.i]);
        }

        public ISeq next() {
            if (this.i + 1 < this.vals.length) {
                return new Seq(this._meta, this.keys.next(), this.vals, this.i + 1, this.ext);
            }
            return this.ext.seq();
        }
    }

    public static class Def
    implements Serializable {
        final ISeq keys;
        final IPersistentMap keyslots;

        Def(ISeq keys, IPersistentMap keyslots) {
            this.keys = keys;
            this.keyslots = keyslots;
        }
    }
}

