/*
 * Decompiled with CFR 0.152.
 */
package com.github.krukow.clj_lang;

import com.github.krukow.clj_lang.AFn;
import com.github.krukow.clj_lang.APersistentVector;
import com.github.krukow.clj_lang.ASeq;
import com.github.krukow.clj_lang.ArrayChunk;
import com.github.krukow.clj_lang.Counted;
import com.github.krukow.clj_lang.IChunk;
import com.github.krukow.clj_lang.IChunkedSeq;
import com.github.krukow.clj_lang.IDeref;
import com.github.krukow.clj_lang.IEditableCollection;
import com.github.krukow.clj_lang.IFn;
import com.github.krukow.clj_lang.IObj;
import com.github.krukow.clj_lang.IPersistentMap;
import com.github.krukow.clj_lang.IPersistentVector;
import com.github.krukow.clj_lang.ISeq;
import com.github.krukow.clj_lang.ITransientCollection;
import com.github.krukow.clj_lang.ITransientVector;
import com.github.krukow.clj_lang.MapEntry;
import com.github.krukow.clj_lang.Obj;
import com.github.krukow.clj_lang.PersistentList;
import com.github.krukow.clj_lang.RT;
import com.github.krukow.clj_lang.Util;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PersistentVector<T>
extends APersistentVector<T>
implements IObj,
IEditableCollection<T>,
com.github.krukow.clj_ds.PersistentVector<T> {
    static final AtomicReference<Thread> NOEDIT = new AtomicReference<Object>(null);
    static final Node EMPTY_NODE = new Node(NOEDIT, new Object[32]);
    final int cnt;
    final int shift;
    final Node root;
    final Object[] tail;
    final IPersistentMap _meta;
    public static final PersistentVector EMPTY = new PersistentVector(0, 5, EMPTY_NODE, new Object[0]);

    public static <T> PersistentVector<T> emptyVector() {
        return EMPTY;
    }

    public static <T> PersistentVector<T> create(ISeq<? extends T> items) {
        ITransientCollection ret = EMPTY.asTransient();
        while (items != null) {
            ret = ((TransientVector)ret).conj((Object)items.first());
            items = items.next();
        }
        return ((TransientVector)ret).persistentMap();
    }

    public static <T> PersistentVector<T> create(Iterable<? extends T> items) {
        ITransientCollection ret = EMPTY.asTransient();
        for (T item : items) {
            ret = ((TransientVector)ret).conj((Object)item);
        }
        return ((TransientVector)ret).persistentMap();
    }

    public static <T> PersistentVector<T> create(T ... items) {
        ITransientCollection ret = EMPTY.asTransient();
        for (T item : items) {
            ret = ((TransientVector)ret).conj((Object)item);
        }
        return ((TransientVector)ret).persistentMap();
    }

    PersistentVector(int cnt, int shift, Node root, Object[] tail) {
        this._meta = null;
        this.cnt = cnt;
        this.shift = shift;
        this.root = root;
        this.tail = tail;
    }

    PersistentVector(IPersistentMap meta, int cnt, int shift, Node root, Object[] tail) {
        this._meta = meta;
        this.cnt = cnt;
        this.shift = shift;
        this.root = root;
        this.tail = tail;
    }

    public PersistentVector(IPersistentMap meta, int cnt, int shift, Node root, Object[] tail, IFn f) {
        this._meta = this.meta();
        this.cnt = cnt;
        this.shift = shift;
        Object[] objectArray = tail;
        tail = null;
        this.tail = PersistentVector.mapArray(f, Util.ret1(objectArray, null));
        Node node = root;
        root = null;
        this.root = PersistentVector.mapNode(f, Util.ret1(node, null), this.shift);
    }

    @Override
    public TransientVector<T> asTransient() {
        return new TransientVector(this);
    }

    final int tailoff() {
        if (this.cnt < 32) {
            return 0;
        }
        return this.cnt - 1 >>> 5 << 5;
    }

    public Object[] arrayFor(int i) {
        if (i >= 0 && i < this.cnt) {
            if (i >= this.tailoff()) {
                return this.tail;
            }
            Node node = this.root;
            for (int level = this.shift; level > 0; level -= 5) {
                node = (Node)node.array[i >>> level & 0x1F];
            }
            return node.array;
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public T nth(int i) {
        Object[] node = this.arrayFor(i);
        return (T)node[i & 0x1F];
    }

    @Override
    public T nth(int i, T notFound) {
        if (i >= 0 && i < this.cnt) {
            return this.nth(i);
        }
        return notFound;
    }

    @Override
    public PersistentVector<T> assocN(int i, T val) {
        if (i >= 0 && i < this.cnt) {
            if (i >= this.tailoff()) {
                Object[] newTail = new Object[this.tail.length];
                System.arraycopy(this.tail, 0, newTail, 0, this.tail.length);
                newTail[i & 0x1F] = val;
                return new PersistentVector<T>(this.meta(), this.cnt, this.shift, this.root, newTail);
            }
            return new PersistentVector<T>(this.meta(), this.cnt, this.shift, PersistentVector.doAssoc(this.shift, this.root, i, val), this.tail);
        }
        if (i == this.cnt) {
            return this.cons((Object)val);
        }
        throw new IndexOutOfBoundsException();
    }

    private static Node doAssoc(int level, Node node, int i, Object val) {
        Node ret = new Node(node.edit, (Object[])node.array.clone());
        if (level == 0) {
            ret.array[i & 0x1F] = val;
        } else {
            int subidx = i >>> level & 0x1F;
            ret.array[subidx] = PersistentVector.doAssoc(level - 5, (Node)node.array[subidx], i, val);
        }
        return ret;
    }

    @Override
    public int count() {
        return this.cnt;
    }

    @Override
    public PersistentVector<T> withMeta(IPersistentMap meta) {
        return new PersistentVector<T>(meta, this.cnt, this.shift, this.root, this.tail);
    }

    @Override
    public IPersistentMap meta() {
        return this._meta;
    }

    @Override
    public PersistentVector<T> cons(T val) {
        Node newroot;
        int i = this.cnt;
        if (this.cnt - this.tailoff() < 32) {
            Object[] newTail = new Object[this.tail.length + 1];
            System.arraycopy(this.tail, 0, newTail, 0, this.tail.length);
            newTail[this.tail.length] = val;
            return new PersistentVector<T>(this.meta(), this.cnt + 1, this.shift, this.root, newTail);
        }
        Node tailnode = new Node(this.root.edit, this.tail);
        int newshift = this.shift;
        if (this.cnt >>> 5 > 1 << this.shift) {
            newroot = new Node(this.root.edit);
            newroot.array[0] = this.root;
            newroot.array[1] = PersistentVector.newPath(this.root.edit, this.shift, tailnode);
            newshift += 5;
        } else {
            newroot = this.pushTail(this.shift, this.root, tailnode);
        }
        return new PersistentVector<T>(this.meta(), this.cnt + 1, newshift, newroot, new Object[]{val});
    }

    private Node pushTail(int level, Node parent, Node tailnode) {
        Node child;
        int subidx = this.cnt - 1 >>> level & 0x1F;
        Node ret = new Node(parent.edit, (Object[])parent.array.clone());
        Node nodeToInsert = level == 5 ? tailnode : ((child = (Node)parent.array[subidx]) != null ? this.pushTail(level - 5, child, tailnode) : PersistentVector.newPath(this.root.edit, level - 5, tailnode));
        ret.array[subidx] = nodeToInsert;
        return ret;
    }

    private static Node newPath(AtomicReference<Thread> edit, int level, Node node) {
        if (level == 0) {
            return node;
        }
        Node ret = new Node(edit);
        ret.array[0] = PersistentVector.newPath(edit, level - 5, node);
        return ret;
    }

    public IChunkedSeq<T> chunkedSeq() {
        if (this.count() == 0) {
            return null;
        }
        return new ChunkedSeq(this, 0, 0);
    }

    @Override
    public ISeq<T> seq() {
        return this.chunkedSeq();
    }

    Iterator<T> rangedIterator(final int start, final int end) {
        return new Iterator<T>(){
            int i;
            int base;
            Object[] array;
            {
                this.i = start;
                this.base = this.i - this.i % 32;
                this.array = start < PersistentVector.this.count() ? PersistentVector.this.arrayFor(this.i) : null;
            }

            @Override
            public boolean hasNext() {
                return this.i < end;
            }

            @Override
            public T next() {
                if (this.i - this.base == 32) {
                    this.array = PersistentVector.this.arrayFor(this.i);
                    this.base += 32;
                }
                return this.array[this.i++ & 0x1F];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Iterator iterator151() {
        return this.rangedIterator(0, this.count());
    }

    public Object kvreduce(IFn f, Object init) {
        int step = 0;
        for (int i = 0; i < this.cnt; i += step) {
            Object[] array = this.arrayFor(i);
            for (int j = 0; j < array.length; ++j) {
                if (!RT.isReduced(init = f.invoke(init, j + i, array[j]))) continue;
                return ((IDeref)init).deref();
            }
            step = array.length;
        }
        return init;
    }

    @Override
    public Iterator<T> iterator() {
        return new PersistentVectorIterator(this);
    }

    @Override
    public PersistentVector<T> empty() {
        return EMPTY.withMeta(this.meta());
    }

    @Override
    public PersistentVector<T> pop() {
        if (this.cnt == 0) {
            throw new IllegalStateException("Can't pop empty vector");
        }
        if (this.cnt == 1) {
            return EMPTY.withMeta(this.meta());
        }
        if (this.cnt - this.tailoff() > 1) {
            Object[] newTail = new Object[this.tail.length - 1];
            System.arraycopy(this.tail, 0, newTail, 0, newTail.length);
            return new PersistentVector<T>(this.meta(), this.cnt - 1, this.shift, this.root, newTail);
        }
        Object[] newtail = this.arrayFor(this.cnt - 2);
        Node newroot = this.popTail(this.shift, this.root);
        int newshift = this.shift;
        if (newroot == null) {
            newroot = EMPTY_NODE;
        }
        if (this.shift > 5 && newroot.array[1] == null) {
            newroot = (Node)newroot.array[0];
            newshift -= 5;
        }
        return new PersistentVector<T>(this.meta(), this.cnt - 1, newshift, newroot, newtail);
    }

    private Node popTail(int level, Node node) {
        int subidx = this.cnt - 2 >>> level & 0x1F;
        if (level > 5) {
            Node newchild = this.popTail(level - 5, (Node)node.array[subidx]);
            if (newchild == null && subidx == 0) {
                return null;
            }
            Node ret = new Node(this.root.edit, (Object[])node.array.clone());
            ret.array[subidx] = newchild;
            return ret;
        }
        if (subidx == 0) {
            return null;
        }
        Node ret = new Node(this.root.edit, (Object[])node.array.clone());
        ret.array[subidx] = null;
        return ret;
    }

    @Override
    public com.github.krukow.clj_ds.PersistentVector<T> zero() {
        return this.empty();
    }

    @Override
    public com.github.krukow.clj_ds.PersistentVector<T> plus(T o) {
        return this.cons((Object)o);
    }

    @Override
    public com.github.krukow.clj_ds.PersistentVector<T> plusN(int i, T val) {
        return this.assocN(i, (Object)val);
    }

    @Override
    public com.github.krukow.clj_ds.PersistentVector<T> minus() {
        return this.pop();
    }

    public static IPersistentVector vectormap(IFn f, PersistentVector v) {
        v = null;
        return new PersistentVector(v._meta, v.cnt, v.shift, v.root, Util.ret1(v.tail, null), f);
    }

    private static Object[] mapArray(IFn f, Object[] arr) {
        Object[] res = new Object[arr.length];
        System.arraycopy(arr, 0, res, 0, arr.length);
        arr = null;
        try {
            for (int i = 0; i < res.length; ++i) {
                res[i] = f.invoke(res[i]);
            }
            return res;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Node mapNode(IFn f, Node node, int level) {
        if (node == null) {
            return null;
        }
        if (level == 0) {
            node = null;
            return new Node(null, PersistentVector.mapArray(f, Util.ret1(node.array, null)));
        }
        Object[] newArr = new Object[node.array.length];
        System.arraycopy(node.array, 0, newArr, 0, node.array.length);
        node = null;
        level -= 5;
        for (int i = 0; i < newArr.length; ++i) {
            newArr[i] = null;
            newArr[i] = PersistentVector.mapNode(f, Util.ret1((Node)newArr[i], null), level);
        }
        return new Node(null, newArr);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class TransientVector<T>
    extends AFn
    implements ITransientVector<T>,
    Counted,
    com.github.krukow.clj_ds.TransientVector<T> {
        int cnt;
        int shift;
        Node root;
        Object[] tail;

        TransientVector(int cnt, int shift, Node root, Object[] tail) {
            this.cnt = cnt;
            this.shift = shift;
            this.root = root;
            this.tail = tail;
        }

        TransientVector(PersistentVector<? extends T> v) {
            this(v.cnt, v.shift, TransientVector.editableRoot(v.root), TransientVector.editableTail(v.tail));
        }

        @Override
        public int count() {
            this.ensureEditable();
            return this.cnt;
        }

        Node ensureEditable(Node node) {
            if (node.edit == this.root.edit) {
                return node;
            }
            return new Node(this.root.edit, (Object[])node.array.clone());
        }

        void ensureEditable() {
            Thread owner = this.root.edit.get();
            if (owner == Thread.currentThread()) {
                return;
            }
            if (owner != null) {
                throw new IllegalAccessError("Transient used by non-owner thread");
            }
            throw new IllegalAccessError("Transient used after persistent! call");
        }

        static Node editableRoot(Node node) {
            return new Node(new AtomicReference<Thread>(Thread.currentThread()), (Object[])node.array.clone());
        }

        public PersistentVector<T> persistentMap() {
            this.ensureEditable();
            this.root.edit.set(null);
            Object[] trimmedTail = new Object[this.cnt - this.tailoff()];
            System.arraycopy(this.tail, 0, trimmedTail, 0, trimmedTail.length);
            return new PersistentVector(this.cnt, this.shift, this.root, trimmedTail);
        }

        static Object[] editableTail(Object[] tl) {
            Object[] ret = new Object[32];
            System.arraycopy(tl, 0, ret, 0, tl.length);
            return ret;
        }

        @Override
        public TransientVector<T> conj(Object val) {
            Node newroot;
            Object t = val;
            this.ensureEditable();
            int i = this.cnt++;
            if (i - this.tailoff() < 32) {
                this.tail[i & 0x1F] = val;
                return this;
            }
            Node tailnode = new Node(this.root.edit, this.tail);
            this.tail = new Object[32];
            this.tail[0] = val;
            int newshift = this.shift;
            if (this.cnt >>> 5 > 1 << this.shift) {
                newroot = new Node(this.root.edit);
                newroot.array[0] = this.root;
                newroot.array[1] = PersistentVector.newPath(this.root.edit, this.shift, tailnode);
                newshift += 5;
            } else {
                newroot = this.pushTail(this.shift, this.root, tailnode);
            }
            this.root = newroot;
            this.shift = newshift;
            ++this.cnt;
            return this;
        }

        private Node pushTail(int level, Node parent, Node tailnode) {
            Node child;
            parent = this.ensureEditable(parent);
            int subidx = this.cnt - 1 >>> level & 0x1F;
            Node ret = parent;
            Node nodeToInsert = level == 5 ? tailnode : ((child = (Node)parent.array[subidx]) != null ? this.pushTail(level - 5, child, tailnode) : PersistentVector.newPath(this.root.edit, level - 5, tailnode));
            ret.array[subidx] = nodeToInsert;
            return ret;
        }

        private final int tailoff() {
            if (this.cnt < 32) {
                return 0;
            }
            return this.cnt - 1 >>> 5 << 5;
        }

        private Object[] arrayFor(int i) {
            if (i >= 0 && i < this.cnt) {
                if (i >= this.tailoff()) {
                    return this.tail;
                }
                Node node = this.root;
                for (int level = this.shift; level > 0; level -= 5) {
                    node = (Node)node.array[i >>> level & 0x1F];
                }
                return node.array;
            }
            throw new IndexOutOfBoundsException();
        }

        private Object[] editableArrayFor(int i) {
            if (i >= 0 && i < this.cnt) {
                if (i >= this.tailoff()) {
                    return this.tail;
                }
                Node node = this.root;
                for (int level = this.shift; level > 0; level -= 5) {
                    node = this.ensureEditable((Node)node.array[i >>> level & 0x1F]);
                }
                return node.array;
            }
            throw new IndexOutOfBoundsException();
        }

        @Override
        public Object valAt(Object key) {
            return this.valAt(key, (Object)null);
        }

        @Override
        public Object valAt(Object key, Object notFound) {
            int i;
            this.ensureEditable();
            if (Util.isInteger(key) && (i = ((Number)key).intValue()) >= 0 && i < this.cnt) {
                return this.nth(i);
            }
            return notFound;
        }

        @Override
        public Object invoke(Object arg1) {
            if (Util.isInteger(arg1)) {
                return this.nth(((Number)arg1).intValue());
            }
            throw new IllegalArgumentException("Key must be integer");
        }

        @Override
        public T nth(int i) {
            this.ensureEditable();
            Object[] node = this.arrayFor(i);
            return (T)node[i & 0x1F];
        }

        @Override
        public T nth(int i, T notFound) {
            if (i >= 0 && i < this.count()) {
                return this.nth(i);
            }
            return notFound;
        }

        @Override
        public TransientVector<T> assocN(int i, T val) {
            this.ensureEditable();
            if (i >= 0 && i < this.cnt) {
                if (i >= this.tailoff()) {
                    this.tail[i & 0x1F] = val;
                    return this;
                }
                this.root = this.doAssoc(this.shift, this.root, i, val);
                return this;
            }
            if (i == this.cnt) {
                return this.conj((Object)val);
            }
            throw new IndexOutOfBoundsException();
        }

        public TransientVector<T> assoc(Object key, Object val) {
            if (Util.isInteger(key)) {
                int i = ((Number)key).intValue();
                return this.assocN(i, val);
            }
            throw new IllegalArgumentException("Key must be integer");
        }

        private Node doAssoc(int level, Node node, int i, Object val) {
            Node ret = node = this.ensureEditable(node);
            if (level == 0) {
                ret.array[i & 0x1F] = val;
            } else {
                int subidx = i >>> level & 0x1F;
                ret.array[subidx] = this.doAssoc(level - 5, (Node)node.array[subidx], i, val);
            }
            return ret;
        }

        @Override
        public TransientVector<T> pop() {
            this.ensureEditable();
            if (this.cnt == 0) {
                throw new IllegalStateException("Can't pop empty vector");
            }
            if (this.cnt == 1) {
                this.cnt = 0;
                return this;
            }
            int i = this.cnt - 1;
            if ((i & 0x1F) > 0) {
                --this.cnt;
                return this;
            }
            Object[] newtail = this.editableArrayFor(this.cnt - 2);
            Node newroot = this.popTail(this.shift, this.root);
            int newshift = this.shift;
            if (newroot == null) {
                newroot = new Node(this.root.edit);
            }
            if (this.shift > 5 && newroot.array[1] == null) {
                newroot = this.ensureEditable((Node)newroot.array[0]);
                newshift -= 5;
            }
            this.root = newroot;
            this.shift = newshift;
            --this.cnt;
            this.tail = newtail;
            return this;
        }

        private Node popTail(int level, Node node) {
            node = this.ensureEditable(node);
            int subidx = this.cnt - 2 >>> level & 0x1F;
            if (level > 5) {
                Node newchild = this.popTail(level - 5, (Node)node.array[subidx]);
                if (newchild == null && subidx == 0) {
                    return null;
                }
                Node ret = node;
                ret.array[subidx] = newchild;
                return ret;
            }
            if (subidx == 0) {
                return null;
            }
            Node ret = node;
            ret.array[subidx] = null;
            return ret;
        }

        @Override
        public PersistentVector<T> persistent() {
            return this.persistentMap();
        }

        @Override
        public com.github.krukow.clj_ds.PersistentVector<T> persist() {
            return this.persistent();
        }

        @Override
        public com.github.krukow.clj_ds.TransientVector<T> plus(T val) {
            return this.conj((Object)val);
        }

        @Override
        public com.github.krukow.clj_ds.TransientVector<T> plusN(int i, T val) {
            return this.assocN(i, (Object)val);
        }

        @Override
        public com.github.krukow.clj_ds.TransientVector<T> minus() {
            return this.pop();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ChunkedSeq<T>
    extends ASeq<T>
    implements IChunkedSeq<T> {
        public final PersistentVector<T> vec;
        final Object[] node;
        final int i;
        public final int offset;

        public ChunkedSeq(PersistentVector<T> vec, int i, int offset) {
            this.vec = vec;
            this.i = i;
            this.offset = offset;
            this.node = vec.arrayFor(i);
        }

        ChunkedSeq(IPersistentMap meta, PersistentVector<T> vec, Object[] node, int i, int offset) {
            super(meta);
            this.vec = vec;
            this.node = node;
            this.i = i;
            this.offset = offset;
        }

        ChunkedSeq(PersistentVector<T> vec, Object[] node, int i, int offset) {
            this.vec = vec;
            this.node = node;
            this.i = i;
            this.offset = offset;
        }

        @Override
        public IChunk<T> chunkedFirst() {
            return new ArrayChunk(this.node, this.offset);
        }

        @Override
        public ISeq<T> chunkedNext() {
            if (this.i + this.node.length < this.vec.cnt) {
                return new ChunkedSeq<T>(this.vec, this.i + this.node.length, 0);
            }
            return null;
        }

        @Override
        public ISeq<T> chunkedMore() {
            ISeq<T> s = this.chunkedNext();
            if (s == null) {
                return PersistentList.emptyList();
            }
            return s;
        }

        @Override
        public Obj withMeta(IPersistentMap meta) {
            if (meta == this._meta) {
                return this;
            }
            return new ChunkedSeq<T>(meta, this.vec, this.node, this.i, this.offset);
        }

        @Override
        public T first() {
            return (T)this.node[this.offset];
        }

        @Override
        public ISeq<T> next() {
            if (this.offset + 1 < this.node.length) {
                return new ChunkedSeq<T>(this.vec, this.node, this.i, this.offset + 1);
            }
            return this.chunkedNext();
        }

        @Override
        public int count() {
            return this.vec.cnt - (this.i + this.offset);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class PersistentVectorIterator<T>
    implements Iterator<T> {
        PersistentVector<T> vec;
        int sft;
        Stack<MapEntry<Integer, Object[]>> path;
        Object[] current;
        int currentIndex;

        public PersistentVectorIterator(PersistentVector<T> vec) {
            this.vec = vec;
            this.sft = vec.shift;
            this.path = this.initialPath();
            MapEntry<Integer, Object[]> el = this.path.peek();
            this.current = el.key() == -1 ? el.val() : ((Node)el.val()[el.key().intValue()]).array;
        }

        @Override
        public boolean hasNext() {
            this.ensureCurrentReady();
            return this.current != null && this.currentIndex < this.current.length;
        }

        private void ensureCurrentReady() {
            if (this.current != null && this.currentIndex < this.current.length) {
                return;
            }
            Object[] last = this.current;
            this.current = this.findNextArray();
            if (this.current != last) {
                this.currentIndex = 0;
            }
        }

        private Object[] findNextArray() {
            if (this.path.isEmpty()) {
                return null;
            }
            while (this.path.peek().getKey() != -1) {
                Node next;
                MapEntry<Integer, Object[]> loc = this.path.pop();
                int idx = loc.key();
                Object[] arr = loc.val();
                if (++idx >= arr.length || (next = (Node)arr[idx]) == null) continue;
                this.path.push(new MapEntry<Integer, Object[]>(idx, arr));
                for (int level = this.sft - (this.path.size() - 1) * 5; level > 0; level -= 5) {
                    this.path.push(new MapEntry<Integer, Object[]>(0, next.array));
                    next = (Node)next.array[0];
                }
                return next.array;
            }
            return this.path.pop().val();
        }

        private Stack<MapEntry<Integer, Object[]>> initialPath() {
            Stack<MapEntry<Integer, Object[]>> res = new Stack<MapEntry<Integer, Object[]>>();
            res.push(new MapEntry<Integer, Object[]>(-1, this.vec.tail));
            Node node = this.vec.root;
            for (int level = this.sft; level > 0; level -= 5) {
                res.push(new MapEntry<Integer, Object[]>(0, node.array));
                node = (Node)node.array[0];
                if (node != null) continue;
                res.pop();
                break;
            }
            return res;
        }

        @Override
        public T next() {
            return (T)this.current[this.currentIndex++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class Node
    implements Serializable {
        final transient AtomicReference<Thread> edit;
        final Object[] array;

        Node(AtomicReference<Thread> edit, Object[] array) {
            this.edit = edit;
            this.array = array;
        }

        Node(AtomicReference<Thread> edit) {
            this.edit = edit;
            this.array = new Object[32];
        }
    }
}

