/*
 * Decompiled with CFR 0.152.
 */
package com.github.krukow.clj_lang;

import com.github.krukow.clj_lang.APersistentMap;
import com.github.krukow.clj_lang.APersistentVector;
import com.github.krukow.clj_lang.ASeq;
import com.github.krukow.clj_lang.ArraySeq;
import com.github.krukow.clj_lang.Associative;
import com.github.krukow.clj_lang.BigInt;
import com.github.krukow.clj_lang.Cons;
import com.github.krukow.clj_lang.Counted;
import com.github.krukow.clj_lang.ILookup;
import com.github.krukow.clj_lang.IMapEntry;
import com.github.krukow.clj_lang.IMeta;
import com.github.krukow.clj_lang.IPersistentCollection;
import com.github.krukow.clj_lang.IPersistentList;
import com.github.krukow.clj_lang.IPersistentMap;
import com.github.krukow.clj_lang.IPersistentSet;
import com.github.krukow.clj_lang.IPersistentStack;
import com.github.krukow.clj_lang.IPersistentVector;
import com.github.krukow.clj_lang.ISeq;
import com.github.krukow.clj_lang.Indexed;
import com.github.krukow.clj_lang.IteratorSeq;
import com.github.krukow.clj_lang.LazilyPersistentVector;
import com.github.krukow.clj_lang.LazySeq;
import com.github.krukow.clj_lang.MapEntry;
import com.github.krukow.clj_lang.Obj;
import com.github.krukow.clj_lang.PersistentArrayMap;
import com.github.krukow.clj_lang.PersistentHashSet;
import com.github.krukow.clj_lang.PersistentList;
import com.github.krukow.clj_lang.PersistentVector;
import com.github.krukow.clj_lang.Ratio;
import com.github.krukow.clj_lang.Reduced;
import com.github.krukow.clj_lang.Reflector;
import com.github.krukow.clj_lang.Seqable;
import com.github.krukow.clj_lang.Sequential;
import com.github.krukow.clj_lang.Util;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.OutputStreamWriter;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import java.util.Set;
import java.util.regex.Matcher;

public class RT {
    public static final Boolean T = Boolean.TRUE;
    public static final Boolean F = Boolean.FALSE;
    public static Charset UTF8 = Charset.forName("UTF-8");
    static volatile boolean readably = true;
    static volatile boolean print_meta = true;
    public static final Object[] EMPTY_ARRAY = new Object[0];
    public static final Comparator DEFAULT_COMPARATOR = new DefaultComparator();

    public static ISeq seq(Object coll) {
        if (coll instanceof ASeq) {
            return (ASeq)coll;
        }
        if (coll instanceof LazySeq) {
            return ((LazySeq)coll).seq();
        }
        return RT.seqFrom(coll);
    }

    static ISeq seqFrom(Object coll) {
        if (coll instanceof Seqable) {
            return ((Seqable)coll).seq();
        }
        if (coll == null) {
            return null;
        }
        if (coll instanceof Iterable) {
            return IteratorSeq.create(((Iterable)coll).iterator());
        }
        if (coll.getClass().isArray()) {
            return ArraySeq.createFromObject(coll);
        }
        if (coll instanceof Map) {
            return RT.seq(((Map)coll).entrySet());
        }
        Class<?> c = coll.getClass();
        Class<?> sc = c.getSuperclass();
        throw new IllegalArgumentException("Don't know how to create ISeq from: " + c.getName());
    }

    public static Object seqOrElse(Object o) {
        return RT.seq(o) == null ? null : o;
    }

    public static ISeq keys(Object coll) {
        return APersistentMap.KeySeq.create(RT.seq(coll));
    }

    public static ISeq vals(Object coll) {
        return APersistentMap.ValSeq.create(RT.seq(coll));
    }

    public static IPersistentMap meta(Object x) {
        if (x instanceof IMeta) {
            return ((IMeta)x).meta();
        }
        return null;
    }

    public static int count(Object o) {
        if (o instanceof Counted) {
            return ((Counted)o).count();
        }
        Object object = o;
        o = null;
        return RT.countFrom(Util.ret1(object, null));
    }

    static int countFrom(Object o) {
        if (o == null) {
            return 0;
        }
        if (o instanceof IPersistentCollection) {
            ISeq s = RT.seq(o);
            o = null;
            int i = 0;
            while (s != null) {
                if (s instanceof Counted) {
                    return i + s.count();
                }
                ++i;
                s = s.next();
            }
            return i;
        }
        if (o instanceof CharSequence) {
            return ((CharSequence)o).length();
        }
        if (o instanceof Collection) {
            return ((Collection)o).size();
        }
        if (o instanceof Map) {
            return ((Map)o).size();
        }
        if (o.getClass().isArray()) {
            return Array.getLength(o);
        }
        throw new UnsupportedOperationException("count not supported on this type: " + o.getClass().getSimpleName());
    }

    public static IPersistentCollection conj(IPersistentCollection coll, Object x) {
        if (coll == null) {
            return new PersistentList<Object>(x);
        }
        return coll.cons(x);
    }

    public static ISeq cons(Object x, Object coll) {
        if (coll == null) {
            return new PersistentList<Object>(x);
        }
        if (coll instanceof ISeq) {
            return new Cons<Object>(x, (ISeq)coll);
        }
        return new Cons<Object>(x, RT.seq(coll));
    }

    public static Object first(Object x) {
        if (x instanceof ISeq) {
            return ((ISeq)x).first();
        }
        ISeq seq = RT.seq(x);
        if (seq == null) {
            return null;
        }
        return seq.first();
    }

    public static Object second(Object x) {
        return RT.first(RT.next(x));
    }

    public static Object third(Object x) {
        return RT.first(RT.next(RT.next(x)));
    }

    public static Object fourth(Object x) {
        return RT.first(RT.next(RT.next(RT.next(x))));
    }

    public static ISeq next(Object x) {
        if (x instanceof ISeq) {
            return ((ISeq)x).next();
        }
        ISeq seq = RT.seq(x);
        if (seq == null) {
            return null;
        }
        return seq.next();
    }

    public static ISeq more(Object x) {
        if (x instanceof ISeq) {
            return ((ISeq)x).more();
        }
        ISeq seq = RT.seq(x);
        if (seq == null) {
            return PersistentList.EMPTY;
        }
        return seq.more();
    }

    public static Object peek(Object x) {
        if (x == null) {
            return null;
        }
        return ((IPersistentStack)x).peek();
    }

    public static Object pop(Object x) {
        if (x == null) {
            return null;
        }
        return ((IPersistentStack)x).pop();
    }

    public static Object get(Object coll, Object key) {
        if (coll instanceof ILookup) {
            return ((ILookup)coll).valAt(key);
        }
        return RT.getFrom(coll, key);
    }

    static Object getFrom(Object coll, Object key) {
        if (coll == null) {
            return null;
        }
        if (coll instanceof Map) {
            Map m = (Map)coll;
            return m.get(key);
        }
        if (coll instanceof IPersistentSet) {
            IPersistentSet set = (IPersistentSet)coll;
            return set.get(key);
        }
        if (key instanceof Number && (coll instanceof String || coll.getClass().isArray())) {
            int n = ((Number)key).intValue();
            if (n >= 0 && n < RT.count(coll)) {
                return RT.nth(coll, n);
            }
            return null;
        }
        return null;
    }

    public static Object get(Object coll, Object key, Object notFound) {
        if (coll instanceof ILookup) {
            return ((ILookup)coll).valAt(key, notFound);
        }
        return RT.getFrom(coll, key, notFound);
    }

    static Object getFrom(Object coll, Object key, Object notFound) {
        if (coll == null) {
            return notFound;
        }
        if (coll instanceof Map) {
            Map m = (Map)coll;
            if (m.containsKey(key)) {
                return m.get(key);
            }
            return notFound;
        }
        if (coll instanceof IPersistentSet) {
            IPersistentSet set = (IPersistentSet)coll;
            if (set.contains(key)) {
                return set.get(key);
            }
            return notFound;
        }
        if (key instanceof Number && (coll instanceof String || coll.getClass().isArray())) {
            int n = ((Number)key).intValue();
            return n >= 0 && n < RT.count(coll) ? RT.nth(coll, n) : notFound;
        }
        return notFound;
    }

    public static Associative assoc(Object coll, Object key, Object val) {
        if (coll == null) {
            return new PersistentArrayMap(new Object[]{key, val});
        }
        return ((Associative)coll).assoc(key, val);
    }

    public static Object contains(Object coll, Object key) {
        if (coll == null) {
            return F;
        }
        if (coll instanceof Associative) {
            return ((Associative)coll).containsKey(key) ? T : F;
        }
        if (coll instanceof IPersistentSet) {
            return ((IPersistentSet)coll).contains(key) ? T : F;
        }
        if (coll instanceof Map) {
            Map m = (Map)coll;
            return m.containsKey(key) ? T : F;
        }
        if (coll instanceof Set) {
            Set s = (Set)coll;
            return s.contains(key) ? T : F;
        }
        if (key instanceof Number && (coll instanceof String || coll.getClass().isArray())) {
            int n = ((Number)key).intValue();
            return n >= 0 && n < RT.count(coll);
        }
        throw new IllegalArgumentException("contains? not supported on type: " + coll.getClass().getName());
    }

    public static Object find(Object coll, Object key) {
        if (coll == null) {
            return null;
        }
        if (coll instanceof Associative) {
            return ((Associative)coll).entryAt(key);
        }
        Map m = (Map)coll;
        if (m.containsKey(key)) {
            return new MapEntry(key, m.get(key));
        }
        return null;
    }

    public static Object dissoc(Object coll, Object key) throws Exception {
        if (coll == null) {
            return null;
        }
        return ((IPersistentMap)coll).without(key);
    }

    public static Object nth(Object coll, int n) {
        if (coll instanceof Indexed) {
            return ((Indexed)coll).nth(n);
        }
        Object object = coll;
        coll = null;
        return RT.nthFrom(Util.ret1(object, null), n);
    }

    static Object nthFrom(Object coll, int n) {
        if (coll == null) {
            return null;
        }
        if (coll instanceof CharSequence) {
            return Character.valueOf(((CharSequence)coll).charAt(n));
        }
        if (coll.getClass().isArray()) {
            return Reflector.prepRet(coll.getClass().getComponentType(), Array.get(coll, n));
        }
        if (coll instanceof RandomAccess) {
            return ((List)coll).get(n);
        }
        if (coll instanceof Matcher) {
            return ((Matcher)coll).group(n);
        }
        if (coll instanceof Map.Entry) {
            Map.Entry e = (Map.Entry)coll;
            if (n == 0) {
                return e.getKey();
            }
            if (n == 1) {
                return e.getValue();
            }
            throw new IndexOutOfBoundsException();
        }
        if (coll instanceof Sequential) {
            ISeq seq = RT.seq(coll);
            coll = null;
            for (int i = 0; i <= n && seq != null; ++i, seq = seq.next()) {
                if (i != n) continue;
                return seq.first();
            }
            throw new IndexOutOfBoundsException();
        }
        throw new UnsupportedOperationException("nth not supported on this type: " + coll.getClass().getSimpleName());
    }

    public static Object nth(Object coll, int n, Object notFound) {
        if (coll instanceof Indexed) {
            Indexed v = (Indexed)coll;
            return v.nth(n, notFound);
        }
        return RT.nthFrom(coll, n, notFound);
    }

    static Object nthFrom(Object coll, int n, Object notFound) {
        if (coll == null) {
            return notFound;
        }
        if (n < 0) {
            return notFound;
        }
        if (coll instanceof CharSequence) {
            CharSequence s = (CharSequence)coll;
            if (n < s.length()) {
                return Character.valueOf(s.charAt(n));
            }
            return notFound;
        }
        if (coll.getClass().isArray()) {
            if (n < Array.getLength(coll)) {
                return Reflector.prepRet(coll.getClass().getComponentType(), Array.get(coll, n));
            }
            return notFound;
        }
        if (coll instanceof RandomAccess) {
            List list = (List)coll;
            if (n < list.size()) {
                return list.get(n);
            }
            return notFound;
        }
        if (coll instanceof Matcher) {
            Matcher m = (Matcher)coll;
            if (n < m.groupCount()) {
                return m.group(n);
            }
            return notFound;
        }
        if (coll instanceof Map.Entry) {
            Map.Entry e = (Map.Entry)coll;
            if (n == 0) {
                return e.getKey();
            }
            if (n == 1) {
                return e.getValue();
            }
            return notFound;
        }
        if (coll instanceof Sequential) {
            ISeq seq = RT.seq(coll);
            coll = null;
            for (int i = 0; i <= n && seq != null; ++i, seq = seq.next()) {
                if (i != n) continue;
                return seq.first();
            }
            return notFound;
        }
        throw new UnsupportedOperationException("nth not supported on this type: " + coll.getClass().getSimpleName());
    }

    public static Object assocN(int n, Object val, Object coll) {
        if (coll == null) {
            return null;
        }
        if (coll instanceof IPersistentVector) {
            return ((IPersistentVector)coll).assocN(n, val);
        }
        if (coll instanceof Object[]) {
            Object[] array = (Object[])coll;
            array[n] = val;
            return array;
        }
        return null;
    }

    public static Object box(Object x) {
        return x;
    }

    public static Character box(char x) {
        return Character.valueOf(x);
    }

    public static Object box(boolean x) {
        return x ? T : F;
    }

    public static Object box(Boolean x) {
        return x;
    }

    public static Number box(byte x) {
        return x;
    }

    public static Number box(short x) {
        return x;
    }

    public static Number box(int x) {
        return x;
    }

    public static Number box(long x) {
        return x;
    }

    public static Number box(float x) {
        return Float.valueOf(x);
    }

    public static Number box(double x) {
        return x;
    }

    public static char charCast(Object x) {
        if (x instanceof Character) {
            return ((Character)x).charValue();
        }
        long n = ((Number)x).longValue();
        if (n < 0L || n > 65535L) {
            throw new IllegalArgumentException("Value out of range for char: " + x);
        }
        return (char)n;
    }

    public static char charCast(byte x) {
        char i = (char)x;
        if (i != x) {
            throw new IllegalArgumentException("Value out of range for char: " + x);
        }
        return i;
    }

    public static char charCast(short x) {
        char i = (char)x;
        if (i != x) {
            throw new IllegalArgumentException("Value out of range for char: " + x);
        }
        return i;
    }

    public static char charCast(char x) {
        return x;
    }

    public static char charCast(int x) {
        char i = (char)x;
        if (i != x) {
            throw new IllegalArgumentException("Value out of range for char: " + x);
        }
        return i;
    }

    public static char charCast(long x) {
        char i = (char)x;
        if ((long)i != x) {
            throw new IllegalArgumentException("Value out of range for char: " + x);
        }
        return i;
    }

    public static char charCast(float x) {
        if (x >= 0.0f && x <= 65535.0f) {
            return (char)x;
        }
        throw new IllegalArgumentException("Value out of range for char: " + x);
    }

    public static char charCast(double x) {
        if (x >= 0.0 && x <= 65535.0) {
            return (char)x;
        }
        throw new IllegalArgumentException("Value out of range for char: " + x);
    }

    public static boolean booleanCast(Object x) {
        if (x instanceof Boolean) {
            return (Boolean)x;
        }
        return x != null;
    }

    public static boolean booleanCast(boolean x) {
        return x;
    }

    public static byte byteCast(Object x) {
        if (x instanceof Byte) {
            return (Byte)x;
        }
        long n = RT.longCast(x);
        if (n < -128L || n > 127L) {
            throw new IllegalArgumentException("Value out of range for byte: " + x);
        }
        return (byte)n;
    }

    public static byte byteCast(byte x) {
        return x;
    }

    public static byte byteCast(short x) {
        byte i = (byte)x;
        if (i != x) {
            throw new IllegalArgumentException("Value out of range for byte: " + x);
        }
        return i;
    }

    public static byte byteCast(int x) {
        byte i = (byte)x;
        if (i != x) {
            throw new IllegalArgumentException("Value out of range for byte: " + x);
        }
        return i;
    }

    public static byte byteCast(long x) {
        byte i = (byte)x;
        if ((long)i != x) {
            throw new IllegalArgumentException("Value out of range for byte: " + x);
        }
        return i;
    }

    public static byte byteCast(float x) {
        if (x >= -128.0f && x <= 127.0f) {
            return (byte)x;
        }
        throw new IllegalArgumentException("Value out of range for byte: " + x);
    }

    public static byte byteCast(double x) {
        if (x >= -128.0 && x <= 127.0) {
            return (byte)x;
        }
        throw new IllegalArgumentException("Value out of range for byte: " + x);
    }

    public static short shortCast(Object x) {
        if (x instanceof Short) {
            return (Short)x;
        }
        long n = RT.longCast(x);
        if (n < -32768L || n > 32767L) {
            throw new IllegalArgumentException("Value out of range for short: " + x);
        }
        return (short)n;
    }

    public static short shortCast(byte x) {
        return x;
    }

    public static short shortCast(short x) {
        return x;
    }

    public static short shortCast(int x) {
        short i = (short)x;
        if (i != x) {
            throw new IllegalArgumentException("Value out of range for short: " + x);
        }
        return i;
    }

    public static short shortCast(long x) {
        short i = (short)x;
        if ((long)i != x) {
            throw new IllegalArgumentException("Value out of range for short: " + x);
        }
        return i;
    }

    public static short shortCast(float x) {
        if (x >= -32768.0f && x <= 32767.0f) {
            return (short)x;
        }
        throw new IllegalArgumentException("Value out of range for short: " + x);
    }

    public static short shortCast(double x) {
        if (x >= -32768.0 && x <= 32767.0) {
            return (short)x;
        }
        throw new IllegalArgumentException("Value out of range for short: " + x);
    }

    public static int intCast(Object x) {
        if (x instanceof Integer) {
            return (Integer)x;
        }
        if (x instanceof Number) {
            long n = RT.longCast(x);
            return RT.intCast(n);
        }
        return ((Character)x).charValue();
    }

    public static int intCast(char x) {
        return x;
    }

    public static int intCast(byte x) {
        return x;
    }

    public static int intCast(short x) {
        return x;
    }

    public static int intCast(int x) {
        return x;
    }

    public static int intCast(float x) {
        if (x < -2.1474836E9f || x > 2.1474836E9f) {
            throw new IllegalArgumentException("Value out of range for int: " + x);
        }
        return (int)x;
    }

    public static int intCast(long x) {
        if (x < Integer.MIN_VALUE || x > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Value out of range for int: " + x);
        }
        return (int)x;
    }

    public static int intCast(double x) {
        if (x < -2.147483648E9 || x > 2.147483647E9) {
            throw new IllegalArgumentException("Value out of range for int: " + x);
        }
        return (int)x;
    }

    public static long longCast(Object x) {
        if (x instanceof Integer || x instanceof Long) {
            return ((Number)x).longValue();
        }
        if (x instanceof BigInt) {
            BigInt bi = (BigInt)x;
            if (bi.bipart == null) {
                return bi.lpart;
            }
            throw new IllegalArgumentException("Value out of range for long: " + x);
        }
        if (x instanceof BigInteger) {
            BigInteger bi = (BigInteger)x;
            if (bi.bitLength() < 64) {
                return bi.longValue();
            }
            throw new IllegalArgumentException("Value out of range for long: " + x);
        }
        if (x instanceof Byte || x instanceof Short) {
            return ((Number)x).longValue();
        }
        if (x instanceof Ratio) {
            return RT.longCast(((Ratio)x).bigIntegerValue());
        }
        if (x instanceof Character) {
            return RT.longCast(((Character)x).charValue());
        }
        return RT.longCast(((Number)x).doubleValue());
    }

    public static long longCast(byte x) {
        return x;
    }

    public static long longCast(short x) {
        return x;
    }

    public static long longCast(int x) {
        return x;
    }

    public static long longCast(float x) {
        if (x < -9.223372E18f || x > 9.223372E18f) {
            throw new IllegalArgumentException("Value out of range for long: " + x);
        }
        return (long)x;
    }

    public static long longCast(long x) {
        return x;
    }

    public static long longCast(double x) {
        if (x < -9.223372036854776E18 || x > 9.223372036854776E18) {
            throw new IllegalArgumentException("Value out of range for long: " + x);
        }
        return (long)x;
    }

    public static float floatCast(Object x) {
        if (x instanceof Float) {
            return ((Float)x).floatValue();
        }
        double n = ((Number)x).doubleValue();
        if (n < -3.4028234663852886E38 || n > 3.4028234663852886E38) {
            throw new IllegalArgumentException("Value out of range for float: " + x);
        }
        return (float)n;
    }

    public static float floatCast(byte x) {
        return x;
    }

    public static float floatCast(short x) {
        return x;
    }

    public static float floatCast(int x) {
        return x;
    }

    public static float floatCast(float x) {
        return x;
    }

    public static float floatCast(long x) {
        return x;
    }

    public static float floatCast(double x) {
        if (x < -3.4028234663852886E38 || x > 3.4028234663852886E38) {
            throw new IllegalArgumentException("Value out of range for float: " + x);
        }
        return (float)x;
    }

    public static double doubleCast(Object x) {
        return ((Number)x).doubleValue();
    }

    public static double doubleCast(byte x) {
        return x;
    }

    public static double doubleCast(short x) {
        return x;
    }

    public static double doubleCast(int x) {
        return x;
    }

    public static double doubleCast(float x) {
        return x;
    }

    public static double doubleCast(long x) {
        return x;
    }

    public static double doubleCast(double x) {
        return x;
    }

    public static IPersistentSet set(Object ... init) {
        return PersistentHashSet.createWithCheck(init);
    }

    public static IPersistentVector vector(Object ... init) {
        return LazilyPersistentVector.createOwning(init);
    }

    public static IPersistentVector subvec(IPersistentVector v, int start, int end) {
        if (end < start || start < 0 || end > v.count()) {
            throw new IndexOutOfBoundsException();
        }
        if (start == end) {
            return PersistentVector.EMPTY;
        }
        return new APersistentVector.SubVector(null, v, start, end);
    }

    public static ISeq list() {
        return null;
    }

    public static ISeq list(Object arg1) {
        return new PersistentList<Object>(arg1);
    }

    public static ISeq list(Object arg1, Object arg2) {
        return RT.listStar(arg1, arg2, null);
    }

    public static ISeq list(Object arg1, Object arg2, Object arg3) {
        return RT.listStar(arg1, arg2, arg3, null);
    }

    public static ISeq list(Object arg1, Object arg2, Object arg3, Object arg4) {
        return RT.listStar(arg1, arg2, arg3, arg4, null);
    }

    public static ISeq list(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5) {
        return RT.listStar(arg1, arg2, arg3, arg4, arg5, null);
    }

    public static ISeq listStar(Object arg1, ISeq rest) {
        return RT.cons(arg1, rest);
    }

    public static ISeq listStar(Object arg1, Object arg2, ISeq rest) {
        return RT.cons(arg1, RT.cons(arg2, rest));
    }

    public static ISeq listStar(Object arg1, Object arg2, Object arg3, ISeq rest) {
        return RT.cons(arg1, RT.cons(arg2, RT.cons(arg3, rest)));
    }

    public static ISeq listStar(Object arg1, Object arg2, Object arg3, Object arg4, ISeq rest) {
        return RT.cons(arg1, RT.cons(arg2, RT.cons(arg3, RT.cons(arg4, rest))));
    }

    public static ISeq listStar(Object arg1, Object arg2, Object arg3, Object arg4, Object arg5, ISeq rest) {
        return RT.cons(arg1, RT.cons(arg2, RT.cons(arg3, RT.cons(arg4, RT.cons(arg5, rest)))));
    }

    public static ISeq arrayToList(Object[] a) {
        ISeq ret = null;
        for (int i = a.length - 1; i >= 0; --i) {
            ret = RT.cons(a[i], ret);
        }
        return ret;
    }

    public static Object[] object_array(Object sizeOrSeq) {
        if (sizeOrSeq instanceof Number) {
            return new Object[((Number)sizeOrSeq).intValue()];
        }
        ISeq s = RT.seq(sizeOrSeq);
        int size = RT.count(s);
        Object[] ret = new Object[size];
        for (int i = 0; i < size && s != null; ++i, s = s.next()) {
            ret[i] = s.first();
        }
        return ret;
    }

    public static Object[] toArray(Object coll) {
        if (coll == null) {
            return EMPTY_ARRAY;
        }
        if (coll instanceof Object[]) {
            return (Object[])coll;
        }
        if (coll instanceof Collection) {
            return ((Collection)coll).toArray();
        }
        if (coll instanceof Map) {
            return ((Map)coll).entrySet().toArray();
        }
        if (coll instanceof String) {
            char[] chars = ((String)coll).toCharArray();
            Object[] ret = new Object[chars.length];
            for (int i = 0; i < chars.length; ++i) {
                ret[i] = Character.valueOf(chars[i]);
            }
            return ret;
        }
        if (coll.getClass().isArray()) {
            ISeq s = RT.seq(coll);
            Object[] ret = new Object[RT.count(s)];
            int i = 0;
            while (i < ret.length) {
                ret[i] = s.first();
                ++i;
                s = s.next();
            }
            return ret;
        }
        throw Util.runtimeException("Unable to convert: " + coll.getClass() + " to Object[]");
    }

    public static Object[] seqToArray(ISeq seq) {
        int len = RT.length(seq);
        Object[] ret = new Object[len];
        int i = 0;
        while (seq != null) {
            ret[i] = seq.first();
            ++i;
            seq = seq.next();
        }
        return ret;
    }

    public static Object[] seqToPassedArray(ISeq seq, Object[] passed) {
        Object[] dest = passed;
        int len = RT.count(seq);
        if (len > dest.length) {
            dest = (Object[])Array.newInstance(passed.getClass().getComponentType(), len);
        }
        int i = 0;
        while (seq != null) {
            dest[i] = seq.first();
            ++i;
            seq = seq.next();
        }
        if (len < passed.length) {
            dest[len] = null;
        }
        return dest;
    }

    public static Object seqToTypedArray(ISeq seq) {
        Class<Object> type = seq != null ? seq.first().getClass() : Object.class;
        return RT.seqToTypedArray(type, seq);
    }

    public static Object seqToTypedArray(Class type, ISeq seq) {
        Object ret = Array.newInstance(type, RT.length(seq));
        if (type == Integer.TYPE) {
            int i = 0;
            while (seq != null) {
                Array.set(ret, i, RT.intCast(seq.first()));
                ++i;
                seq = seq.next();
            }
        } else if (type == Byte.TYPE) {
            int i = 0;
            while (seq != null) {
                Array.set(ret, i, RT.byteCast(seq.first()));
                ++i;
                seq = seq.next();
            }
        } else if (type == Float.TYPE) {
            int i = 0;
            while (seq != null) {
                Array.set(ret, i, Float.valueOf(RT.floatCast(seq.first())));
                ++i;
                seq = seq.next();
            }
        } else if (type == Short.TYPE) {
            int i = 0;
            while (seq != null) {
                Array.set(ret, i, RT.shortCast(seq.first()));
                ++i;
                seq = seq.next();
            }
        } else if (type == Character.TYPE) {
            int i = 0;
            while (seq != null) {
                Array.set(ret, i, Character.valueOf(RT.charCast(seq.first())));
                ++i;
                seq = seq.next();
            }
        } else {
            int i = 0;
            while (seq != null) {
                Array.set(ret, i, seq.first());
                ++i;
                seq = seq.next();
            }
        }
        return ret;
    }

    public static int length(ISeq list) {
        int i = 0;
        for (ISeq c = list; c != null; c = c.next()) {
            ++i;
        }
        return i;
    }

    public static int boundedLength(ISeq list, int limit) {
        int i = 0;
        for (ISeq c = list; c != null && i <= limit; ++i, c = c.next()) {
        }
        return i;
    }

    static Character readRet(int ret) {
        if (ret == -1) {
            return null;
        }
        return RT.box((char)ret);
    }

    public static Character readChar(Reader r) throws Exception {
        int ret = r.read();
        return RT.readRet(ret);
    }

    public static Character peekChar(Reader r) throws Exception {
        int ret;
        if (r instanceof PushbackReader) {
            ret = r.read();
            ((PushbackReader)r).unread(ret);
        } else {
            r.mark(1);
            ret = r.read();
            r.reset();
        }
        return RT.readRet(ret);
    }

    public static boolean isReduced(Object r) {
        return r instanceof Reduced;
    }

    public static String printString(Object x) {
        try {
            StringWriter sw = new StringWriter();
            RT.print(x, sw);
            return sw.toString();
        }
        catch (Exception e) {
            throw Util.sneakyThrow(e);
        }
    }

    public static void print(Object x, Writer w) throws IOException {
        ISeq s;
        Obj o;
        if (x instanceof Obj && RT.count((o = (Obj)x).meta()) > 0) {
            IPersistentMap meta = o.meta();
            w.write("#^");
            RT.print(meta, w);
            w.write(32);
        }
        if (x == null) {
            w.write("null");
        } else if (x instanceof ISeq || x instanceof IPersistentList) {
            w.write(40);
            RT.printInnerSeq(RT.seq(x), w);
            w.write(41);
        } else if (x instanceof String) {
            s = (String)x;
            if (!readably) {
                w.write((String)((Object)s));
            } else {
                w.write(34);
                block17: for (int i = 0; i < ((String)((Object)s)).length(); ++i) {
                    char c = ((String)((Object)s)).charAt(i);
                    switch (c) {
                        case '\n': {
                            w.write("\\n");
                            continue block17;
                        }
                        case '\t': {
                            w.write("\\t");
                            continue block17;
                        }
                        case '\r': {
                            w.write("\\r");
                            continue block17;
                        }
                        case '\"': {
                            w.write("\\\"");
                            continue block17;
                        }
                        case '\\': {
                            w.write("\\\\");
                            continue block17;
                        }
                        case '\f': {
                            w.write("\\f");
                            continue block17;
                        }
                        case '\b': {
                            w.write("\\b");
                            continue block17;
                        }
                        default: {
                            w.write(c);
                        }
                    }
                }
                w.write(34);
            }
        } else if (x instanceof IPersistentMap) {
            w.write(123);
            for (s = RT.seq(x); s != null; s = s.next()) {
                IMapEntry e = (IMapEntry)s.first();
                RT.print(e.key(), w);
                w.write(32);
                RT.print(e.val(), w);
                if (s.next() == null) continue;
                w.write(", ");
            }
            w.write(125);
        } else if (x instanceof IPersistentVector) {
            IPersistentVector a = (IPersistentVector)x;
            w.write(91);
            for (int i = 0; i < a.count(); ++i) {
                RT.print(a.nth(i), w);
                if (i >= a.count() - 1) continue;
                w.write(32);
            }
            w.write(93);
        } else if (x instanceof IPersistentSet) {
            w.write("#{");
            for (s = RT.seq(x); s != null; s = s.next()) {
                RT.print(s.first(), w);
                if (s.next() == null) continue;
                w.write(" ");
            }
            w.write(125);
        } else if (x instanceof Character) {
            char c = ((Character)x).charValue();
            if (!readably) {
                w.write(c);
            } else {
                w.write(92);
                switch (c) {
                    case '\n': {
                        w.write("newline");
                        break;
                    }
                    case '\t': {
                        w.write("tab");
                        break;
                    }
                    case ' ': {
                        w.write("space");
                        break;
                    }
                    case '\b': {
                        w.write("backspace");
                        break;
                    }
                    case '\f': {
                        w.write("formfeed");
                        break;
                    }
                    case '\r': {
                        w.write("return");
                        break;
                    }
                    default: {
                        w.write(c);
                    }
                }
            }
        } else if (x instanceof Class) {
            w.write("#=");
            w.write(((Class)x).getName());
        } else if (x instanceof BigDecimal && readably) {
            w.write(x.toString());
            w.write(77);
        } else if (x instanceof BigInt && readably) {
            w.write(x.toString());
            w.write(78);
        } else if (x instanceof BigInteger && readably) {
            w.write(x.toString());
            w.write("BIGINT");
        } else {
            w.write(x.toString());
        }
    }

    private static void printInnerSeq(ISeq x, Writer w) throws IOException {
        for (ISeq s = x; s != null; s = s.next()) {
            RT.print(s.first(), w);
            if (s.next() == null) continue;
            w.write(32);
        }
    }

    public static void formatAesthetic(Writer w, Object obj) throws IOException {
        if (obj == null) {
            w.write("null");
        } else {
            w.write(obj.toString());
        }
    }

    public static void formatStandard(Writer w, Object obj) throws IOException {
        if (obj == null) {
            w.write("null");
        } else if (obj instanceof String) {
            w.write(34);
            w.write((String)obj);
            w.write(34);
        } else if (obj instanceof Character) {
            w.write(92);
            char c = ((Character)obj).charValue();
            switch (c) {
                case '\n': {
                    w.write("newline");
                    break;
                }
                case '\t': {
                    w.write("tab");
                    break;
                }
                case ' ': {
                    w.write("space");
                    break;
                }
                case '\b': {
                    w.write("backspace");
                    break;
                }
                case '\f': {
                    w.write("formfeed");
                    break;
                }
                default: {
                    w.write(c);
                    break;
                }
            }
        } else {
            w.write(obj.toString());
        }
    }

    public static Object format(Object o, String s, Object ... args) throws IOException {
        Writer w = o == null ? new StringWriter() : (Util.equals(o, T) ? new OutputStreamWriter(System.out) : (Writer)o);
        RT.doFormat(w, s, ArraySeq.create(args));
        if (o == null) {
            return w.toString();
        }
        return null;
    }

    public static ISeq doFormat(Writer w, String s, ISeq args) throws IOException {
        int i = 0;
        block12: while (i < s.length()) {
            char c = s.charAt(i++);
            block0 : switch (Character.toLowerCase(c)) {
                case '~': {
                    char d = s.charAt(i++);
                    switch (Character.toLowerCase(d)) {
                        case '%': {
                            w.write(10);
                            break block0;
                        }
                        case 't': {
                            w.write(9);
                            break block0;
                        }
                        case 'a': {
                            if (args == null) {
                                throw new IllegalArgumentException("Missing argument");
                            }
                            RT.formatAesthetic(w, RT.first(args));
                            args = RT.next(args);
                            break block0;
                        }
                        case 's': {
                            if (args == null) {
                                throw new IllegalArgumentException("Missing argument");
                            }
                            RT.formatStandard(w, RT.first(args));
                            args = RT.next(args);
                            break block0;
                        }
                        case '{': {
                            int j = s.indexOf("~}", i);
                            if (j == -1) {
                                throw new IllegalArgumentException("Missing ~}");
                            }
                            String subs = s.substring(i, j);
                            ISeq sargs = RT.seq(RT.first(args));
                            while (sargs != null) {
                                sargs = RT.doFormat(w, subs, sargs);
                            }
                            args = RT.next(args);
                            i = j + 2;
                            break block0;
                        }
                        case '^': {
                            if (args != null) continue block12;
                            return null;
                        }
                        case '~': {
                            w.write(126);
                            break block0;
                        }
                        default: {
                            throw new IllegalArgumentException("Unsupported ~ directive: " + d);
                        }
                    }
                }
                default: {
                    w.write(c);
                }
            }
        }
        return args;
    }

    public static Object[] setValues(Object ... vals) {
        if (vals.length > 0) {
            return vals;
        }
        return null;
    }

    public static float aget(float[] xs, int i) {
        return xs[i];
    }

    public static float aset(float[] xs, int i, float v) {
        xs[i] = v;
        return v;
    }

    public static int alength(float[] xs) {
        return xs.length;
    }

    public static float[] aclone(float[] xs) {
        return (float[])xs.clone();
    }

    public static double aget(double[] xs, int i) {
        return xs[i];
    }

    public static double aset(double[] xs, int i, double v) {
        xs[i] = v;
        return v;
    }

    public static int alength(double[] xs) {
        return xs.length;
    }

    public static double[] aclone(double[] xs) {
        return (double[])xs.clone();
    }

    public static int aget(int[] xs, int i) {
        return xs[i];
    }

    public static int aset(int[] xs, int i, int v) {
        xs[i] = v;
        return v;
    }

    public static int alength(int[] xs) {
        return xs.length;
    }

    public static int[] aclone(int[] xs) {
        return (int[])xs.clone();
    }

    public static long aget(long[] xs, int i) {
        return xs[i];
    }

    public static long aset(long[] xs, int i, long v) {
        xs[i] = v;
        return v;
    }

    public static int alength(long[] xs) {
        return xs.length;
    }

    public static long[] aclone(long[] xs) {
        return (long[])xs.clone();
    }

    public static char aget(char[] xs, int i) {
        return xs[i];
    }

    public static char aset(char[] xs, int i, char v) {
        xs[i] = v;
        return v;
    }

    public static int alength(char[] xs) {
        return xs.length;
    }

    public static char[] aclone(char[] xs) {
        return (char[])xs.clone();
    }

    public static byte aget(byte[] xs, int i) {
        return xs[i];
    }

    public static byte aset(byte[] xs, int i, byte v) {
        xs[i] = v;
        return v;
    }

    public static int alength(byte[] xs) {
        return xs.length;
    }

    public static byte[] aclone(byte[] xs) {
        return (byte[])xs.clone();
    }

    public static short aget(short[] xs, int i) {
        return xs[i];
    }

    public static short aset(short[] xs, int i, short v) {
        xs[i] = v;
        return v;
    }

    public static int alength(short[] xs) {
        return xs.length;
    }

    public static short[] aclone(short[] xs) {
        return (short[])xs.clone();
    }

    public static boolean aget(boolean[] xs, int i) {
        return xs[i];
    }

    public static boolean aset(boolean[] xs, int i, boolean v) {
        xs[i] = v;
        return v;
    }

    public static int alength(boolean[] xs) {
        return xs.length;
    }

    public static boolean[] aclone(boolean[] xs) {
        return (boolean[])xs.clone();
    }

    public static Object aget(Object[] xs, int i) {
        return xs[i];
    }

    public static Object aset(Object[] xs, int i, Object v) {
        xs[i] = v;
        return v;
    }

    public static int alength(Object[] xs) {
        return xs.length;
    }

    public static Object[] aclone(Object[] xs) {
        return (Object[])xs.clone();
    }

    private static final class DefaultComparator
    implements Comparator,
    Serializable {
        private DefaultComparator() {
        }

        public int compare(Object o1, Object o2) {
            return Util.compare(o1, o2);
        }

        private Object readResolve() throws ObjectStreamException {
            return DEFAULT_COMPARATOR;
        }
    }
}

