/*
 * Decompiled with CFR 0.152.
 */
package com.github.krukow.clj_lang;

import com.github.krukow.clj_lang.ASeq;
import com.github.krukow.clj_lang.Counted;
import com.github.krukow.clj_lang.IFn;
import com.github.krukow.clj_lang.IPersistentMap;
import com.github.krukow.clj_lang.IReduce;
import com.github.krukow.clj_lang.ISeq;
import com.github.krukow.clj_lang.Obj;

public class Range
extends ASeq
implements IReduce,
Counted {
    final int end;
    final int n;

    public Range(int start, int end) {
        this.end = end;
        this.n = start;
    }

    public Range(IPersistentMap meta, int start, int end) {
        super(meta);
        this.end = end;
        this.n = start;
    }

    public Obj withMeta(IPersistentMap meta) {
        if (meta == this.meta()) {
            return this;
        }
        return new Range(this.meta(), this.end, this.n);
    }

    public Object first() {
        return this.n;
    }

    public ISeq next() {
        if (this.n < this.end - 1) {
            return new Range(this._meta, this.n + 1, this.end);
        }
        return null;
    }

    public Object reduce(IFn f) {
        Object ret = this.n;
        for (int x = this.n + 1; x < this.end; ++x) {
            ret = f.invoke(ret, x);
        }
        return ret;
    }

    public Object reduce(IFn f, Object start) {
        Object ret = f.invoke(start, this.n);
        for (int x = this.n + 1; x < this.end; ++x) {
            ret = f.invoke(ret, x);
        }
        return ret;
    }

    public int count() {
        return this.end - this.n;
    }
}

