/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.api.sax;

import com.siemens.ct.exi.EXIFactory;
import com.siemens.ct.exi.FidelityOptions;
import com.siemens.ct.exi.api.sax.SAXEncoder;
import com.siemens.ct.exi.exceptions.EXIException;
import com.siemens.ct.exi.util.xml.QNameUtilities;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class SAXEncoderExtendedHandler
extends SAXEncoder {
    protected final boolean preserveDTD;
    protected final boolean preserveComment;
    protected final boolean preservePrefix;
    protected String docTypeName;
    protected String docTypePublicID;
    protected String docTypeSystemID;
    protected String docTypeText;
    protected boolean entityReferenceRange;
    protected boolean dtdRange;
    protected boolean retainEntityReference;

    public SAXEncoderExtendedHandler(EXIFactory factory) throws EXIException {
        super(factory);
        FidelityOptions fo = factory.getFidelityOptions();
        this.preserveDTD = fo.isFidelityEnabled("PRESERVE_DTDS");
        this.preserveComment = fo.isFidelityEnabled("PRESERVE_COMMENTS");
        this.preservePrefix = fo.isFidelityEnabled("PRESERVE_PREFIXES");
        this.retainEntityReference = factory.getEncodingOptions().isOptionEnabled("KEEP_ENTITY_REFERENCES_UNRESOLVED");
    }

    public void startDocument() throws SAXException {
        this.entityReferenceRange = false;
        this.dtdRange = false;
        super.startDocument();
    }

    public void startElement(String uri, String local, String raw, Attributes attributes) throws SAXException {
        try {
            String prefix = null;
            if (this.preservePrefix) {
                prefix = QNameUtilities.getPrefixPart(raw);
            }
            this.startElementPfx(uri, local, prefix, attributes);
        }
        catch (Exception e) {
            throw new SAXException("startElement: " + raw, e);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.preserveDTD && this.entityReferenceRange) {
            if (!this.retainEntityReference) {
                super.characters(ch, start, length);
            }
        } else {
            super.characters(ch, start, length);
        }
    }

    public void comment(char[] ch, int start, int length) throws SAXException {
        if (this.dtdRange) {
            if (this.preserveDTD) {
                this.docTypeText = this.docTypeText + "<!--" + new String(ch, start, length) + "-->";
            }
        } else if (this.preserveComment) {
            try {
                this.checkPendingChars();
                this.encoder.encodeComment(ch, start, length);
            }
            catch (Exception e) {
                throw new SAXException("comment", e);
            }
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        try {
            if (this.dtdRange) {
                if (this.preserveDTD) {
                    this.docTypeText = this.docTypeText + "<?" + target + " " + data + "?>";
                }
            } else {
                this.checkPendingChars();
                this.encoder.encodeProcessingInstruction(target, data);
            }
        }
        catch (Exception e) {
            throw new SAXException("processingInstruction", e);
        }
    }

    public void startCDATA() throws SAXException {
    }

    public void endCDATA() throws SAXException {
    }

    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        try {
            if (this.preserveDTD) {
                this.checkPendingChars();
                this.docTypeName = name;
                this.docTypePublicID = publicId == null ? "" : publicId;
                this.docTypeSystemID = systemId == null ? "" : systemId;
                this.docTypeText = "";
            }
            this.dtdRange = true;
        }
        catch (Exception e) {
            throw new SAXException("startDTD", e);
        }
    }

    public void endDTD() throws SAXException {
        try {
            if (this.preserveDTD) {
                this.encoder.encodeDocType(this.docTypeName, this.docTypePublicID, this.docTypeSystemID, this.docTypeText);
            }
            this.dtdRange = false;
        }
        catch (Exception e) {
            throw new SAXException("endDTD", e);
        }
    }

    public void startEntity(String name) throws SAXException {
        if (this.preserveDTD && this.retainEntityReference) {
            try {
                this.checkPendingChars();
            }
            catch (Exception e) {
                throw new SAXException("startEntity", e);
            }
        }
        this.entityReferenceRange = true;
    }

    public void endEntity(String name) throws SAXException {
        try {
            if (this.preserveDTD && this.entityReferenceRange && this.retainEntityReference && !name.startsWith("%") && !name.equals("[dtd]")) {
                this.encoder.encodeEntityReference(name);
            }
            this.entityReferenceRange = false;
        }
        catch (Exception e) {
            throw new SAXException("endEntity " + name, e);
        }
    }

    public void skippedEntity(String name) throws SAXException {
        try {
            if (this.preserveDTD) {
                this.encoder.encodeEntityReference(name);
            }
        }
        catch (Exception e) {
            throw new SAXException("skippedEntity " + name, e);
        }
    }

    public void notationDecl(String name, String publicId, String systemId) throws SAXException {
    }

    public void unparsedEntityDecl(String name, String publicId, String systemId, String notationName) throws SAXException {
    }

    public void elementDecl(String name, String model) throws SAXException {
        if (this.preserveDTD) {
            this.docTypeText = this.docTypeText + "<!ELEMENT " + name + " " + model + "> ";
        }
    }

    public void attributeDecl(String eName, String aName, String type, String mode, String value) throws SAXException {
        if (this.preserveDTD) {
            this.docTypeText = this.docTypeText + "<!ATTLIST " + eName + " " + aName + " " + type + " " + mode + "> ";
        }
    }

    public void internalEntityDecl(String name, String value) throws SAXException {
        if (this.preserveDTD) {
            this.docTypeText = this.docTypeText + "<!ENTITY " + name + " \"" + value + "\"> ";
        }
    }

    public void externalEntityDecl(String name, String publicId, String systemId) throws SAXException {
    }
}

