/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.core;

import com.siemens.ct.exi.EXIFactory;
import com.siemens.ct.exi.core.EXIBodyEncoderInOrder;
import com.siemens.ct.exi.exceptions.EXIException;
import com.siemens.ct.exi.exceptions.ErrorHandler;
import com.siemens.ct.exi.grammars.event.EventType;
import com.siemens.ct.exi.values.Value;
import java.io.IOException;
import javax.xml.namespace.QName;

public class EXIBodyEncoderInOrderSC
extends EXIBodyEncoderInOrder {
    protected EXIBodyEncoderInOrderSC scEncoder;

    public EXIBodyEncoderInOrderSC(EXIFactory exiFactory) throws EXIException {
        super(exiFactory);
    }

    protected void initForEachRun() throws EXIException, IOException {
        super.initForEachRun();
        this.scEncoder = null;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        if (this.scEncoder == null) {
            super.setErrorHandler(errorHandler);
        } else {
            this.scEncoder.setErrorHandler(errorHandler);
        }
    }

    public void encodeStartDocument() throws EXIException, IOException {
        if (this.scEncoder == null) {
            super.encodeStartDocument();
        } else {
            this.scEncoder.encodeStartDocument();
        }
    }

    public void encodeEndDocument() throws EXIException, IOException {
        if (this.scEncoder == null) {
            super.encodeEndDocument();
        } else {
            this.scEncoder.encodeEndDocument();
        }
    }

    protected void encodeEndSC() throws EXIException, IOException {
        this.scEncoder.encodeEndDocument();
        this.channel.align();
        this.scEncoder = null;
        super.popElement();
    }

    public void encodeStartElement(String uri, String localName, String prefix) throws EXIException, IOException {
        if (this.scEncoder == null) {
            super.encodeStartElement(uri, localName, prefix);
            QName qname = this.getElementContext().qnameContext.getQName();
            if (this.exiFactory.isSelfContainedElement(qname)) {
                int ec2 = this.getCurrentGrammar().get2ndLevelEventCode(EventType.SELF_CONTAINED, this.fidelityOptions);
                this.encode2ndLevelEventCode(ec2);
                this.channel.align();
                this.encodeStartSC(uri, localName, prefix);
            }
        } else {
            this.scEncoder.encodeStartElement(uri, localName, prefix);
        }
    }

    protected void encodeStartSC(String uri, String localName, String prefix) throws EXIException, IOException {
        EXIFactory scEXIFactory = this.exiFactory.clone();
        scEXIFactory.setFragment(true);
        this.scEncoder = (EXIBodyEncoderInOrderSC)scEXIFactory.createEXIBodyEncoder();
        this.scEncoder.channel = this.channel;
        this.scEncoder.setErrorHandler(this.errorHandler);
        this.scEncoder.encodeStartDocument();
        this.scEncoder.encodeStartElementNoSC(uri, localName, prefix);
        if (this.preservePrefix) {
            this.scEncoder.encodeNamespaceDeclaration(uri, prefix);
        }
    }

    protected void encodeStartElementNoSC(String uri, String localName, String prefix) throws EXIException, IOException {
        super.encodeStartElement(uri, localName, prefix);
    }

    public void encodeEndElement() throws EXIException, IOException {
        if (this.scEncoder == null) {
            super.encodeEndElement();
        } else {
            QName qname = this.scEncoder.getElementContext().qnameContext.getQName();
            this.scEncoder.encodeEndElement();
            if (this.getElementContext().qnameContext.getQName().equals(qname) && this.scEncoder.getCurrentGrammar().getProduction(EventType.END_DOCUMENT) != null) {
                this.encodeEndSC();
            }
        }
    }

    public void encodeAttribute(String uri, String localName, String prefix, Value value) throws EXIException, IOException {
        if (this.scEncoder == null) {
            super.encodeAttribute(uri, localName, prefix, value);
        } else {
            this.scEncoder.encodeAttribute(uri, localName, prefix, value);
        }
    }

    public void encodeAttribute(QName at, Value value) throws EXIException, IOException {
        if (this.scEncoder == null) {
            super.encodeAttribute(at, value);
        } else {
            this.scEncoder.encodeAttribute(at, value);
        }
    }

    public void encodeNamespaceDeclaration(String uri, String prefix) throws EXIException, IOException {
        if (this.scEncoder == null) {
            super.encodeNamespaceDeclaration(uri, prefix);
        } else {
            this.scEncoder.encodeNamespaceDeclaration(uri, prefix);
        }
    }

    public void encodeAttributeXsiNil(Value nil, String pfx) throws EXIException, IOException {
        if (this.scEncoder == null) {
            super.encodeAttributeXsiNil(nil, pfx);
        } else {
            this.scEncoder.encodeAttributeXsiNil(nil, pfx);
        }
    }

    public void encodeAttributeXsiType(Value type, String pfx) throws EXIException, IOException {
        if (this.scEncoder == null) {
            super.encodeAttributeXsiType(type, pfx);
        } else {
            this.scEncoder.encodeAttributeXsiType(type, pfx);
        }
    }

    public void encodeCharacters(Value chars) throws EXIException, IOException {
        if (this.scEncoder == null) {
            super.encodeCharacters(chars);
        } else {
            this.scEncoder.encodeCharacters(chars);
        }
    }

    public void encodeDocType(String name, String publicID, String systemID, String text) throws EXIException, IOException {
        if (this.scEncoder == null) {
            super.encodeDocType(name, publicID, systemID, text);
        } else {
            this.scEncoder.encodeDocType(name, publicID, systemID, text);
        }
    }

    public void encodeEntityReference(String name) throws EXIException, IOException {
        if (this.scEncoder == null) {
            super.encodeEntityReference(name);
        } else {
            this.scEncoder.encodeEntityReference(name);
        }
    }

    public void encodeComment(char[] ch, int start, int length) throws EXIException, IOException {
        if (this.scEncoder == null) {
            super.encodeComment(ch, start, length);
        } else {
            this.scEncoder.encodeComment(ch, start, length);
        }
    }

    public void encodeProcessingInstruction(String target, String data) throws EXIException, IOException {
        if (this.scEncoder == null) {
            super.encodeProcessingInstruction(target, data);
        } else {
            this.scEncoder.encodeProcessingInstruction(target, data);
        }
    }
}

