/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.grammars.grammar;

import com.siemens.ct.exi.FidelityOptions;
import com.siemens.ct.exi.grammars.event.Attribute;
import com.siemens.ct.exi.grammars.event.Event;
import com.siemens.ct.exi.grammars.event.EventType;
import com.siemens.ct.exi.grammars.event.StartElement;
import com.siemens.ct.exi.grammars.grammar.AbstractGrammar;
import com.siemens.ct.exi.grammars.grammar.BuiltInGrammar;
import com.siemens.ct.exi.grammars.grammar.Grammar;
import com.siemens.ct.exi.grammars.production.Production;
import com.siemens.ct.exi.grammars.production.SchemaLessProduction;
import com.siemens.ct.exi.util.MethodsBag;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class AbstractBuiltInGrammar
extends AbstractGrammar
implements BuiltInGrammar {
    private static final long serialVersionUID = -4412097592336436189L;
    protected List<Production> containers = new ArrayList<Production>();
    protected int ec1Length = 0;

    public void stopLearning() {
        if (this.stopLearningContainerSize == -1) {
            this.stopLearningContainerSize = this.containers.size();
        }
    }

    public final boolean isSchemaInformed() {
        return false;
    }

    public boolean hasSecondOrThirdLevel(FidelityOptions fidelityOptions) {
        return true;
    }

    public Grammar getTypeEmpty() {
        return this;
    }

    public int get1stLevelEventCodeLength(FidelityOptions fidelityOptions) {
        return this.ec1Length;
    }

    public int getNumberOfEvents() {
        return this.containers.size();
    }

    public final void addProduction(Event event, Grammar grammar) {
        this.containers.add(new SchemaLessProduction(this, grammar, event, this.getNumberOfEvents()));
        this.ec1Length = MethodsBag.getCodingLength(this.containers.size() + 1);
    }

    protected boolean contains(Event event) {
        Iterator<Production> iter = this.containers.iterator();
        while (iter.hasNext()) {
            if (!iter.next().getEvent().equals(event)) continue;
            return true;
        }
        return false;
    }

    public int getNumberOfDeclaredAttributes() {
        throw new RuntimeException("Schema-related attribute dealing in schema-less case");
    }

    public int getLeastAttributeEventCode() {
        throw new RuntimeException("Schema-related attribute dealing in schema-less case");
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.getLabel() + "//" + "\t");
        sb.append("[");
        for (int ec = 0; ec < this.getNumberOfEvents(); ++ec) {
            sb.append("," + this.getProduction(ec).getEvent());
        }
        sb.append("]");
        return sb.toString();
    }

    public Production getProduction(EventType eventType) {
        for (Production ei : this.containers) {
            if (!ei.getEvent().isEventType(eventType) || this.isExiProfilGhostNode(ei)) continue;
            return ei;
        }
        return null;
    }

    private final boolean isExiProfilGhostNode(Production ei) {
        if (this.stopLearningContainerSize == -1) {
            return false;
        }
        return ei.getEventCode() < this.getNumberOfEvents() - this.stopLearningContainerSize;
    }

    public Production getStartElementProduction(String namespaceURI, String localName) {
        for (Production ei : this.containers) {
            if (!ei.getEvent().isEventType(EventType.START_ELEMENT) || !AbstractBuiltInGrammar.checkQualifiedName(((StartElement)ei.getEvent()).getQName(), namespaceURI, localName) || this.isExiProfilGhostNode(ei)) continue;
            return ei;
        }
        return null;
    }

    public Production getStartElementNSProduction(String namespaceURI) {
        return null;
    }

    public Production getAttributeProduction(String namespaceURI, String localName) {
        for (Production ei : this.containers) {
            if (!ei.getEvent().isEventType(EventType.ATTRIBUTE) || !AbstractBuiltInGrammar.checkQualifiedName(((Attribute)ei.getEvent()).getQName(), namespaceURI, localName) || this.isExiProfilGhostNode(ei)) continue;
            return ei;
        }
        return null;
    }

    public Production getAttributeNSProduction(String namespaceURI) {
        return null;
    }

    public Production getProduction(int eventCode) {
        assert (eventCode >= 0 && eventCode < this.containers.size());
        return this.containers.get(this.getNumberOfEvents() - 1 - eventCode);
    }
}

