/*
 * Decompiled with CFR 0.152.
 */
package com.siemens.ct.exi.values;

import com.siemens.ct.exi.exceptions.XMLParsingException;
import com.siemens.ct.exi.types.DateTimeType;
import com.siemens.ct.exi.util.MethodsBag;
import com.siemens.ct.exi.values.AbstractValue;
import com.siemens.ct.exi.values.ValueType;
import java.io.IOException;
import java.util.Calendar;
import java.util.TimeZone;

public class DateTimeValue
extends AbstractValue {
    private static final long serialVersionUID = 298943383646546462L;
    public static final int NUMBER_BITS_MONTHDAY = 9;
    public static final int NUMBER_BITS_TIME = 17;
    public static final int NUMBER_BITS_TIMEZONE = 11;
    public static final int YEAR_OFFSET = 2000;
    public static final int TIMEZONE_OFFSET_IN_MINUTES = 896;
    public static final int MONTH_MULTIPLICATOR = 32;
    public final DateTimeType type;
    public final int year;
    public final int monthDay;
    public final int time;
    public final boolean presenceFractionalSecs;
    public final int fractionalSecs;
    public final boolean presenceTimezone;
    public final int timezone;
    protected Calendar cal;
    int sizeFractionalSecs = -1;

    public DateTimeValue(DateTimeType type, int year, int monthDay, int time, boolean presenceFractionalSecs, int fractionalSecs, boolean presenceTimezone, int timezone) {
        super(ValueType.DATETIME);
        this.type = type;
        this.year = year;
        this.monthDay = monthDay;
        this.time = time;
        this.presenceFractionalSecs = presenceFractionalSecs;
        this.fractionalSecs = fractionalSecs;
        this.presenceTimezone = presenceTimezone;
        this.timezone = timezone;
    }

    public static DateTimeValue parse(String cal, DateTimeType type) {
        cal = cal.trim();
        int sYear = 0;
        int sMonthDay = 0;
        int sTime = 0;
        boolean sPresenceFractionalSecs = false;
        int sFractionalSecs = 0;
        StringBuilder sbCal = new StringBuilder(cal);
        try {
            int sTimezone;
            boolean sPresenceTimezone;
            switch (type) {
                case gYear: {
                    sYear = DateTimeValue.parseYear(sbCal);
                    break;
                }
                case gYearMonth: {
                    sYear = DateTimeValue.parseYear(sbCal);
                    DateTimeValue.checkCharacter(sbCal, '-');
                    sMonthDay = DateTimeValue.parseMonth(sbCal) * 32;
                    break;
                }
                case date: {
                    sYear = DateTimeValue.parseYear(sbCal);
                    DateTimeValue.checkCharacter(sbCal, '-');
                    sMonthDay = DateTimeValue.parseMonthDay(sbCal);
                    break;
                }
                case dateTime: {
                    sYear = DateTimeValue.parseYear(sbCal);
                    DateTimeValue.checkCharacter(sbCal, '-');
                    sMonthDay = DateTimeValue.parseMonthDay(sbCal);
                    DateTimeValue.checkCharacter(sbCal, 'T');
                }
                case time: {
                    sTime = DateTimeValue.parseTime(sbCal);
                    if (sbCal.length() <= 0 || sbCal.charAt(0) != '.') break;
                    sbCal.deleteCharAt(0);
                    int digits = DateTimeValue.countDigits(sbCal);
                    sFractionalSecs = Integer.parseInt(new StringBuilder(sbCal.substring(0, digits)).reverse().toString());
                    sPresenceFractionalSecs = true;
                    sbCal.delete(0, digits);
                    break;
                }
                case gMonth: {
                    DateTimeValue.checkCharacter(sbCal, '-');
                    DateTimeValue.checkCharacter(sbCal, '-');
                    sMonthDay = DateTimeValue.parseMonth(sbCal) * 32;
                    if (sbCal.length() <= 1 || sbCal.charAt(0) != sbCal.charAt(1) || sbCal.charAt(0) != '-') break;
                    DateTimeValue.checkCharacter(sbCal, '-');
                    DateTimeValue.checkCharacter(sbCal, '-');
                    break;
                }
                case gMonthDay: {
                    DateTimeValue.checkCharacter(sbCal, '-');
                    DateTimeValue.checkCharacter(sbCal, '-');
                    sMonthDay = DateTimeValue.parseMonthDay(sbCal);
                    break;
                }
                case gDay: {
                    DateTimeValue.checkCharacter(sbCal, '-');
                    DateTimeValue.checkCharacter(sbCal, '-');
                    DateTimeValue.checkCharacter(sbCal, '-');
                    sMonthDay = DateTimeValue.parseDay(sbCal);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            if (sbCal.length() == 0) {
                sPresenceTimezone = false;
                sTimezone = 0;
            } else if (sbCal.length() == 1 && sbCal.charAt(0) == 'Z') {
                sbCal.delete(0, 1);
                sPresenceTimezone = true;
                sTimezone = 0;
            } else {
                int multiplicator;
                sPresenceTimezone = true;
                if (sbCal.charAt(0) == '+') {
                    multiplicator = 1;
                } else if (sbCal.charAt(0) == '-') {
                    multiplicator = -1;
                } else {
                    throw new XMLParsingException("Unexpected character while parsing");
                }
                int hours = Integer.parseInt(sbCal.substring(1, 3));
                assert (sbCal.charAt(3) == ':');
                int minutes = Integer.parseInt(sbCal.substring(4, 6));
                sTimezone = multiplicator * (hours * 64 + minutes);
            }
            return new DateTimeValue(type, sYear, sMonthDay, sTime, sPresenceFractionalSecs, sFractionalSecs, sPresenceTimezone, sTimezone);
        }
        catch (RuntimeException e) {
            return null;
        }
        catch (XMLParsingException e) {
            return null;
        }
    }

    protected static int parseYear(StringBuilder sb) {
        int len;
        String sYear;
        if (sb.charAt(0) == '-') {
            sYear = sb.substring(0, 5);
            len = 5;
        } else {
            sYear = sb.substring(0, 4);
            len = 4;
        }
        int year = Integer.parseInt(sYear);
        sb.delete(0, len);
        return year;
    }

    protected static void checkCharacter(StringBuilder sb, char c) throws XMLParsingException {
        if (sb.length() <= 0 || sb.charAt(0) != c) {
            throw new XMLParsingException("Unexpected character while parsing");
        }
        sb.delete(0, 1);
    }

    protected static int parseMonth(StringBuilder sb) {
        int month = Integer.parseInt(sb.substring(0, 2));
        sb.delete(0, 2);
        return month;
    }

    protected static int parseDay(StringBuilder sb) {
        String sDay = sb.substring(0, 2);
        int day = Integer.parseInt(sDay);
        sb.delete(0, 2);
        return day;
    }

    protected static int parseMonthDay(StringBuilder sb) throws XMLParsingException {
        int month = DateTimeValue.parseMonth(sb);
        DateTimeValue.checkCharacter(sb, '-');
        int day = DateTimeValue.parseDay(sb);
        return month * 32 + day;
    }

    protected static int parseTime(StringBuilder sb) throws XMLParsingException {
        int hour = Integer.parseInt(sb.substring(0, 2));
        sb.delete(0, 2);
        DateTimeValue.checkCharacter(sb, ':');
        int minutes = Integer.parseInt(sb.substring(0, 2));
        sb.delete(0, 2);
        DateTimeValue.checkCharacter(sb, ':');
        int seconds = Integer.parseInt(sb.substring(0, 2));
        sb.delete(0, 2);
        return (hour * 64 + minutes) * 64 + seconds;
    }

    private static int countDigits(StringBuilder sb) {
        int index;
        int length = sb.length();
        for (index = 0; index < length && DateTimeValue.isDigit(sb.charAt(index)); ++index) {
        }
        return index;
    }

    private static boolean isDigit(char c) {
        boolean isDigit = false;
        char[] digits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
        for (int i = 0; !isDigit && i < digits.length; ++i) {
            if (c != digits[i]) continue;
            isDigit = true;
        }
        return isDigit;
    }

    public static DateTimeValue parse(Calendar cal, DateTimeType type) throws IOException {
        int sYear = 0;
        int sMonthDay = 0;
        int sTime = 0;
        boolean sPresenceFractionalSecs = false;
        int sFractionalSecs = 0;
        boolean sPresenceTimezone = false;
        switch (type) {
            case gYear: 
            case gYearMonth: 
            case date: {
                sYear = cal.get(1);
                sMonthDay = DateTimeValue.getMonthDay(cal);
                break;
            }
            case dateTime: {
                sYear = cal.get(1);
                sMonthDay = DateTimeValue.getMonthDay(cal);
            }
            case time: {
                sTime = DateTimeValue.getTime(cal);
                sFractionalSecs = cal.get(14);
                if (sFractionalSecs == 0) break;
                sPresenceFractionalSecs = true;
                break;
            }
            case gMonth: 
            case gMonthDay: 
            case gDay: {
                sMonthDay = DateTimeValue.getMonthDay(cal);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        int sTimezone = DateTimeValue.getTimeZoneInMinutesOffset(cal);
        if (sTimezone != 0) {
            sPresenceTimezone = true;
        }
        return new DateTimeValue(type, sYear, sMonthDay, sTime, sPresenceFractionalSecs, sFractionalSecs, sPresenceTimezone, sTimezone);
    }

    public static int getMonthDay(Calendar cal) {
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        int monthDay = month * 32 + day;
        return monthDay;
    }

    public static int getTime(Calendar cal) {
        int time = cal.get(11);
        time *= 64;
        time += cal.get(12);
        time *= 64;
        return time += cal.get(13);
    }

    public Calendar toCalendar() {
        if (this.cal == null) {
            Calendar cal = Calendar.getInstance();
            cal.clear();
            switch (this.type) {
                case gYear: {
                    cal.set(1, this.year);
                    break;
                }
                case gYearMonth: 
                case date: {
                    cal.set(1, this.year);
                    DateTimeValue.setMonthDay(this.monthDay, cal);
                    break;
                }
                case dateTime: {
                    cal.set(1, this.year);
                    DateTimeValue.setMonthDay(this.monthDay, cal);
                    DateTimeValue.setTime(this.time, cal);
                    cal.set(14, this.fractionalSecs);
                    break;
                }
                case gMonth: 
                case gMonthDay: 
                case gDay: {
                    DateTimeValue.setMonthDay(this.monthDay, cal);
                    break;
                }
                case time: {
                    DateTimeValue.setTime(this.time, cal);
                    cal.set(14, this.fractionalSecs);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            DateTimeValue.setTimezone(cal, this.timezone);
        }
        return this.cal;
    }

    protected static void setMonthDay(int monthDay, Calendar cal) {
        int month = monthDay / 32;
        cal.set(2, month - 1);
        int day = monthDay - month * 32;
        cal.set(5, day);
    }

    protected static void setTime(int time, Calendar cal) {
        int hour = time / 4096;
        int minute = (time -= hour * 4096) / 64;
        cal.set(11, hour);
        cal.set(12, minute);
        cal.set(13, time -= minute * 64);
    }

    protected static int getTimeZoneInMinutesOffset(Calendar cal) {
        return cal.getTimeZone().getRawOffset() / 60000 + 896;
    }

    protected static int getTimeZoneInMillisecs(int minutes) {
        return minutes * 60000;
    }

    public int getCharactersLength() {
        if (this.slen == -1) {
            switch (this.type) {
                case gYear: {
                    this.slen = this.year < 0 ? 5 : 4;
                    break;
                }
                case gYearMonth: {
                    this.slen = (this.year < 0 ? 5 : 4) + 3;
                    break;
                }
                case date: {
                    this.slen = (this.year < 0 ? 5 : 4) + 6;
                    break;
                }
                case dateTime: {
                    this.sizeFractionalSecs = this.fractionalSecs == 0 ? 0 : MethodsBag.getStringSize(this.fractionalSecs) + 1;
                    this.slen = (this.year < 0 ? 5 : 4) + 6 + 9 + this.sizeFractionalSecs;
                    break;
                }
                case gMonth: {
                    this.slen = 4;
                    break;
                }
                case gMonthDay: {
                    this.slen = 7;
                    break;
                }
                case gDay: {
                    this.slen = 5;
                    break;
                }
                case time: {
                    this.sizeFractionalSecs = this.fractionalSecs == 0 ? 0 : MethodsBag.getStringSize(this.fractionalSecs) + 1;
                    this.slen = 8 + this.sizeFractionalSecs;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
            if (this.presenceTimezone) {
                this.slen += this.timezone == 0 ? 1 : 6;
            }
        }
        return this.slen;
    }

    public void getCharacters(char[] cbuffer, int offset) {
        switch (this.type) {
            case gYear: {
                offset = DateTimeValue.appendYear(cbuffer, offset, this.year);
                break;
            }
            case gYearMonth: {
                offset = DateTimeValue.appendYear(cbuffer, offset, this.year);
                offset = DateTimeValue.appendMonth(cbuffer, offset, this.monthDay);
                break;
            }
            case date: {
                offset = DateTimeValue.appendYear(cbuffer, offset, this.year);
                offset = DateTimeValue.appendMonthDay(cbuffer, offset, this.monthDay);
                break;
            }
            case dateTime: {
                offset = DateTimeValue.appendYear(cbuffer, offset, this.year);
                offset = DateTimeValue.appendMonthDay(cbuffer, offset, this.monthDay);
                cbuffer[offset++] = 84;
                offset = DateTimeValue.appendTime(cbuffer, offset, this.time);
                assert (this.sizeFractionalSecs != -1);
                offset = DateTimeValue.appendFractionalSeconds(cbuffer, offset, this.fractionalSecs, this.sizeFractionalSecs - 1);
                break;
            }
            case gMonth: {
                cbuffer[offset++] = 45;
                offset = DateTimeValue.appendMonth(cbuffer, offset, this.monthDay);
                break;
            }
            case gMonthDay: {
                cbuffer[offset++] = 45;
                offset = DateTimeValue.appendMonthDay(cbuffer, offset, this.monthDay);
                break;
            }
            case gDay: {
                cbuffer[offset++] = 45;
                cbuffer[offset++] = 45;
                cbuffer[offset++] = 45;
                offset = DateTimeValue.appendDay(cbuffer, offset, this.monthDay);
                break;
            }
            case time: {
                offset = DateTimeValue.appendTime(cbuffer, offset, this.time);
                assert (this.sizeFractionalSecs != -1);
                offset = DateTimeValue.appendFractionalSeconds(cbuffer, offset, this.fractionalSecs, this.sizeFractionalSecs - 1);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        if (this.presenceTimezone) {
            DateTimeValue.appendTimezone(cbuffer, offset, this.timezone);
        }
    }

    private static void setTimezone(Calendar cal, int tz) {
        TimeZone tzO = TimeZone.getTimeZone("GMT+00:00");
        tzO.setRawOffset(tz);
        cal.setTimeZone(tzO);
    }

    private static int appendTimezone(char[] ca, int index, int tz) {
        if (tz == 0) {
            ca[index++] = 90;
        } else {
            if (tz < 0) {
                ca[index++] = 45;
                tz *= -1;
            } else {
                ca[index++] = 43;
            }
            int hours = tz / 64;
            index = DateTimeValue.appendTwoDigits(ca, index, hours);
            ca[index++] = 58;
            int minutes = tz - hours * 64;
            index = DateTimeValue.appendTwoDigits(ca, index, minutes);
        }
        return index;
    }

    private static int appendFractionalSeconds(char[] ca, int index, int fracSecs, int sLen) {
        if (fracSecs > 0) {
            ca[index++] = 46;
            index += MethodsBag.itosReverse(fracSecs, index, ca);
        }
        return index;
    }

    private static int appendTwoDigits(char[] ca, int index, int i) {
        if (i > 9) {
            index += 2;
        } else {
            ca[index++] = 48;
            ++index;
        }
        MethodsBag.itos(i, index, ca);
        return index;
    }

    private static int appendYear(char[] ca, int index, int year) {
        if (year < 0) {
            ca[index] = 45;
            ++index;
            year = -year;
        }
        if (year > 999) {
            index += 4;
        } else if (year > 99) {
            ca[index++] = 48;
            index += 3;
        } else if (year > 9) {
            ca[index++] = 48;
            ca[index++] = 48;
            index += 2;
        } else {
            ca[index++] = 48;
            ca[index++] = 48;
            ca[index++] = 48;
            ++index;
        }
        MethodsBag.itos(year, index, ca);
        return index;
    }

    private static int appendMonth(char[] ca, int index, int monthDay) {
        int month = monthDay / 32;
        assert (monthDay - month * 32 == 0);
        ca[index++] = 45;
        return DateTimeValue.appendTwoDigits(ca, index, month);
    }

    private static int appendMonthDay(char[] ca, int index, int monthDay) {
        int month = monthDay / 32;
        int day = monthDay - month * 32;
        ca[index++] = 45;
        index = DateTimeValue.appendTwoDigits(ca, index, month);
        ca[index++] = 45;
        return DateTimeValue.appendTwoDigits(ca, index, day);
    }

    private static int appendDay(char[] ca, int index, int day) {
        assert (day < 31);
        return DateTimeValue.appendTwoDigits(ca, index, day);
    }

    private static int appendTime(char[] ca, int index, int time) {
        int secHour = 4096;
        int secMinute = 64;
        int hour = time / 4096;
        int minutes = (time -= hour * 4096) / 64;
        int seconds = time - minutes * 64;
        index = DateTimeValue.appendTwoDigits(ca, index, hour);
        ca[index++] = 58;
        index = DateTimeValue.appendTwoDigits(ca, index, minutes);
        ca[index++] = 58;
        index = DateTimeValue.appendTwoDigits(ca, index, seconds);
        return index;
    }

    protected final boolean _equals(DateTimeValue o) {
        if (this.type == o.type && this.year == o.year && this.monthDay == o.monthDay && this.time == o.time) {
            if (this.presenceFractionalSecs == o.presenceFractionalSecs && this.fractionalSecs != o.fractionalSecs) {
                return false;
            }
            return this.presenceTimezone != o.presenceTimezone || this.timezone == o.timezone;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof DateTimeValue) {
            return this._equals((DateTimeValue)o);
        }
        DateTimeValue dt = DateTimeValue.parse(o.toString(), this.type);
        return dt == null ? false : this._equals(dt);
    }

    public int hashCode() {
        return this.type.hashCode() ^ this.year ^ this.monthDay ^ this.time ^ (this.presenceFractionalSecs ? 1 : 0) ^ this.fractionalSecs ^ (this.presenceTimezone ? 1 : 0) ^ this.timezone;
    }
}

